# jprefpanel.tcl - preference panel(s) and related tools
# 
# Copyright 1992-1994 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for nonprofit, noncommercial use.
# 
# 
# these procedures are required by (at least)
#     browser.tk
#     edit.tk
#     help.tk
#     more.tk
#     people.tk
#     prefs.tk
######################################################################

### TO DO
###   j:parse_args -boolean (and maybe -position?)
###   documentation

######################################################################
# global variables:
#
global J_PREFS env
if {! [info exists J_PREFS(autoposition)]} {set J_PREFS(autoposition) 0}
if {! [info exists J_PREFS(confirm)]} {set J_PREFS(confirm) 1}
#
######################################################################


######################################################################
# j:global_pref_panel ?options? - preferences panel for ~/.tk/defaults
# options include
#   -title - title of toplevel window
### ADD COLOURS?
######################################################################

proc j:global_pref_panel { args } {
  global env tk_strictMotif J_PREFS
  j:parse_args { {title "Global Preferences"} }
  
  set tl .prefs
  
  toplevel $tl
  wm title $tl $title

  checkbutton $tl.autoposition -relief flat -anchor w \
    -text {Auto-position dialogue boxes} \
    -variable J_PREFS(autoposition)
  checkbutton $tl.confirm -relief flat -anchor w \
    -text {Confirm actions} \
    -variable J_PREFS(confirm)
  checkbutton $tl.j_fs_fast -relief flat -anchor w \
    -text {Fast file selector} \
    -variable J_PREFS(j_fs_fast)
  checkbutton $tl.motif -relief flat -anchor w \
    -text {Strict Motif emulation} \
    -variable J_PREFS(tk_strictMotif)
  checkbutton $tl.scrollbarside -relief flat -anchor w \
    -text {Scrollbars on left} \
    -variable J_PREFS(scrollbarside) \
    -onvalue left -offvalue right
  checkbutton $tl.visiblebell -relief flat -anchor w \
    -text {Visible bell} \
    -variable J_PREFS(visiblebell)
  checkbutton $tl.audiblebell -relief flat -anchor w \
    -text {Audible bell} \
    -variable J_PREFS(audiblebell)
  frame $tl.bindings
  radiobutton $tl.bindings.basic -relief flat -anchor w \
    -text {Basic bindings} \
    -variable J_PREFS(bindings) -value basic
  radiobutton $tl.bindings.vi -relief flat -anchor w \
    -text {vi bindings} \
    -variable J_PREFS(bindings) -value vi
  radiobutton $tl.bindings.edt -relief flat -anchor w \
    -text {EDT bindings} \
    -variable J_PREFS(bindings) -value edt
  radiobutton $tl.bindings.emacs -relief flat -anchor w \
    -text {Emacs bindings} \
    -variable J_PREFS(bindings) -value emacs
  checkbutton $tl.bindings.typeover -relief flat -anchor w \
    -text {Typing replaces selection} \
    -variable J_PREFS(typeover)
  frame $tl.printer
  label $tl.printer.l -text {Printer:}
  entry $tl.printer.e -relief sunken -width 25 \
    -textvariable J_PREFS(printer)

  j:buttonbar $tl.b -default save -buttons [format {
    {
      save Save {
        j:write_prefs
        destroy %s
      }
    } {
      done Done {
        destroy %s
      }
    }
  } $tl $tl]
  
  pack $tl.bindings.basic \
    $tl.bindings.vi \
    $tl.bindings.edt \
    $tl.bindings.emacs \
    $tl.bindings.typeover \
    -in $tl.bindings -side top -expand yes -fill x
  pack $tl.printer.l -in $tl.printer -side left
  pack $tl.printer.e -in $tl.printer \
    -expand yes -side left -padx 10 -pady 10

  pack $tl.autoposition \
    $tl.confirm \
    $tl.j_fs_fast \
    $tl.motif \
    $tl.scrollbarside \
    $tl.visiblebell \
    $tl.audiblebell \
    -in $tl -side top -expand yes -fill x
  pack [j:rule $tl] -in $tl -side top -fill x
  pack $tl.bindings -in $tl -side top -expand yes -fill x
  pack [j:rule $tl] -in $tl -side top -fill x
  pack $tl.printer -in $tl -side top -expand yes -fill x
  pack [j:rule $tl] -in $tl -side top -fill x
  pack $tl.b -in $tl -side top -expand yes -fill x

  j:dialogue $tl		;# position in centre of screen

  focus $tl
  j:default_button $tl.b.save \
    $tl.printer.e \
    $tl

  bind $tl <Key-Tab> {focus $tl.printer.e}
  grab $tl
  tkwait window $tl
}
