# jtkversion.tcl - procedures to deal with multiple Tk versions
# 
# Copyright 1995 by Jay Sekora.  All rights reserved, except 
# that this file may be freely redistributed in whole or in part 
# for nonprofit, noncommercial use.

######################################################################
# j:tk4 - perform an action if running under Tk 4.0 or greater
######################################################################

proc j:tk4 { {command ""} } {
  global tk_version
  
  set major_version [lindex [split $tk_version .] 0]
  
  if {$major_version >= 4} {
    if [string length $command] {
      uplevel 1 [list eval $command]
    }
    return 1
  } else {
    return 0
  }
}

######################################################################
# j:tk3 - perform an action if running under Tk 3.X or earlier
######################################################################

proc j:tk3 { {command ""} } {
  global tk_version
  
  set major_version [lindex [split $tk_version .] 0]
  
  if {$major_version <= 3} {
    if [string length $command] {
      uplevel 1 [list eval $command]
    }
    return 1
  } else {
    return 0
  }
}

######################################################################
# j:current_focus - return current focus (assumes only one display!)
######################################################################

proc j:current_focus { {w .} } {
  global tk_version
  
  set major_version [lindex [split $tk_version .] 0]
  
  if {$major_version <= 3} {
    return [focus]
  } else {
    return [focus -lastfor $w]
  }
}
