proc moogInfoCB {type z} {
  global i
  global dirType dirName dirPath dirHost dirPort
  global bookType bookName bookPath bookHost bookPort

  case $type in {
    "dir" {set widget ".$z.dirView.listing"}
    "book" {set widget ".bookMarks.listing"}
  }

  foreach y [$widget curselection] {
    set I $i
    incr i

    toplevel .moogInfo$I

    wm title .moogInfo$I "Info - .moogInfo$I"

    message .moogInfo$I.msg \
      -font -Adobe-times-medium-r-normal--*-180* \
      -aspect 800 \
      -text "Gopher Item Information:"

    case $type in {
      "dir" {
        set name [lindex $dirName($z) $y]
        set type [lindex $dirType($z) $y]
        set path [lindex $dirPath($z) $y]
        set host [lindex $dirHost($z) $y]
        set port [lindex $dirPort($z) $y]
        }
      "book" {
        set name [lindex $bookName $y]
        set type [lindex $bookType $y]
        set path [lindex $bookPath $y]
        set host [lindex $bookHost $y]
        set port [lindex $bookPort $y]
        }
    }

    message .moogInfo$I.details \
      -width 600 \
      -text "Name: $name\nType: $type\nPath: $path\nHost: $host\nPort: $port"

    button .moogInfo$I.cancel \
      -text {Close} \
      -command "destroy .moogInfo$I"

    pack append .moogInfo$I \
      .moogInfo$I.msg {top frame c} \
      .moogInfo$I.details {top frame center fill} \
      .moogInfo$I.cancel {top frame center fill}
  }
}
