#
# user defined menu entries
#
proc mkuser {} {
    global Config

    toplevel .user
    wm transient .user .
    wm minsize .user 0 0
    wm maxsize .user "" ""

    message .user.t -text "User defined menu entries" -width 300 \
	    -font [option get . option_bold_font {} ]
    pack  .user.t -side top

    frame .user.l
    label .user.l.l -text "   "
    label .user.l.com -text "Command" -width 30
    label .user.l.des -text "Description"  -width 15

    pack .user.l.l -side left
    pack .user.l.com -side left -fill x -expand yes
    pack .user.l.des -side left -fill x -expand yes
    pack .user.l -side top -fill x -expand yes

    set n 1
    foreach m [option get .top.macro.m entrylist {} ] {
	user_lines $n $m
	incr n
    }

    frame .user.x -relief sunken -borderwidth 2
    button .user.x.save -text "Save" -command "user_done 1"
    button .user.x.exit  -text "Exit" -command "user_done 0"

    pack .user.x.save .user.x.exit -side left -padx 20m -pady 5m
    pack .user.x -side top -fill both -expand yes
    wm geometry .user $Config(.user)
}

proc user_lines {n m} {
    global com_user des_user

    frame .user.l$n
    label .user.l$n.l -text " $m "
    entry .user.l$n.com -relief sunken -width 30
    .user.l$n.com delete 0 999
    .user.l$n.com insert 0 $com_user($m)
#    bind  .user.l$n.com <Enter> "focus .user.l$n.com"
    entry .user.l$n.des -relief sunken -width 15
#    bind  .user.l$n.des <Enter> "focus .user.l$n.des"
    .user.l$n.des delete 0 999
    .user.l$n.des insert 0 $des_user($m)
    label .user.l$n.ll -text "   "
    pack  .user.l$n.l -side left
    pack  .user.l$n.com .user.l$n.des -side left -fill x -expand yes
    pack  .user.l$n.ll -side left 
    pack  .user.l$n -side top -fill x -expand yes
}

proc user_done {n} {
    global com_user des_user

    set i 1
    .top.macro.m delete 0 last
    foreach m [option get .top.macro.m entrylist {} ] {
	set  com_user($m) [.user.l$i.com get]
	set  des_user($m) [.user.l$i.des get]
        .top.macro.m add command -label $des_user($m) -command \
                "put_extended {$com_user($m)}"
	incr i
    }

    if {$n} {
	config_save
    }
    destroy .user
}

#
#	Options
#
proc options_geom {} {
    layout
    config_save
}

proc option_check_int {name element op} {
    global opt_line 
    upvar #0 $name n
    upvar #0 opt_back opt_back

    if {![regexp {^[0-9\-]*$} $n]} {
	upvar $opt_back($name) t
	set n $t
    } 
}

proc mkoptions {} {
    global Config middle_button_p mime_handling internal_editor
    global opt_back mono_f
    
    toplevel .option
    wm transient .option .
    wm minsize .option 0 0
    wm maxsize .option "" ""
    
    message .option.t -text "SETUP" -width 300 \
	    -font [option get . option_bold_font {} ]
    
    frame .option.m  -borderwidth 2  -relief ridge
    scale .option.m.mmax -label "Menu panel max size" -from 1 -to 36  \
	    -orient horizontal   -command "handle_mmax"
    .option.m.mmax set $Config(menu_max)
    scale .option.m.mmin -label "Menu pane min size" -from 1 -to 36  \
	    -orient horizontal   -command "handle_mmin"
    .option.m.mmin set $Config(menu_min)
    pack .option.m.mmax .option.m.mmin -side top -fill x

    
    frame .option.g  -borderwidth 2  -relief ridge
    checkbutton .option.g.menu_button -variable menu_button \
	    -text "Make Group menu at startup" -relief flat
    if ($Config(mk_group_menu)) {
	.option.g.menu_button select
    }
    pack  .option.g.menu_button -anchor w -padx 8
    
    global opt_line
    set opt_back(opt_line) $Config(default_article_lines)

    frame .option.line -borderwidth 2 -relief ridge
    label .option.line.m -text "Article lines displayed"
    entry .option.line.e -relief sunken -width 5 -textvariable opt_line
#    bind .option.line.e <Enter> "focus .option.line.e" 
    set opt_line $Config(default_article_lines)
    trace variable opt_line w option_check_int
    pack .option.line.m -side left -anchor e  -padx 8
    pack .option.line.e -side right -anchor e  -padx 8
    
    frame .option.mf -borderwidth 2 -relief ridge
    set mono_f $Config(mono_font)
    checkbutton .option.mf.font -variable mono_f -text \
	    "Monospace font" -relief flat
    pack  .option.mf.font -anchor w -padx 8
    
    frame .option.b -borderwidth 2 -relief ridge
    set middle_button_p $Config(middle_button_pos)

    label .option.b.l -text "Position of middle button  row"
    pack .option.b.l
    radiobutton .option.b.r1 -text "above menu panel"  -variable  middle_button_p\
	    -value 1 -relief flat 
    radiobutton .option.b.r2 -text "between menu panel and article panel"  \
	    -variable  middle_button_p -value 2 -relief flat 
    radiobutton .option.b.r3 -text "below article panel"  -variable  middle_button_p\
	    -value 3 -relief flat 
    pack .option.b.r1 .option.b.r2 .option.b.r3 -side top -pady 2 -anchor w
    
    frame .option.mime -borderwidth 2 -relief ridge
    label .option.mime.l -text "Decoding  MIME "
    pack .option.mime.l
    set mime_handling $Config(mime_handling)
    radiobutton .option.mime.r1 -text "No MIME handling"  -variable  mime_handling\
	    -value 1 -relief flat 
    radiobutton .option.mime.r2 -text "Don't handle text/plain as MIME"  \
	    -variable  mime_handling -value 2 -relief flat 
    radiobutton .option.mime.r3 -text "Decode all articles with MIME headers" \
	    -variable  mime_handling -value 3 -relief flat 
    pack .option.mime.r1 .option.mime.r2 .option.mime.r3 -side top -pady 2 -anchor w
    
    frame .option.ed -borderwidth 2 -relief ridge
    set internal_editor $Config(internal_editor)
    checkbutton .option.ed.font -variable internal_editor -text \
	    "Internal editor as default" -relief flat
    pack  .option.ed.font -anchor w -padx 8

    frame .option.x -relief sunken -borderwidth 2
    button .option.x.save -text "Save" -command "option_done 1"
    button .option.x.exit  -text "Exit" -command "option_done 0"
    pack .option.x.save -side left -padx 18 -pady 6
    pack .option.x.exit -side right -padx 18 -pady 6
    
    pack .option.t .option.m  .option.g .option.line  .option.mf \
	    .option.b .option.mime .option.ed .option.x \
	    -side top -fill x
    wm geometry .option $Config(.option)
    
    prompt_restore
    .prompt.pr1 insert end "Setup"	
}

proc handle_mmax {val} {
	set minv [.option.m.mmin get]
	if {$minv > $val} {
		.option.m.mmin set $val
	}
}

proc handle_mmin {val} {
	set maxv [.option.m.mmax get]
	if {$maxv < $val} {
		.option.m.mmax set $val
	}
}

proc option_done {sav} {
    global Config
    global opt_line middle_button_p mono_f menu_button mime_handling internal_editor

    set Config(menu_min) [.option.m.mmin get]
    set Config(menu_max) [.option.m.mmax get]
    set Config(default_article_lines) $opt_line
    set Config(mk_group_menu) $menu_button
    if {$mono_f != $Config(mono_font)} {
	set Config(mono_font) $mono_f
	more_font
    }
    if {$middle_button_p != $Config(middle_button_pos)} {
	set Config(middle_button_pos) $middle_button_p
	middle_buttons
	if {$Config(middle_button_pos) == 1} {
	    pack  .middle -side top -after .top
	} elseif {$Config(middle_button_pos) == 2} {
	    pack  .middle -side top -after .menu-prompt
	} else {
	    pack  .middle -side top -after .more
	}
    }
    set Config(mime_handling) $mime_handling
    set Config(internal_editor) $internal_editor
    if {$sav == 1} {
	config_save
    }
    option_values $Config(menu_max) $Config(menu_min) $Config(mk_group_menu) \
	    $Config(default_article_lines) $Config(mime_handling) \
	    $Config(internal_editor)
    destroy .option
}

proc layout {}  {
    global Config config_windows

    foreach i $config_windows {
	if {[winfo exists $i]} {
	    set Config($i) [wm geometry $i]
	}
    }
}

proc config_read {} {
    global nn_directory Config config_windows config_var nn_x_dir

    option readfile "$nn_x_dir/tcl/nn-defaults" user
    if [file exists $nn_directory/nn-defaults] {
	option readfile "$nn_directory/nn-defaults" user
    }
    if [file exists $nn_directory/tk-config] {
	option readfile "$nn_directory/tk-config" user
    }

    foreach i $config_windows {
	if [winfo exists $i] {
	    set Config($i) [option get  ${i} position {}]
	} else {
#           workaround for requirement for window to exist
#           before can get option
	    frame $i
	    set Config($i) [option get ${i} position {}]
	    destroy $i
	}
#	puts "$i $Config($i)"
    }
    foreach i $config_var  {
	set Config($i) [option get . $i {}]
#	puts "$i $Config($i)"
    }
}

proc config_save {} {
    global Config nn_directory config_windows config_var
    global com_user des_user

    set fname "$nn_directory/tk-config"
    set f [open $fname w]

    foreach i [lsort $config_windows] {
	set s [string range $i 1 end]
	if {$Config($i) != ""} {
	    set Config($i) [check_geom $Config($i)]
	    puts $f "*$s.position: $Config($i)"
	}
    }
    puts $f "!!"
    foreach i [lsort $config_var] {
	puts $f "*$i: $Config($i)"
    }
    puts $f "!!"
    foreach m [option get .top.macro.m entrylist {} ] {
	puts $f "*top.macro.m.l_$m:	$des_user($m)"
	puts $f "*top.macro.m.c_$m:	$com_user($m)"
    }
    close $f
    nn_PreferencesSave
}

proc config_menu {menu} {
    global com_user des_user

    foreach m [option get $menu entrylist {} ] {
	set des_user($m) [option get $menu l_$m {}]
	set com_user($m) [option get $menu c_$m {}]
	$menu add command -label $des_user($m) -command \
		"put_extended {$com_user($m)}"
    }
}


proc check_geom {g} {
    scan $g "%dx%d+%d+%d" xs ys xp yp
    if {$xs < 0} {
	set xs 0
    }
    if {$ys < 0} {
	set ys 0
    }
    return [format "%dx%d+%d+%d"  $xs $ys $xp $yp]
}

proc read_options {file} {
    global nn_directory Config

    set fname "$nn_directory/$file"

    if {[file  exists $fname]} {
        set f [open $fname r]
        while {[gets $f line] >= 0} {
	    scan $line "%s %s  %s" command variable value
	    if {$command == "set"} {
	        set $Config($variable) $value
	    }
	}
	close $f
    }
}

#
# nn variables display
#
# var_m    - variables modified from default
# var_prev - original value of variables
# var_val  - value used by widgets
# var_ch   - variables  that have changed

proc variable_but {l} {
    upvar #0 var_ch var_ch
    upvar #0 var_val var_val
    set var_ch($l)  $var_val($l)
}

proc variable_done {n} {
    upvar #0 var_ch var_ch
    upvar #0 var_prev var_prev
    upvar #0 var_m var_m
    upvar #0 var_val var_val

    foreach i [array names var_ch] {
	nn_set_var $i $var_ch($i)
#       nn_set_var doesn't return sucess or failure so
#       so need to check if variable changed
        global change_var
	if {$var_ch($i) == [nn_get_var $i]} {
	    set var_m($i) 1
	    set var_prev($i) $var_ch($i)
	} else {
	    nn_set_var $i $var_prev($i)
	    set var_ch($i) $var_prev($i)
	    set var_val($i) $var_prev($i)
	    return
	}
    }
    if {$n} {
	save_var
    }
    destroy .variable
}

proc variable_radio {str name val args} {
    upvar #0 var_val var_val

    set n 0
    foreach i $args {
	radiobutton $str.$n -text $i -variable var_val($name) \
		-value $n -relief flat -command "variable_but $name"
	pack $str.$n -side top -pady 2 -anchor w
	incr n
    }
    set var_val($name) $val
}

proc variable_check_int {name element op} {
    upvar #0 var_val var_val
    upvar #0 var_ch var_ch
    upvar #0 var_prev var_prev

    if {[regexp {^[0-9\-]*$} $var_val($element)]} {
	set var_ch($element) $var_val($element)
    } else {
	set var_val($element) $var_prev($element)
    }
}

proc variable_check_key {name element op} {
    upvar #0 var_val var_val
    upvar #0 var_ch var_ch

    set var_ch($element) $var_val($element)
}

proc variable_check_str {name element op} {
    upvar #0 var_val var_val
    upvar #0 var_ch var_ch

    set var_ch($element) $var_val($element)
}

proc variable_foc {name {entry ""}} {
    global var_h var_help 

    if {$entry != ""} {
	focus $entry
    }
    .variable.m.t delete 0.0 end
    if {[info exists var_help($name)]} {
	.variable.m.t insert 0.0 $var_help($name)
    }
}

proc read_var_help {} {
    global help_directory var_help

    set fname "$help_directory/help.variables"
    if {[file  exists $fname]} {
        set f [open $fname r]
        while {[gets $f line] >= 0} {
	    set nst [string first "\t" $line ]
	    set nss [string first " " $line ]
	    if {$nss> 0 && $nss < $nst} {
		set nst $nss
	    }
	    set nf [string last  "\t" $line ]
	    set var [string range $line 0 [incr nst -1]]
	    set comm [string range $line [incr nf] end]
	    set var_help($var) $comm
	}
	close $f
    }
}

proc variable_ent {name type tag} {
    global var_val var_prev var_m butt
    global var_str  var_local

    global var_$name

    if {$tag == "m"} {
	set var_m($name) 1
    } elseif {$tag == "p"} {
	if {! $var_local} {
	    set var_local  1;
	    mkmsg "WARNING - There are local variables, if saved these will replace the corresponding global ones"
	    update
	    after 8000 {destroy .msg}
	}
    }
	
    if {$var_str == "NULL"} {
	set var_str ""
    }
    set var_prev($name) $var_str

    if {$type == "bool"} {
	frame .variable.c.f.$name -borderwidth 2  -relief ridge
	checkbutton .variable.c.f.$name.b -variable var_val($name) \
		-text $name -command "variable_but $name" \
		-offvalue off -onvalue on -relief flat
	set var_val($name) $var_str
	bind  .variable.c.f.$name <Enter> \
		"variable_foc $name" 
	pack  .variable.c.f.$name.b -anchor w -padx 8
	pack  .variable.c.f.$name -side top  -expand yes \
		-anchor w -fill x
    } elseif {$type == "int" || $type == "key"} {
	frame  .variable.c.f.$name -borderwidth 2  -relief ridge
	label .variable.c.f.$name.m -text $name 
	if {[info exists butt($name)]} {
	    pack  .variable.c.f.$name.m  -side top -padx 8
	    eval "variable_radio .variable.c.f.$name $name $var_str \
		    $butt($name)"
	    bind  .variable.c.f.$name <Enter> \
		    "variable_foc $name" 
	    pack .variable.c.f.$name
	} else {
	    pack .variable.c.f.$name.m  -side left -padx 8
	    entry  .variable.c.f.$name.e -relief sunken -width 7 \
		    -textvariable var_val($name)
	    set var_val($name) $var_str
	    bind  .variable.c.f.$name <Enter> \
		    "variable_foc $name .variable.c.f.$name.e" 
	    pack .variable.c.f.$name.e -side right -anchor e  -padx 8
	    pack  .variable.c.f.$name -side top  -expand yes \
		    -fill x
	    if {$type == "int"} {
		trace variable var_val($name) w variable_check_int
	    } else {
		trace variable var_val($name) w variable_check_key
	    }
	}
     } else {
	 frame  .variable.c.f.$name -borderwidth 2  -relief ridge
	 label .variable.c.f.$name.m -text $name
	 entry  .variable.c.f.$name.e -relief sunken \
		    -textvariable var_val($name)
	 set var_val($name) $var_str
	 trace variable var_val($name) w variable_check_str
	 bind  .variable.c.f.$name <Enter> \
		 "variable_foc $name .variable.c.f.$name.e" 
	 pack  .variable.c.f.$name.m  -expand yes
	 pack  .variable.c.f.$name.e -expand yes -pady 3 -fill x -padx 8
	 pack  .variable.c.f.$name -side top -pady 2 -expand yes \
		 -anchor w -fill x
    }
    if {$tag == "p"} {
	.variable.c.f.$name configure -borderwidth 6 -relief sunken
    }
}

proc save_var {} {
    global nn_directory var_h
    global var_m var_prev

    set fname "$nn_directory/tk-init-nn"
    set f [open $fname w]
    foreach i [array names var_m] {
	puts  $f "set $i $var_prev($i)"
    }
    close $f
}

proc mkvariables {all} {
    global  Config font_nv var_local
    global var_ch var_m var_val var_prev var_help

    set var_local 0

    if {![info exists var_help]} {
	read_var_help
    }
    if {[info exists var_ch]} {
	unset var_ch
    }
    set var_ch(1) 1
    unset var_ch(1)
    if {[info exists var_m]} {
	unset var_m
    }
    set var_m(1) 1
    unset var_m(1)
    if {[info exists var_val]} {
	unset var_val
    }
    set var_val(1) 1
    unset var_val(1)
    if {[info exists var_prev]} {
	unset var_prev
    }

    toplevel .variable
    wm transient .variable .
    wm minsize .variable 0 0

    frame .variable.f
    canvas .variable.c 
    frame .variable.c.f
    set id [.variable.c create window 0 0 -window .variable.c.f -anchor nw]

    scrollbar .variable.s1 -command ".variable.c yview" -relief sunk

    .variable.c config  -yscroll ".variable.s1 set"
    pack .variable.s1 -in .variable.f -fill y -side right -expand yes \
	    -anchor w
    pack .variable.c -in .variable.f -expand yes -fill both \
	    -anchor w

    nn_variables $all

    frame .variable.x -relief sunken -borderwidth 2
    button .variable.x.save -text "Save" -command "variable_done 1"
    button .variable.x.exit  -text "Exit" -command "variable_done 0"
    pack  .variable.x.save  -side left -padx 10m -pady 5m
    pack .variable.x.exit -side right -padx 10m -pady 5m

    frame .variable.m -relief raised -borderwidth 2 
    text .variable.m.t  -relief raised -setgrid true \
	    -height 2 -font [option get . option_bold_font {} ] -wrap word
    pack .variable.m.t  -expand yes -fill y

    pack .variable.f -expand yes -fill y
    pack .variable.m -fill y 
    pack .variable.x -side bottom -fill both
    wm geometry .variable $Config(.variable)

     update
    .variable.c configure -scrollregion [.variable.c bbox  $id]
   
}
