#!/usr/local/bin/wish -f

source "[info library]/init.tcl"
source "$tk_library/tk.tcl"

if {$nn_x_dir == "."} {
    set nn_x_dir [pwd]
}

lappend auto_path "$nn_x_dir/tcl"
lappend auto_path "$nn_x_dir/tcl/exmh"

set config_windows {.display .prompt .option .user .groups .folders .post\
	.pref .pref0 .pref1 .pref2 .pref3 .variable .seditpref .nn}
set config_var {menu_max menu_min mk_group_menu default_article_lines \
	mono_font middle_button_pos mime_handling internal_editor}

config_read

#  fix color on main window frame
set color_bl [option get . background Background]
. configure -background $color_bl

# highlight surrounds of article menu
set color_bd [option get . bold {} ]
option add *menu-g*Background  $color_bd
option add *menu-prompt*Background  $color_bd

set butt(auto-select-closed) {"select first" "select unread" "select all"}
set butt(enter-last-read-mode) {"ignore" "enter if unread(confirm)" \
	"enter next unread(conf)" "enter if unread(no conf)" \
	"enter next unread(no conf)"}
set butt(from-line-parsing) {"always" "at least 8 fields" "valid date & time"}
set butt(layout) {"name, subject, lines" "name, lines, subject" \
	"lines, subject" "subject" "usually n, l, s but s only if too long"}
set butt(marked-by-next-group) {"none" "current article" "current page" \
	"previous pages" "previous & current" "all"}
set butt(marked-by-read-return) {"none" "current article" "current page" \
	"previous pages" "previous & current" "all"}
set butt(marked-by-read-skip) {"none" "current article" "current page" \
	"previous pages" "previous & current" "all"}
set butt(print-header-type) {"No header" "Short header" "Full header"}
set butt(menu-spacing) {"no blank line" "between different subjects" \
	"between all aricles"}
set butt(new-group-action) {"ignore not it .newsrc" \
	"add not in .newsrc to start" "add not in .newsrc to end" \
	"add new to .newsrc" "add new to .newsrc(confirm)" \
	"add new to .newsrc( rn format)"}
#set butt(preview-continuation) {"never" "always" "if same subject"}
set butt(re-layout) {"one > per reference(a)" "single > if Re:(b)"\
	"number references N>" "single Re:" "if references (a) else (b)"}
#set butt(save-closed-mode) {"save root" "save slected" "save unread" \
#	"save selected + unread" "save all"}
set butt(show-purpose-mode) {"never" "new groups" "all groups"}
set butt(sort-mode) {"arrival" "subject age" "lexical" "age" "sender"}

set token(K_INVALID)			\x0000 

set token(K_UNBOUND)			\x0001 

set token(K_REDRAW)			\x0002 
set token(K_CONTINUE)			\x0003 
set token(K_LAST_MESSAGE)		\x0004 
set token(K_HELP)			\x0005 
set token(K_SHELL)			\x0006 
set token(K_VERSION)			\x0007 
set token(K_EXTENDED_CMD)		\x0008 

set token(K_QUIT)			\x0009 
set token(K_BUG_REPORT)			\x000a 

set token(K_SAVE_NO_HEADER)		\x0011 
set token(K_SAVE_SHORT_HEADER)		\x0012 
set token(K_SAVE_FULL_HEADER)		\x0013 

set token(K_PRINT)			\x0014 

set token(K_UNSHAR)			\x0015 

set token(K_REPLY)			\x0016 
set token(K_FOLLOW_UP)			\x0017 
set token(K_POST)			\x0018 
set token(K_MAIL_OR_FORWARD)		\x0019 
set token(K_CANCEL)			\x001a 
set token(K_UNSUBSCRIBE)		\x001b 
set token(K_GROUP_OVERVIEW)		\x001c 
set token(K_PATCH)			\x001d 
set token(K_UUDECODE)			\x001e 

set token(K_GOTO_GROUP)			\x001f 

set token(K_KILL_HANDLING)		\x0020 

    # scrolling/menu movement */

set token(K_CONTINUE_NO_MARK)		\x0021 
set token(K_JUNK_ARTICLES)		\x0022 
set token(K_SKIP_LINES)			\x0023 
set token(K_NEXT_PAGE)			\x0024 
set token(K_NEXT_HALF_PAGE)		\x0025 
set token(K_NEXT_LINE)			\x0026 
set token(K_PREV_PAGE)			\x0027 
set token(K_PREV_HALF_PAGE)		\x0028 
set token(K_PREV_LINE)			\x0029 

set token(K_HEADER_PAGE)		\x002a 
set token(K_FIRST_PAGE)			\x002b 
set token(K_LAST_PAGE)			\x002c 

set token(K_GOTO_LINE)			\x002d 
set token(K_GOTO_PAGE)			\x002e 
set token(K_GOTO_MATCH)			\x002f 
set token(K_NEXT_MATCH)			\x0030 

set token(K_PREVIOUS)			\x0031 

    # more() SPECIFIC COMMANDS */

set token(K_LEAVE_ARTICLE)		\x0032 
set token(K_LEAVE_NEXT)			\x0033 
set token(K_NEXT_ARTICLE)		\x0034 
set token(K_NEXT_SUBJECT)		\x0035 
set token(K_FULL_DIGEST)		\x0036 
set token(K_ROT13)			\x0037 
set token(K_COMPRESS)			\x0038 
set token(K_BACK_TO_MENU)		\x0039 
set token(K_BACK_ARTICLE)		\x003a 
set token(K_FORW_ARTICLE)		\x003b 

    # menu() SPECIFIC COMMANDS	 */

set token(K_SELECT)			\x0041 
set token(K_SELECT_INVERT)		\x0042 
set token(K_SELECT_SUBJECT)		\x0043 
set token(K_SELECT_RANGE)		\x0044 
set token(K_AUTO_SELECT)		\x0045 
set token(K_UNSELECT_ALL)		\x0046 

set token(K_SEL_GROUP)			\x0047 

set token(K_LAYOUT)			\x0049 

set token(K_NEXT_GROUP_NO_UPDATE)	\x004a 
set token(K_READ_GROUP_UPDATE)		\x004b 
set token(K_READ_GROUP_THEN_SAME)	\x004c 

set token(K_ADVANCE_GROUP)     		\x004d 
set token(K_BACK_GROUP)			\x004e 

set token(K_PREVIEW)			\x004f 

set token(K_OPEN_SUBJECT)		\x0050 
set token(K_CLOSE_SUBJECT)		\x0051 

set token(K_M_TOGGLE)			\x0060 
set token(K_M_CONTINUE)			\x0061 
set token(K_M_SELECT)			\x0062 
set token(K_M_SELECT_SUBJECT)		\x0063 
set token(K_M_SELECT_RANGE)		\x0064 
set token(K_M_PREVIEW)			\x0065 
set token(K_S_EXTENDED_CMD)		\x0066 

set token(K_EQUAL_KEY)			\x0070 

set token(K_MACRO)			\x0100 
set token(K_ARTICLE_ID)			\x0200 
set token(K_PREFIX_KEY)			\x0400 

set EV_CHAR	1
set EV_FUNCT	2
set EV_SELECT	3
set EV_RETURN	4
set EV_SELECT_C 5
set EV_INT	6

#              execute nn function
proc put_funct {ch {type .}} {
	global ev_input ev_type EV_FUNCT
	if {$type == "m"} {
		ev_type_menu
	} 
	rec_c $EV_FUNCT $ch
#	puts stderr "<$ch>"
}

#              execute extended function
proc put_extended {cmd} {
	global token ev_param
	set ev_param $cmd
	 put_funct $token(K_S_EXTENDED_CMD)
}

#              replace text
proc text_ent {scr} {
	global text_ent_t

	$scr delete 1.0 "1.0 lineend"
	$scr insert 1.0 $text_ent_t
}

#              add string to text
proc text_add {scr} {
	global text_ent_t

	$scr insert end $text_ent_t

}

#              delete character from end of text
proc text_delc {scr} {

	$scr delete "end -1 chars"
}

#              if not in group menu return to it
proc ev_type_menu {} {
	global menu_mode read_mode token EV_INT EV_FUNCT
	if {$read_mode != "c"} {
		rec_c $EV_INT 0
	}
	if {$menu_mode != "m"} {
		rec_c $EV_FUNCT $token(K_BACK_TO_MENU)
	}
}

#		handle key input	
proc put_key {k} {
    global ev_input ev_type EV_CHAR
	if {"$k" != ""} {
    		rec_c $EV_CHAR $k
	}
}

proc button_mode {butt val} {
    $butt configure -state $val
}


# Handle destroy
#
proc exit_nn {} {
    application_destroyed
}

proc text_bindings {txt} {
    bind $txt <Any-KeyPress> "put_key %A"
    bind $txt <Enter> "focus %W"
    bind $txt <Key-Delete>  "put_key %A"
    bind $txt <Key-BackSpace>  "put_key %A"
    bind $txt <Key-Return>  "put_key %A"
    bind $txt <Control-1> {%W scan mark %y}
    bind $txt <Control-B1-Motion> {%W scan dragto %y}
    bind $txt <B2-Motion> {}
}

proc fix_bindings {} {

    bind Entry <Control-1> {%W scan mark %x}
    bind Entry <Enter> "focus %W"

    bind Listbox <Control-1> {%W scan mark %x %y}
    bind Listbox <Control-B1-Motion> {%W scan dragto %x %y}
    bind Listbox <Any-KeyPress> "put_key %A"
    bind Listbox <Enter> "focus %W"
    bind Listbox <Key-Delete>  "put_key %A"
    bind Listbox <Key-BackSpace>  "put_key %A"
    bind Listbox <Key-Return>  "put_key %A"

}

#
#	Main routine
#

set chp 0
set s_last 0
set list_cnt 0
set tcl_interactive 1

set read_mode " "
set menu_mode "m"

if [file exists $nn_x_dir/tcl/exmh] {
    set has_exmh 1
} else {
    set has_exmh 0
}

fix_bindings

catch {option_values $Config(menu_max) $Config(menu_min) $Config(mk_group_menu)\
	$Config(default_article_lines)  $Config(mime_handling) $Config(internal_editor)}

mklist .groups 

mkprompt

mkmain

bind . <Destroy> exit_nn


wm geometry . $Config(.nn)

wm title . "News"
wm iconname . "News"

menu_resize $Config(menu_max)

if {$has_exmh} {
    source "$nn_x_dir/tcl/exmh/main.tcl"
    source "$nn_x_dir/tcl/exmh/exwin.tcl"
    source "$nn_x_dir/tcl/exmh/preferences.tcl"

    exmh_init
} 
