#
#  Posting PoPup
#
proc mkpost args {
    global Config has_exmh
    toplevel .post
    wm transient .post .
    frame .post.s
    pack .post.s

    set i 0
    foreach x $args {
	set n [expr $i/2]
	if {[expr $i%2] == 0} {
	    frame .post.s.f$n
	    label .post.s.f$n.l -text $x
	    pack .post.s.f$n.l -side left -expand yes -fill x
	} else {
	    entry .post.s.f$n.e  -width 25
           .post.s.f$n.e delete 0 999
           .post.s.f$n.e insert 0 $x
	    pack   .post.s.f$n.e -side right
            pack .post.s.f$n -fill x
	}
	incr i
    }
    frame .post.x -relief sunken -borderwidth 2
    if {$has_exmh} {
	button .post.x.edit -text "simple editor" -command "post_do  s"
    } else {
	button .post.x.edit -text "simple editor" -command "post_do  s" -state disabled
    }
    button .post.x.xt -text "external editor" -command "post_do x"
    button .post.x.exit  -text "Exit" -command "post_exit"

    pack .post.x.edit .post.x.xt .post.x.exit -side left -padx 5m -pady 5m
    pack .post.x -side top -fill both -expand yes

    wm geometry  .post $Config(.post)
}

proc post_do {c} {
    global post_subject post_keywords post_summary post_distribution
    
    set post_subject [.post.s.f0.e get]
    set post_keywords [.post.s.f1.e get]
    set post_summary [.post.s.f2.e get]
    set post_distribution [.post.s.f3.e get]
    put_key $c
    destroy .post
}

proc post_exit {} {
    put_key  e
    destroy .post
}

#
# message - popup
#
proc mkmsg {mess} {
    catch {destroy .msg}
    toplevel .msg
    wm transient .msg .
    wm geometry .msg +300+300

    message .msg.m -text $mess -aspect 300

    pack .msg.m -side left -expand yes -fill both
}

#
#	Group cascading menus
#
#		pass group selection to nn
proc gg {grp {menu ""}} {
    global grp_x grp_y
    global gm_type ev_param ev_type ev_input 
    global EV_FUNCT token

    scan  "[winfo geometry  .top.m.menu-$menu]" "%dx%d+%d+%d" sx sy x y

    if {$menu != ""} {
	set ya [.top.m.menu-$menu yposition active]
    } else {
	set ya [.top.m.menu yposition active]
    }

    set grp_x [expr $sx/2+$x]
    set grp_y [expr $y+$ya-6]
    set gm_type "m"
    set ev_param $grp
    ev_type_menu
    rec_c $EV_FUNCT $token(K_SEL_GROUP)
}

#		display group jump menu
proc gr_menu {} {
    global grp_x grp_y
    global list_cnt

    incr list_cnt

    if {[winfo exists .menu-test]} {
	destroy .menu-test
    }
    menu .menu-test
    .menu-test add command -label "Enter Group"
    .menu-test add separator
    foreach i {"j)jump" "a)all"  "s)subject" "n)name" "e)either" \
	    "u)unread" "@)archive"} {
	set a [string index $i 0]
	set i [string range $i 2 end]
	.menu-test add command -label $i -accelerator $a -command "pmenu $a"
    }
    .menu-test post $grp_x [expr $grp_y-35]
    grab .menu-test
    grab release .menu-test
    update
}

#		group jump menu selection
proc pmenu {x} {
    global ev_input  ev_type EV_CHAR 
    global list_cnt      

    rec_c $EV_CHAR $x
    .menu-test unpost
    destroy .menu-test
    set list_cnt 0
}

proc menu_test_del {} {
    global list_cnt      
#   fudgy variable to make sure window
#   isn't destroyed if it has to be reposted

    if {$list_cnt <= 1} {
	if {[winfo exists .menu-test]} {
	    destroy  .menu-test
	}
    }
    incr list_cnt -1
}

#
#	Group List
#

#		pass group list selection to nn
proc list_select {grp y} {
    global gm_type ev_param ev_input ev_type 
    global EV_FUNCT token

    set gm_type 'g'
    $grp.list select from $y
    set t [$grp.list get $y]
    set l [expr [string first " " $t]-1]
    if { $l > 0 } {
	set t [string range $t 0 $l]
    }
#   puts stderr "$grp $y $t"
    set ev_param $t
    if {$grp == ".folders"} {
	set ev_param "+$ev_param"
    }
    ev_type_menu 
    rec_c $EV_FUNCT $token(K_SEL_GROUP)
}

#		replace a group list entry
proc list_update {ent n} {
    set n [expr $n-1]
    .groups.list delete $n
    .groups.list insert $n $ent
}

proc group_save {n} {
	global gpos_save
	set gpos_save $n
}

proc group_ret {} {
	global gpos_save
	list_sel $gpos_save
}

#		mark current group 
proc list_sel {y} {
    if {[winfo exists .groups] != 0} {
	if {$y > 0} {
	    .groups.list select from [expr $y-1]
	    .groups.list yview [expr $y-4]
	}
    }
}

# 		create group list
proc list_mk {grp flist} {
    if {[winfo exists $grp] == 0} {
	mklist $grp
	$flist
    }
}

proc group-search {grp} {
    global grp_x grp_y

    set l [$grp.list size]
    set srch [$grp.search.txt get]
    set n [$grp.list curselection]
    for {set i [incr n 1]} {$i < $l} {incr i} {
	set t [$grp.list get $i]
	if {[string first $srch $t] >= 0} {
	    list_select $grp $i
	    list_sel [incr i]
	    set grp_x [expr [winfo rootx $grp.search.bt]+15]
	    set grp_y [winfo rooty $grp.search.bt] 
	    return
	}
    }
    mkmsg "Group no found"
    after 5000 {catch {destroy .msg}}
}
		
proc group-search-b {grp} {
    global grp_x grp_y

    set l [$grp.list size]
    set srch [$grp.search.txt get]
    set n [$grp.list curselection]
    for {set i [incr n -1]}	{$i >= 0} {incr i -1} {
	set t [$grp.list get $i]
	if {[string first $srch $t] >= 0} {
	    list_select $grp $i
	    list_sel [incr i]
	    set grp_x [expr [winfo rootx $grp.search.bf]+15]
	    set grp_y [winfo rooty $grp.search.bf] 
	    return
	}
    }
    mkmsg "Group no found"
    after 5000 {catch {destroy .msg}}
}
		
proc group-srch {grp} {
    frame $grp.search
    button $grp.search.bt -text "/" -command "group-search $grp" -bd 2 \
     	    -relief raised
    button $grp.search.bf -text "\\" -command "group-search-b $grp" -bd 2 \
     	    -relief raised
    entry $grp.search.txt -relief sunken 
    pack $grp.search.bt $grp.search.txt $grp.search.bf -side left

    bind $grp.search.txt <Return> "group-search $grp"
}

proc list_press {grp window x y} {
    global grp_x grp_y

    list_select $grp [$window nearest $y]
    set x [expr [winfo rootx $window]+$x]
    set y [expr [winfo rooty $window]+$y]
    set grp_x $x
    set grp_y $y 
}

proc mklist {grp} {
    global  color_w Config
    toplevel $grp

    wm title $grp "NN $grp"
    if {$grp == ".groups"} {
	set geom $Config(.groups)
    } else {
	set geom $Config(.folders)
    }

    group-srch $grp

    scrollbar $grp.scroll -command "$grp.list yview"
    listbox $grp.list -yscroll "$grp.scroll set"  -relief raised -borderwidth 1 \
	    -cursor left_ptr 
    $grp.list configure -exportselection 0 -setgrid 1 -geometry 40x15
    bind $grp.list <Button-1> "list_press $grp %W %x %y"
    bind $grp.list <B1-Motion> {  }

    pack $grp.search -side bottom
    pack $grp.scroll -side right -fill y
    pack $grp.list -side left -expand yes -fill both
    wm geometry $grp $geom

}

#
#       Yes/No popup
#
proc y_prompt {} {
    global prompt_buf
    toplevel .yp 
    regsub -all "\\1" $prompt_buf "" prompt_buf
    regsub -all \x0d $prompt_buf "" prompt_buf
    regsub -all \x01 $prompt_buf "" prompt_buf
    wm transient .yp .
    wm geometry .yp +300+300
    message .yp.t -text $prompt_buf -aspect 800
    frame .yp.f -relief sunken -borderwidth 2
    button .yp.f.yes -text "YES" -command "r_prompt y"
    button .yp.f.no -text "NO" -command "r_prompt n"

    pack .yp.f.no -side left -padx 10m -pady 5m 
    pack .yp.f.yes -side right -padx 10m -pady 5m
    pack .yp.t -side top -expand yes -fill x
    pack .yp.f -side top -fill both

    grab set .yp
    focus .yp
    bind .yp y {r_prompt y}
    bind .yp Y {r_prompt y}
    bind .yp n {r_prompt n}
    bind .yp N {r_prompt n}
    bind .yp <Key-Return> {r_prompt y}
}

proc y_destroy {} {
    if {[winfo exists .yp]} {
	destroy .y
    }
}

proc r_prompt {c} {
	destroy .yp
	put_key $c
}

#
#	Prompting popup
#
proc mkprompt {} {
    global color_w Config
    toplevel .prompt
    
    wm transient .prompt .
    wm title .prompt "NN Prompt"
    
    text .prompt.pr1 -relief raised -bd 2 -setgrid true \
	    -height 1
    text .prompt.pr2 -relief raised -bd 2 -setgrid true \
	    -height 1
    text .prompt.pr3 -relief raised -bd 2 -setgrid true \
	    -height 1
    pack .prompt.pr1 .prompt.pr2 .prompt.pr3 -side top \
	    -fill both -expand yes

    bind .prompt <Destroy> prompt_d
    bind .prompt.pr1 <2> prompt_insert
    text_bindings .prompt.pr1
    bind .prompt.pr2 <2> prompt_insert
    text_bindings .prompt.pr1
    bind .prompt.pr3 <2> prompt_insert
    text_bindings .prompt.pr1

    wm geometry  .prompt $Config(.prompt)
}

proc prompt_insert {} {
    set t [catch{selection get}]
    set n [string length $t]
    for {set i 0} {$i < $n} {incr i} {
	put_key [string index $t $i]
    }
}

proc prompt_clear {} {
    .prompt.pr1 delete 0.0 end
    .prompt.pr2 delete 0.0 end
    .prompt.pr3 delete 0.0 end
    wm withdraw .prompt
}

proc prompt_restore {} {
    if {[winfo exists .prompt] == 0} {
	mkprompt
    } else {
	wm deiconify .prompt
    }
}
	
proc prompt_d {} {
	prompt_delete
} 
#
#	display popup
#
proc display_l {} {
    global display_l_t
    regsub -all \x01 $display_l_t "" x
    regsub -all \r $x "\n" x
    .display.t insert end $x
}

proc mkdisplay {} {
    global color_w Config
    
    if {[winfo exists .display] == 0} {
	toplevel .display
	
	text .display.t -relief raised -bd 2 -setgrid true \
		-height 25 -width 80  -yscrollcommand ".display.s set"
	scrollbar .display.s -command ".display.t yview"
	pack .display.t -side left -expand yes -fill both
	pack .display.s -side left -fill y
	wm title .display "NN help"
	wm geometry .display $Config(.display)
    } else {
	.display.t delete 0.0 end
    }
}
