# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/****************************************************************************

                    SCANNER for  'C C O U N T'  PROGRAM

                         L E X  SPECIFICATION FILE

*****************************************************************************

  Description:

  'ccount.l' is the lex specification file of 'ccount' program that 
  supplies results of the structure of a C source file. Before a C source 
  file can be parsed, there must be a lexical analysis, that is, a module 
  that recognizes tokens like keywords, identifiers, type names, constants, 
  operators etc. 
  Such a module is specified by this file and then created as C source code 
  by the command 'lex ccount.l' (--> lex.yy.c). Finally 'lex.yy.c' is 
  included in 'y.tab.c', the module of the syntactic analysis.
  
  See also 'README.1'!

*****************************************************************************

  Author: Joerg Lawrenz, Universitaet Karlsruhe
  Date:   12/1/93

  Portions Copyright (c) 1989, 1990 James  A.  Roskind

*****************************************************************************

I.  How does 'ccount.l' recognize an unknown type name (defined by user)?

  When an identifier is read, 'ccount.l' compares the context with four 
  selected rules by looking at the following words. If one rule can be 
  applied, the variable 'isaTYPE' is set to 1. Then 'ccount.l' checks
  if the type name is a keyword (e.g. 'int') by rejecting the rule.
  If the list of keywords has been passed without any action, 'ccount.l' 
  comes to the single 'identifier' pattern. There the token 'TYPEDEFname' 
  is returned if 'isaTYPE' is 1 or if the identifier has been found in the
  hash table without prefix. If necessary the type name is entered in the
  hash table.
  
  Examples for the four rules:        

  1.  mytype a;

  2.  mytype **a;
      mytype (*f)();
      mytype (*a)[];

  3.  mytype) a,          casting
      mytype) a)
      mytype) a}

  4.  mytype *,           pointer type as parameter
      mytype **)

  Up to now there are no conflicts between these rules and other C structures.

*****************************************************************************

II.  Further details:

  a) Rule 5:

  Another rule (5) comparing the identifier context recognizes constructions 
  to declare function prototypes in ANSI as well as Kernighan/Ritchie style 
  like
        extern void error A((char* msg, int level));

  by using the state variable 'flag':

              extern   void error A     (  ( char* msg, int level ) );
  flag     0         1 2    3     4 -1 -2 -2 ....................-2 0
  ignore                          |     |                           |
                                 
  --------------------------------------------------------------------------

  b) Identifier:

  If 'ccount.l' considers an identifier, it also checks if the identifier
  is the name of a macro in declaration part (token 'MACRODEF' will be
  returned in this case) or if the identifier has to be ignored. For this,
  'ccount.l' adds the according prefix ('&' or '!') to the identifier and 
  looks for this word in the hash table.

  --------------------------------------------------------------------------

  c) Handling of '#if'-preprocessor directives (see also 'README.1', 2.2):

  If 'ccount.l' reads a '#if'-preprocessor directive which it finds also
  in the hash table, the state variable 'pp_comment' and the count variable
  'if_count' are set to 1. The line number is indicated and saved in
  'BeginLine'. Then 'ReadPPline()' counts the directive line and reads the 
  following lines up to the first '#' by treating them as 'preprocessor 
  comment'. 'pp_comment' is set to 2. Now 'ccount.l' looks for the rest 
  of the directive. If it is the according 'endif', 'else' or 'elif' 
  ('if_count' == 1 ?), 'pp_comment' is set to 0 and 'ccount.l' returns 
  to the normal read mode. Otherwise or if the directive itself is part of 
  PP comment, 'ReadPPline' is called again treating all up to the next '#' 
  as PP comment, and so on.


**********************    DECLARATIONS     *********************************/

/* The following global variables and functions are already defined 
   in 'y.tab.c':  */

extern int lines;       
extern long bytes;      
extern long comments;   
extern long Pcomments;  

extern int num_identifier;       
extern int num_symbols;          
extern int num_ppdirectives;     
extern long bytes_identifier;
extern long bytes_symbols;
extern long bytes_ppdirectives;

extern char lexem[];             
extern char last_identifier[];  

extern BOOL DeclFlag;
extern BOOL ElabTypeFlag;
extern BOOL Debug;

extern void henter();          /* enters a word in the hash table */
extern BOOL hfind();           /* finds a word in the hash table */

/***************************************************************************/
  
BOOL isaTYPE = 0;    /* state variable, see above I. */

int flag = 0;        /* state variable, see above II.a */

int if_count = 0;    /* count variable, see above II.c */
int BeginLine = 0;   /* line store variable, see above II.c */
int pp_comment = 0;  /* state variable, see above II.c */


/*******************************  DEFINES  ***********************************/

#define WHITE_RETURN(x)        bytes += yyleng;   /* just count bytes */

#define PA_KEYWORD_RETURN(x) { if (flag > 0)\
                                 if (flag == 1) flag++; else flag = 0;\
                               CountSymbol(x);\
                               RETURN_VAL(x) }  /* standard C PArser Keyword */

#define IDENTIFIER_RETURN(x) { strcpy(last_identifier, yytext);\
                               CountSymbol(x);\
                               RETURN_VAL(x) }

#define ASCIIOP_RETURN(x)    { CountSymbol((int)*yytext);\
                               RETURN_VAL((int)*yytext) }
                                              /* a single character operator */
#define NAMEDOP_RETURN(x)    { CountSymbol(x);\
                               RETURN_VAL(x) }
                                        /* a multichar operator, with a name */

#define NUMERICAL_RETURN(x)  { CountSymbol(x);\
                               RETURN_VAL(x) }     /* some sort of constant */
                          
#define LITERAL_RETURN(x)    { CountSymbol(x);\
                               RETURN_VAL(x) }           /* a string literal */

#define RETURN_VAL(x)        { isaTYPE = 0;\
                               bytes += yyleng;\
                               strcpy(lexem, yytext);\
                               if (Debug)\
                                 fprintf(stderr," %s %d ",yytext,x);\
                               return(x); }

/****************************************************************************/

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
                     {WHITE_RETURN(' ');}
break;
case 2:
       {WHITE_RETURN(' ');}
break;
case 3:
        
                               {lines++;
                                WHITE_RETURN('\n');
		        	}
break;
case 4:
                    /* Rule 1 */
                               {
                                if (Debug)
                                   fprintf(stderr," RULE1>> ");
                                isaTYPE = !ElabTypeFlag && flag <= 1;
                                REJECT;
                                }
break;
case 5:
     /* Rule 2 */
                               {             
                                if (Debug)
                                   fprintf(stderr," RULE2>> ");
                                isaTYPE = DeclFlag && !ElabTypeFlag;
                                REJECT;
                                }
break;
case 6:
   /* Rule 3 */
                               {             
                                if (Debug)
                                   fprintf(stderr," RULE3>> ");
                                isaTYPE = !ElabTypeFlag;
                                REJECT;
                                }
break;
case 7:
               /* Rule 4 */
                               {
                                if (Debug)
                                   fprintf(stderr," RULE4>> ");
                                isaTYPE = !ElabTypeFlag;
                                REJECT;
                                }
break;
case 8:

                               {                  /* Rule 5 */
                                if (Debug)
                                   fprintf(stderr," RULE5>> ");
                                flag = 1;
                                REJECT;                                 
                                }
break;
case 9:
               {PA_KEYWORD_RETURN(AUTO);}
break;
case 10:
              {PA_KEYWORD_RETURN(BREAK);}
break;
case 11:
               {PA_KEYWORD_RETURN(CASE);}
break;
case 12:
               {PA_KEYWORD_RETURN(CHAR);}
break;
case 13:
              {PA_KEYWORD_RETURN(CONST);}
break;
case 14:
           {PA_KEYWORD_RETURN(CONTINUE);}
break;
case 15:
            {PA_KEYWORD_RETURN(DEFAULT);}
break;
case 16:
                 {PA_KEYWORD_RETURN(DO);}
break;
case 17:
             {PA_KEYWORD_RETURN(DOUBLE);}
break;
case 18:
               {PA_KEYWORD_RETURN(ELSE);}
break;
case 19:
               {ElabTypeFlag = 1; 
                     PA_KEYWORD_RETURN(ENUM);}
break;
case 20:
             {PA_KEYWORD_RETURN(EXTERN);}
break;
case 21:
              {PA_KEYWORD_RETURN(FLOAT);}
break;
case 22:
                {PA_KEYWORD_RETURN(FOR);}
break;
case 23:
               {PA_KEYWORD_RETURN(GOTO);}
break;
case 24:
                 {PA_KEYWORD_RETURN(IF);}
break;
case 25:
                {PA_KEYWORD_RETURN(INT);}
break;
case 26:
               {PA_KEYWORD_RETURN(LONG);}
break;
case 27:
           {PA_KEYWORD_RETURN(REGISTER);}
break;
case 28:
             {PA_KEYWORD_RETURN(RETURN);}
break;
case 29:
              {PA_KEYWORD_RETURN(SHORT);}
break;
case 30:
             {PA_KEYWORD_RETURN(SIGNED);}
break;
case 31:
             {PA_KEYWORD_RETURN(SIZEOF);}
break;
case 32:
             {PA_KEYWORD_RETURN(STATIC);}
break;
case 33:
             {ElabTypeFlag = 1; 
                     PA_KEYWORD_RETURN(STRUCT);}
break;
case 34:
             {PA_KEYWORD_RETURN(SWITCH);}
break;
case 35:
            {PA_KEYWORD_RETURN(TYPEDEF);}
break;
case 36:
              {ElabTypeFlag = 1; 
                     PA_KEYWORD_RETURN(UNION);}
break;
case 37:
           {PA_KEYWORD_RETURN(UNSIGNED);}
break;
case 38:
               {PA_KEYWORD_RETURN(VOID);}
break;
case 39:
           {PA_KEYWORD_RETURN(VOLATILE);}
break;
case 40:
              {PA_KEYWORD_RETURN(WHILE);}
break;
case 41:
       {char str[STR_LEN];
                     if (flag > 0) flag++;
                     sprintf(str, "!");
                     if (hfind(strcat(str, yytext)) || flag == 4)
                             {
                              isaTYPE = 0;
                              if (flag == 4) flag = -1;
                              CountSymbol(IDENTIFIER);
                              WHITE_RETURN(IDENTIFIER);
                              }
                        else {
                              str[0] = '&';
                              if (hfind(str))
                                  IDENTIFIER_RETURN(MACRODEF)
                               else {
                                  if (hfind(yytext)) 
                                       isaTYPE = 1;
                                    else 
                                       if (isaTYPE) henter(yytext);

                                  if (isaTYPE) 
                                       IDENTIFIER_RETURN(TYPEDEFname)
                                    else 
                                       IDENTIFIER_RETURN(IDENTIFIER);
                                     }
                              }
                    }
break;
case 42:
 {NUMERICAL_RETURN(INTEGERconstant);}
break;
case 43:
   {NUMERICAL_RETURN(OCTALconstant);}
break;
case 44:
     {NUMERICAL_RETURN(HEXconstant);}
break;
case 45:
{NUMERICAL_RETURN(FLOATINGconstant);}
break;
case 46:
    {NUMERICAL_RETURN(CHARACTERconstant);}
break;
case 47:
    {CountLines(yytext);
                         LITERAL_RETURN(STRINGliteral);
                         }
break;
case 48:
                 {if (flag == -1) {
                        flag = -2;
                        CountSymbol('(');
                        WHITE_RETURN(LP);
                       }
                       else
                        ASCIIOP_RETURN(LP);}
break;
case 49:
       {if (flag == -2) {
                        flag = 0;
                        CountSymbol(')');
                        WHITE_RETURN(RP);
                       }
                       else
                        ASCIIOP_RETURN(RP);}
break;
case 50:
                 {ASCIIOP_RETURN(RP);}
break;
case 51:
                 {ASCIIOP_RETURN(COMMA);}
break;
case 52:
                 {ASCIIOP_RETURN(LC);}
break;
case 53:
                 {ASCIIOP_RETURN(RC);}
break;
case 54:
                 {ASCIIOP_RETURN(LB);}
break;
case 55:
                 {ASCIIOP_RETURN(RB);}
break;
case 56:
                 {ASCIIOP_RETURN(DOT);}
break;
case 57:
                 {ASCIIOP_RETURN(AND);}
break;
case 58:
                 {ASCIIOP_RETURN(STAR);}
break;
case 59:
                 {ASCIIOP_RETURN(PLUS);}
break;
case 60:
                 {ASCIIOP_RETURN(MINUS);}
break;
case 61:
                 {ASCIIOP_RETURN(NEGATE);}
break;
case 62:
                 {ASCIIOP_RETURN(NOT);}
break;
case 63:
                 {ASCIIOP_RETURN(DIV);}
break;
case 64:
                 {ASCIIOP_RETURN(MOD);}
break;
case 65:
                 {ASCIIOP_RETURN(LT);}
break;
case 66:
                 {ASCIIOP_RETURN(GT);}
break;
case 67:
                 {ASCIIOP_RETURN(XOR);}
break;
case 68:
                 {ASCIIOP_RETURN(PIPE);}
break;
case 69:
                 {ASCIIOP_RETURN(QUESTION);}
break;
case 70:
                 {ASCIIOP_RETURN(COLON);}
break;
case 71:
                 {ASCIIOP_RETURN(SEMICOLON);}
break;
case 72:
                 {ASCIIOP_RETURN(ASSIGN);}
break;
case 73:
                {NAMEDOP_RETURN(ARROW);}
break;
case 74:
                {NAMEDOP_RETURN(ICR);}
break;
case 75:
                {NAMEDOP_RETURN(DECR);}
break;
case 76:
                {NAMEDOP_RETURN(LS);}
break;
case 77:
                {NAMEDOP_RETURN(RS);}
break;
case 78:
                {NAMEDOP_RETURN(LE);}
break;
case 79:
                {NAMEDOP_RETURN(GE);}
break;
case 80:
                {NAMEDOP_RETURN(EQ);}
break;
case 81:
                {NAMEDOP_RETURN(NE);}
break;
case 82:
                {NAMEDOP_RETURN(ANDAND);}
break;
case 83:
                {NAMEDOP_RETURN(OROR);}
break;
case 84:
                {NAMEDOP_RETURN(MULTassign);}
break;
case 85:
                {NAMEDOP_RETURN(DIVassign);}
break;
case 86:
                {NAMEDOP_RETURN(MODassign);}
break;
case 87:
                {NAMEDOP_RETURN(PLUSassign);}
break;
case 88:
                {NAMEDOP_RETURN(MINUSassign);}
break;
case 89:
               {NAMEDOP_RETURN(LSassign);}
break;
case 90:
               {NAMEDOP_RETURN(RSassign);}
break;
case 91:
                {NAMEDOP_RETURN(ANDassign);}
break;
case 92:
                {NAMEDOP_RETURN(ERassign);}
break;
case 93:
                {NAMEDOP_RETURN(ORassign);}
break;
case 94:
               {NAMEDOP_RETURN(ELLIPSIS);}
break;
case 95:
                {ReadComment();}
break;
case 96:
   {
                      if (!pp_comment && hfind(yytext)) {
                              pp_comment = 1;
                              fprintf(stderr,"Line %d: %s\n",lines+1,yytext);
                              BeginLine = lines+1;
                           }
                      if (pp_comment) if_count++;
                      yyless(1);        /* yytext = "#" */
                      ReadPPline();
                      }
break;
case 97:
     {if (pp_comment && --if_count == 0) {
                              pp_comment = 0;
                              fprintf(stderr,"Length: %d\n",lines-BeginLine);
                           }
                      ReadPPline();
                      }
break;
case 98:
             {
                      if (if_count == 1)  {
                              pp_comment = 0;
                              if_count--;
                              fprintf(stderr,"Length: %d\n",lines-BeginLine);
                           }
                      ReadPPline();
                      }
break;
case 99:
                 {ReadPPline();}
break;
case 100:
                   /* Handling of unknown character */
                     {
                      fprintf(stderr, "\nline %d: lexical error",lines+1);
                      RETURN_VAL(0);
                      }
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/****************************   FUNCTIONS   ********************************

  CountSymbol(x)     -->  increases the respective number of identifiers
                          or symbols and the respective number of bytes
                          for the token x
  ReadComment()      -->  reads comment
  ReadPPline()       -->  reads preprocessor directives or PP comment
                          see above II.c
  CountLines(s)      -->  counts the number of lines in the string s

***************************************************************************/


CountSymbol (x)
int x;
{
  switch (x)
    {
    case IDENTIFIER:
    case TYPEDEFname:
    case MACRODEF:     num_identifier++;
	               bytes_identifier += yyleng;
                       break;

    default:           num_symbols++;
                       bytes_symbols += yyleng;
                       break;
    }
}

/***************************************************************************/

ReadComment()
{
  char c;

  while ((c=input()) != '*') {
           if (c == '\n') lines++;
           comments++;
         }

  comments++;
  if ((c=input()) == '/')
        comments += 3;
    else {
        unput(c);
        ReadComment();
      }
}

/***************************************************************************/

ReadPPline()
{
  char c;
  int ende = 0;

  if (pp_comment < 2) {      /* '#' is the beginning of a '#if'-PP directive *
     num_ppdirectives++;     /* that is no PP comment. */
     bytes_ppdirectives++;
     bytes++;         
     while (!ende)    
        switch (input())
         {
         case  '/': if ((c = input()) == '*')
                          ReadComment();
                    else {unput(c);
                          bytes_ppdirectives++; 
                          bytes++;}
                    break;
         
         case '\\': if ((c = input()) == '\n')
                         {lines++;
                          bytes_ppdirectives++;
                          bytes++;}
                    else  unput(c);
                    bytes_ppdirectives++;
                    bytes++;
                    break;

         case '\n': ende = 1;
                    lines++;
         default  : bytes_ppdirectives++;
                    bytes++;
                    break;
         }
  } else Pcomments++;               /* '#' is part of PP comment */

  if (pp_comment) {                 /* read PP comment up to the first '#' */
    while ((c = input()) != '#') {
           if (c == '\n') lines++;
           Pcomments++;
        }
    unput(c);
    pp_comment = 2;
   }
}

/***************************************************************************/

CountLines (string)
char *string;
{
  while (*string)
    if (*string++ == '\n') lines++;
}
int yyvstop[] = {
0,

100,
0,

1,
100,
0,

3,
0,

2,
100,
0,

62,
100,
0,

100,
0,

99,
100,
-97,
-98,
0,

41,
100,
-4,
0,

64,
100,
0,

57,
100,
0,

100,
0,

48,
100,
0,

50,
100,
-49,
0,

58,
100,
0,

59,
100,
0,

51,
100,
0,

60,
100,
0,

56,
100,
0,

63,
100,
0,

43,
100,
0,

42,
100,
0,

70,
100,
0,

71,
100,
0,

65,
100,
0,

72,
100,
0,

66,
100,
0,

69,
100,
0,

41,
100,
-4,
0,

54,
100,
0,

55,
100,
0,

67,
100,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

41,
100,
-4,
0,

52,
100,
0,

68,
100,
0,

53,
100,
0,

61,
100,
0,

1,
0,

2,
0,

81,
0,

47,
0,

41,
-4,
0,

86,
0,

82,
0,

91,
0,

49,
0,

84,
0,

74,
0,

87,
0,

75,
0,

88,
0,

73,
0,

45,
0,

95,
0,

85,
0,

43,
0,

43,
0,

43,
0,

42,
0,

42,
0,

42,
0,

76,
0,

78,
0,

80,
0,

79,
0,

77,
0,

92,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

16,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

24,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

93,
0,

83,
0,

47,
0,

96,
0,

4,
0,

5,
0,

7,
0,

46,
0,

94,
0,

45,
0,

45,
0,

43,
0,

44,
0,

42,
0,

89,
0,

90,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

22,
41,
-4,
0,

41,
-4,
0,

25,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

96,
0,

96,
0,

96,
0,

5,
0,

6,
0,

45,
0,

44,
0,

44,
0,

9,
41,
-4,
0,

41,
-4,
0,

11,
41,
-4,
0,

12,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

18,
41,
-4,
0,

19,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

23,
41,
-4,
0,

26,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

38,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

98,
0,

96,
0,

96,
0,

10,
41,
-4,
0,

13,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

21,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

29,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

36,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

40,
41,
-4,
0,

97,
0,

96,
0,

41,
-4,
0,

41,
-4,
0,

17,
41,
-4,
0,

20,
41,
-4,
0,

41,
-4,
0,

28,
41,
-4,
0,

30,
41,
-4,
0,

31,
41,
-4,
0,

32,
41,
-4,
0,

33,
41,
-4,
0,

34,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

8,
0,

41,
-4,
0,

15,
41,
-4,
0,

41,
-4,
0,

35,
41,
-4,
0,

41,
-4,
0,

41,
-4,
0,

14,
41,
-4,
0,

27,
41,
-4,
0,

37,
41,
-4,
0,

39,
41,
-4,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
1,6,	1,6,	1,6,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
4,53,	4,5,	4,54,	4,54,	
4,54,	1,4,	1,7,	1,8,	
1,9,	1,10,	1,11,	1,12,	
1,13,	1,14,	1,15,	1,16,	
1,17,	1,18,	1,19,	1,20,	
1,21,	1,22,	1,23,	4,53,	
6,54,	12,68,	6,55,	6,55,	
6,55,	1,23,	0,0,	1,24,	
1,25,	1,26,	1,27,	1,28,	
1,29,	7,56,	1,10,	9,60,	
9,60,	11,67,	1,10,	1,10,	
16,74,	15,72,	15,72,	6,54,	
12,69,	1,30,	27,95,	17,75,	
26,93,	26,94,	28,96,	28,97,	
33,99,	57,0,	1,10,	0,0,	
0,0,	1,10,	9,60,	19,77,	
1,31,	1,3,	1,32,	1,33,	
15,72,	17,76,	1,34,	1,35,	
1,36,	1,37,	1,38,	1,39,	
1,40,	80,143,	1,41,	19,78,	
19,79,	1,42,	21,82,	1,10,	
0,0,	50,125,	0,0,	1,43,	
1,44,	1,45,	1,46,	1,47,	
1,48,	40,112,	35,101,	15,73,	
1,49,	1,50,	1,51,	1,52,	
2,7,	21,83,	2,9,	30,57,	
2,11,	2,12,	34,100,	41,113,	
30,98,	2,16,	36,102,	2,18,	
2,19,	2,20,	2,21,	41,114,	
37,105,	36,103,	38,107,	39,110,	
38,108,	42,115,	39,111,	43,116,	
36,104,	2,24,	37,106,	2,26,	
2,27,	2,28,	38,109,	9,61,	
45,121,	46,122,	20,80,	9,62,	
20,81,	20,81,	20,81,	20,81,	
20,81,	20,81,	20,81,	20,81,	
20,81,	20,81,	47,123,	48,124,	
50,126,	61,130,	54,54,	61,131,	
62,132,	55,54,	93,151,	55,55,	
55,55,	55,55,	2,31,	15,73,	
2,32,	2,33,	44,117,	44,118,	
97,152,	2,35,	2,36,	2,37,	
2,38,	87,148,	2,40,	100,153,	
2,41,	54,54,	44,119,	2,42,	
55,54,	44,120,	70,0,	101,154,	
102,155,	2,43,	2,44,	2,45,	
2,46,	2,47,	2,48,	8,57,	
103,156,	88,148,	2,49,	2,50,	
104,157,	2,52,	98,0,	8,57,	
8,0,	8,57,	8,57,	8,57,	
59,57,	87,148,	105,158,	86,146,	
91,150,	86,146,	106,159,	70,140,	
86,147,	86,147,	86,147,	86,147,	
86,147,	86,147,	86,147,	86,147,	
86,147,	86,147,	8,57,	107,160,	
8,58,	88,148,	8,57,	98,0,	
59,127,	8,57,	8,57,	8,57,	
92,150,	8,57,	108,161,	109,162,	
110,163,	111,164,	8,57,	8,57,	
91,150,	112,165,	59,128,	59,128,	
114,166,	115,167,	8,57,	117,170,	
116,168,	8,57,	118,171,	119,173,	
120,175,	8,57,	121,176,	8,57,	
124,181,	122,177,	127,0,	8,57,	
8,57,	116,169,	10,63,	10,63,	
92,150,	131,185,	8,57,	122,178,	
119,174,	118,172,	123,179,	130,183,	
134,191,	123,180,	128,0,	8,57,	
153,203,	154,204,	8,57,	155,205,	
156,206,	130,184,	8,59,	157,207,	
157,208,	10,63,	158,209,	8,57,	
159,210,	10,64,	160,211,	161,212,	
8,57,	162,213,	10,65,	10,66,	
163,214,	165,215,	167,216,	168,217,	
8,57,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	169,218,	
128,182,	128,182,	59,129,	8,57,	
170,219,	171,220,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
172,221,	173,222,	174,223,	175,224,	
10,64,	176,225,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
10,64,	10,64,	10,64,	10,64,	
13,70,	177,226,	178,227,	179,228,	
180,229,	181,230,	129,0,	182,0,	
13,70,	13,0,	13,70,	13,70,	
13,70,	84,84,	84,84,	84,84,	
84,84,	84,84,	84,84,	84,84,	
84,84,	84,85,	84,85,	183,231,	
184,231,	185,232,	190,189,	190,189,	
194,237,	187,0,	197,0,	13,70,	
188,0,	13,70,	204,238,	13,70,	
207,239,	208,240,	13,0,	13,70,	
13,70,	84,87,	13,70,	209,241,	
129,129,	129,129,	210,242,	13,70,	
13,70,	190,189,	84,88,	141,0,	
129,129,	213,243,	147,145,	13,70,	
214,244,	217,245,	13,70,	197,140,	
147,145,	129,129,	13,70,	149,201,	
13,70,	129,129,	129,129,	218,246,	
13,70,	13,70,	219,247,	220,248,	
149,202,	84,87,	221,249,	13,70,	
222,250,	223,251,	224,252,	225,253,	
141,140,	226,254,	84,88,	227,255,	
13,70,	229,256,	147,145,	13,70,	
230,257,	141,197,	141,197,	13,71,	
147,145,	129,129,	200,145,	149,201,	
13,70,	232,258,	129,129,	233,0,	
200,145,	13,70,	195,195,	195,195,	
149,202,	234,0,	240,262,	241,263,	
22,81,	13,70,	22,84,	22,84,	
22,84,	22,84,	22,84,	22,84,	
22,84,	22,84,	22,85,	22,85,	
187,233,	242,264,	188,234,	243,265,	
13,70,	195,195,	200,145,	245,266,	
246,267,	248,268,	249,269,	22,86,	
200,145,	250,270,	195,196,	201,201,	
251,271,	195,196,	22,87,	252,272,	
253,273,	255,274,	256,275,	259,0,	
201,202,	262,277,	263,278,	22,88,	
266,279,	273,280,	22,89,	23,81,	
274,281,	23,90,	23,90,	23,90,	
23,90,	23,90,	23,90,	23,90,	
23,90,	23,90,	23,90,	22,86,	
275,282,	277,283,	279,284,	201,201,	
63,63,	63,63,	22,87,	260,260,	
260,260,	281,285,	23,86,	282,286,	
201,202,	0,0,	0,0,	22,88,	
0,0,	23,91,	22,89,	0,0,	
261,261,	261,261,	0,0,	0,0,	
0,0,	0,0,	23,92,	63,63,	
0,0,	0,0,	260,260,	63,133,	
234,259,	0,0,	0,0,	63,134,	
63,65,	63,135,	260,261,	0,0,	
0,0,	0,0,	23,86,	261,261,	
0,0,	0,0,	0,0,	0,0,	
0,0,	23,91,	0,0,	261,276,	
0,0,	0,0,	195,196,	0,0,	
0,0,	0,0,	23,92,	0,0,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	0,0,	0,0,	
0,0,	0,0,	63,133,	0,0,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	63,133,	63,133,	
63,133,	63,133,	65,65,	65,65,	
144,199,	0,0,	144,199,	0,0,	
0,0,	144,200,	144,200,	144,200,	
144,200,	144,200,	144,200,	144,200,	
144,200,	144,200,	144,200,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	65,65,	0,0,	0,0,	
0,0,	65,136,	85,81,	0,0,	
85,85,	85,85,	85,85,	85,85,	
85,85,	85,85,	85,85,	85,85,	
85,85,	85,85,	146,147,	146,147,	
146,147,	146,147,	146,147,	146,147,	
146,147,	146,147,	146,147,	146,147,	
0,0,	85,86,	0,0,	0,0,	
0,0,	0,0,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
0,0,	85,86,	0,0,	0,0,	
65,136,	0,0,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
65,136,	65,136,	65,136,	65,136,	
66,66,	66,66,	199,200,	199,200,	
199,200,	199,200,	199,200,	199,200,	
199,200,	199,200,	199,200,	199,200,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	66,66,	
0,0,	0,0,	0,0,	66,137,	
0,0,	0,0,	0,0,	66,138,	
66,139,	66,66,	0,0,	66,139,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	0,0,	0,0,	
0,0,	0,0,	66,137,	0,0,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	66,137,	66,137,	
66,137,	66,137,	71,70,	0,0,	
0,0,	0,0,	81,81,	81,81,	
81,81,	81,81,	81,81,	81,81,	
81,81,	81,81,	81,81,	81,81,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	71,70,	81,144,	
81,145,	0,0,	0,0,	71,70,	
0,0,	0,0,	81,145,	136,195,	
136,195,	0,0,	0,0,	0,0,	
71,141,	71,141,	71,141,	71,141,	
71,141,	71,141,	71,141,	71,141,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	71,70,	
0,0,	0,0,	136,195,	81,144,	
81,145,	0,0,	0,0,	0,0,	
0,0,	0,0,	81,145,	136,196,	
0,0,	0,0,	136,196,	0,0,	
0,0,	0,0,	136,136,	136,136,	
136,136,	136,136,	136,136,	136,136,	
136,136,	136,136,	136,136,	136,136,	
71,70,	0,0,	0,0,	0,0,	
0,0,	71,70,	71,70,	0,0,	
0,0,	0,0,	71,70,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	71,70,	0,0,	
0,0,	0,0,	71,70,	0,0,	
71,70,	0,0,	71,70,	0,0,	
71,142,	89,149,	89,149,	89,149,	
89,149,	89,149,	89,149,	89,149,	
89,149,	89,149,	89,149,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	89,149,	89,149,	
89,149,	89,149,	89,149,	89,149,	
0,0,	132,186,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	132,186,	132,0,	132,186,	
132,186,	132,186,	0,0,	136,196,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	89,149,	89,149,	
89,149,	89,149,	89,149,	89,149,	
132,186,	0,0,	132,186,	0,0,	
132,186,	0,0,	0,0,	132,186,	
132,186,	132,186,	0,0,	132,186,	
0,0,	0,0,	0,0,	0,0,	
132,186,	132,186,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
132,186,	0,0,	0,0,	132,186,	
0,0,	0,0,	0,0,	132,186,	
0,0,	132,186,	0,0,	0,0,	
0,0,	132,186,	132,186,	0,0,	
0,0,	0,0,	0,0,	0,0,	
132,186,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	132,186,	0,0,	0,0,	
132,186,	0,0,	133,189,	133,189,	
132,186,	0,0,	0,0,	0,0,	
0,0,	132,186,	0,0,	0,0,	
132,187,	0,0,	132,186,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	132,188,	0,0,	
0,0,	133,189,	132,186,	0,0,	
132,186,	133,133,	132,186,	0,0,	
0,0,	0,0,	133,190,	0,0,	
0,0,	132,186,	0,0,	0,0,	
0,0,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
0,0,	0,0,	0,0,	0,0,	
133,133,	0,0,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
133,133,	133,133,	133,133,	133,133,	
135,192,	135,192,	0,0,	235,260,	
235,260,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	135,192,	
0,0,	0,0,	235,260,	135,193,	
0,0,	0,0,	0,0,	135,194,	
0,0,	135,135,	235,261,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	235,235,	235,235,	
235,235,	235,235,	235,235,	235,235,	
235,235,	235,235,	235,235,	235,235,	
0,0,	0,0,	0,0,	0,0,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	0,0,	0,0,	
0,0,	0,0,	135,193,	0,0,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	135,193,	135,193,	
135,193,	135,193,	137,137,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	0,0,	0,0,	0,0,	
0,0,	137,137,	0,0,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	138,138,	138,138,	236,189,	
236,189,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
138,138,	0,0,	236,189,	0,0,	
138,137,	0,0,	0,0,	0,0,	
138,138,	0,0,	138,138,	236,190,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	236,236,	236,236,	
236,236,	236,236,	236,236,	236,236,	
236,236,	236,236,	236,236,	236,236,	
0,0,	0,0,	0,0,	0,0,	
0,0,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	0,0,	
0,0,	0,0,	0,0,	138,137,	
0,0,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	138,137,	
138,137,	138,137,	138,137,	142,198,	
142,198,	142,198,	142,198,	142,198,	
142,198,	142,198,	142,198,	142,198,	
142,198,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
142,198,	142,198,	142,198,	142,198,	
142,198,	142,198,	0,0,	186,186,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	186,186,	
186,0,	186,186,	186,186,	186,186,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
198,0,	0,0,	0,0,	0,0,	
142,198,	142,198,	142,198,	142,198,	
142,198,	142,198,	186,186,	0,0,	
186,186,	0,0,	186,186,	0,0,	
0,0,	186,186,	186,186,	186,186,	
0,0,	186,186,	0,0,	0,0,	
0,0,	0,0,	186,186,	186,186,	
0,0,	198,140,	0,0,	0,0,	
0,0,	0,0,	186,186,	0,0,	
0,0,	186,186,	198,198,	198,198,	
0,0,	186,186,	0,0,	186,186,	
0,0,	0,0,	198,198,	186,186,	
186,186,	189,189,	189,189,	0,0,	
0,0,	0,0,	186,186,	198,198,	
0,0,	0,0,	0,0,	198,198,	
198,198,	0,0,	0,0,	186,186,	
0,0,	0,0,	186,186,	0,0,	
0,0,	0,0,	186,186,	0,0,	
189,189,	0,0,	0,0,	186,186,	
189,235,	0,0,	0,0,	0,0,	
186,186,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	198,198,	
186,186,	0,0,	0,0,	0,0,	
198,198,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	186,186,	
0,0,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	0,0,	
0,0,	0,0,	191,236,	189,235,	
0,0,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	189,235,	
189,235,	189,235,	189,235,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	0,0,	0,0,	0,0,	
0,0,	191,236,	0,0,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	191,236,	191,236,	191,236,	
191,236,	192,192,	192,192,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
192,192,	0,0,	0,0,	0,0,	
192,193,	0,0,	0,0,	0,0,	
192,194,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	0,0,	
0,0,	0,0,	0,0,	192,193,	
0,0,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	192,193,	
192,193,	192,193,	192,193,	193,193,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	0,0,	0,0,	
0,0,	237,193,	193,193,	0,0,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	193,193,	193,193,	
193,193,	193,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
0,0,	0,0,	0,0,	0,0,	
237,193,	0,0,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
237,193,	237,193,	237,193,	237,193,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-95,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+19,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+43,	yysvec+4,	yyvstop+8,
yycrank+4,	0,		yyvstop+11,
yycrank+-214,	0,		yyvstop+14,
yycrank+58,	0,		yyvstop+16,
yycrank+277,	0,		yyvstop+21,
yycrank+8,	0,		yyvstop+25,
yycrank+15,	0,		yyvstop+28,
yycrank+-399,	0,		yyvstop+31,
yycrank+0,	0,		yyvstop+33,
yycrank+64,	0,		yyvstop+36,
yycrank+11,	0,		yyvstop+40,
yycrank+36,	0,		yyvstop+43,
yycrank+0,	0,		yyvstop+46,
yycrank+46,	0,		yyvstop+49,
yycrank+116,	0,		yyvstop+52,
yycrank+68,	0,		yyvstop+55,
yycrank+462,	0,		yyvstop+58,
yycrank+505,	0,		yyvstop+61,
yycrank+0,	0,		yyvstop+64,
yycrank+0,	0,		yyvstop+67,
yycrank+20,	0,		yyvstop+70,
yycrank+17,	0,		yyvstop+73,
yycrank+21,	0,		yyvstop+76,
yycrank+0,	0,		yyvstop+79,
yycrank+97,	yysvec+10,	yyvstop+82,
yycrank+0,	0,		yyvstop+86,
yycrank+0,	0,		yyvstop+89,
yycrank+23,	0,		yyvstop+92,
yycrank+17,	yysvec+10,	yyvstop+95,
yycrank+8,	yysvec+10,	yyvstop+99,
yycrank+41,	yysvec+10,	yyvstop+103,
yycrank+43,	yysvec+10,	yyvstop+107,
yycrank+38,	yysvec+10,	yyvstop+111,
yycrank+39,	yysvec+10,	yyvstop+115,
yycrank+10,	yysvec+10,	yyvstop+119,
yycrank+33,	yysvec+10,	yyvstop+123,
yycrank+38,	yysvec+10,	yyvstop+127,
yycrank+50,	yysvec+10,	yyvstop+131,
yycrank+86,	yysvec+10,	yyvstop+135,
yycrank+39,	yysvec+10,	yyvstop+139,
yycrank+51,	yysvec+10,	yyvstop+143,
yycrank+63,	yysvec+10,	yyvstop+147,
yycrank+71,	yysvec+10,	yyvstop+151,
yycrank+0,	0,		yyvstop+155,
yycrank+52,	0,		yyvstop+158,
yycrank+0,	0,		yyvstop+161,
yycrank+0,	0,		yyvstop+164,
yycrank+0,	yysvec+4,	yyvstop+167,
yycrank+169,	yysvec+4,	0,	
yycrank+172,	yysvec+4,	yyvstop+169,
yycrank+0,	0,		yyvstop+171,
yycrank+-75,	yysvec+8,	0,	
yycrank+0,	0,		yyvstop+173,
yycrank+-218,	yysvec+8,	0,	
yycrank+0,	yysvec+9,	0,	
yycrank+69,	0,		0,	
yycrank+78,	0,		0,	
yycrank+559,	0,		0,	
yycrank+0,	yysvec+10,	yyvstop+175,
yycrank+673,	0,		0,	
yycrank+787,	0,		0,	
yycrank+0,	0,		yyvstop+178,
yycrank+0,	0,		yyvstop+180,
yycrank+0,	0,		yyvstop+182,
yycrank+-196,	yysvec+13,	0,	
yycrank+900,	0,		0,	
yycrank+0,	yysvec+15,	0,	
yycrank+0,	0,		yyvstop+184,
yycrank+0,	0,		yyvstop+186,
yycrank+0,	0,		yyvstop+188,
yycrank+0,	0,		yyvstop+190,
yycrank+0,	0,		yyvstop+192,
yycrank+0,	0,		yyvstop+194,
yycrank+0,	0,		yyvstop+196,
yycrank+59,	0,		0,	
yycrank+866,	0,		yyvstop+198,
yycrank+0,	0,		yyvstop+200,
yycrank+0,	0,		yyvstop+202,
yycrank+365,	yysvec+23,	yyvstop+204,
yycrank+664,	0,		0,	
yycrank+188,	0,		0,	
yycrank+112,	0,		yyvstop+206,
yycrank+141,	0,		yyvstop+208,
yycrank+973,	0,		0,	
yycrank+0,	yysvec+23,	yyvstop+210,
yycrank+147,	0,		yyvstop+212,
yycrank+180,	0,		yyvstop+214,
yycrank+121,	0,		yyvstop+216,
yycrank+0,	0,		yyvstop+218,
yycrank+0,	0,		yyvstop+220,
yycrank+0,	0,		yyvstop+222,
yycrank+131,	0,		yyvstop+224,
yycrank+-212,	yysvec+13,	0,	
yycrank+0,	0,		yyvstop+226,
yycrank+83,	yysvec+10,	yyvstop+228,
yycrank+106,	yysvec+10,	yyvstop+231,
yycrank+93,	yysvec+10,	yyvstop+234,
yycrank+119,	yysvec+10,	yyvstop+237,
yycrank+110,	yysvec+10,	yyvstop+240,
yycrank+128,	yysvec+10,	yyvstop+243,
yycrank+117,	yysvec+10,	yyvstop+246,
yycrank+132,	yysvec+10,	yyvstop+250,
yycrank+141,	yysvec+10,	yyvstop+253,
yycrank+143,	yysvec+10,	yyvstop+256,
yycrank+149,	yysvec+10,	yyvstop+259,
yycrank+147,	yysvec+10,	yyvstop+262,
yycrank+149,	yysvec+10,	yyvstop+265,
yycrank+0,	yysvec+10,	yyvstop+268,
yycrank+152,	yysvec+10,	yyvstop+272,
yycrank+159,	yysvec+10,	yyvstop+275,
yycrank+169,	yysvec+10,	yyvstop+278,
yycrank+160,	yysvec+10,	yyvstop+281,
yycrank+171,	yysvec+10,	yyvstop+284,
yycrank+178,	yysvec+10,	yyvstop+287,
yycrank+171,	yysvec+10,	yyvstop+290,
yycrank+166,	yysvec+10,	yyvstop+293,
yycrank+176,	yysvec+10,	yyvstop+296,
yycrank+189,	yysvec+10,	yyvstop+299,
yycrank+175,	yysvec+10,	yyvstop+302,
yycrank+0,	0,		yyvstop+305,
yycrank+0,	0,		yyvstop+307,
yycrank+-272,	yysvec+8,	yyvstop+309,
yycrank+-288,	yysvec+8,	0,	
yycrank+-396,	yysvec+8,	0,	
yycrank+190,	0,		0,	
yycrank+189,	0,		0,	
yycrank+-1044,	0,		yyvstop+311,
yycrank+1125,	0,		yyvstop+313,
yycrank+254,	0,		0,	
yycrank+1239,	yysvec+66,	0,	
yycrank+934,	yysvec+65,	0,	
yycrank+1326,	0,		yyvstop+315,
yycrank+1440,	0,		0,	
yycrank+0,	0,		yyvstop+317,
yycrank+0,	0,		yyvstop+319,
yycrank+-441,	yysvec+13,	0,	
yycrank+1515,	0,		0,	
yycrank+0,	0,		yyvstop+321,
yycrank+641,	0,		0,	
yycrank+0,	0,		yyvstop+323,
yycrank+674,	0,		0,	
yycrank+384,	yysvec+146,	yyvstop+325,
yycrank+0,	0,		yyvstop+327,
yycrank+387,	yysvec+89,	yyvstop+329,
yycrank+0,	0,		yyvstop+331,
yycrank+0,	0,		yyvstop+333,
yycrank+0,	0,		yyvstop+335,
yycrank+189,	yysvec+10,	yyvstop+337,
yycrank+204,	yysvec+10,	yyvstop+340,
yycrank+202,	yysvec+10,	yyvstop+343,
yycrank+190,	yysvec+10,	yyvstop+346,
yycrank+192,	yysvec+10,	yyvstop+349,
yycrank+213,	yysvec+10,	yyvstop+352,
yycrank+214,	yysvec+10,	yyvstop+355,
yycrank+213,	yysvec+10,	yyvstop+358,
yycrank+206,	yysvec+10,	yyvstop+361,
yycrank+216,	yysvec+10,	yyvstop+364,
yycrank+223,	yysvec+10,	yyvstop+367,
yycrank+0,	yysvec+10,	yyvstop+370,
yycrank+210,	yysvec+10,	yyvstop+374,
yycrank+0,	yysvec+10,	yyvstop+377,
yycrank+219,	yysvec+10,	yyvstop+381,
yycrank+218,	yysvec+10,	yyvstop+384,
yycrank+218,	yysvec+10,	yyvstop+387,
yycrank+226,	yysvec+10,	yyvstop+390,
yycrank+231,	yysvec+10,	yyvstop+393,
yycrank+267,	yysvec+10,	yyvstop+396,
yycrank+253,	yysvec+10,	yyvstop+399,
yycrank+253,	yysvec+10,	yyvstop+402,
yycrank+255,	yysvec+10,	yyvstop+405,
yycrank+272,	yysvec+10,	yyvstop+408,
yycrank+290,	yysvec+10,	yyvstop+411,
yycrank+297,	yysvec+10,	yyvstop+414,
yycrank+303,	yysvec+10,	yyvstop+417,
yycrank+307,	yysvec+10,	yyvstop+420,
yycrank+297,	yysvec+10,	yyvstop+423,
yycrank+-397,	yysvec+8,	0,	
yycrank+321,	0,		0,	
yycrank+323,	0,		0,	
yycrank+320,	0,		0,	
yycrank+-1586,	0,		yyvstop+426,
yycrank+-419,	yysvec+186,	yyvstop+428,
yycrank+-422,	yysvec+186,	yyvstop+430,
yycrank+1648,	0,		0,	
yycrank+417,	0,		0,	
yycrank+1706,	0,		0,	
yycrank+1820,	yysvec+66,	0,	
yycrank+1907,	yysvec+133,	yyvstop+432,
yycrank+386,	yysvec+138,	0,	
yycrank+493,	0,		0,	
yycrank+0,	0,		yyvstop+434,
yycrank+-420,	yysvec+13,	0,	
yycrank+-1598,	yysvec+13,	0,	
yycrank+750,	0,		0,	
yycrank+424,	yysvec+199,	yyvstop+436,
yycrank+459,	0,		yyvstop+438,
yycrank+0,	yysvec+201,	yyvstop+440,
yycrank+0,	yysvec+10,	yyvstop+442,
yycrank+327,	yysvec+10,	yyvstop+446,
yycrank+0,	yysvec+10,	yyvstop+449,
yycrank+0,	yysvec+10,	yyvstop+453,
yycrank+320,	yysvec+10,	yyvstop+457,
yycrank+332,	yysvec+10,	yyvstop+460,
yycrank+326,	yysvec+10,	yyvstop+463,
yycrank+338,	yysvec+10,	yyvstop+466,
yycrank+0,	yysvec+10,	yyvstop+469,
yycrank+0,	yysvec+10,	yyvstop+473,
yycrank+339,	yysvec+10,	yyvstop+477,
yycrank+340,	yysvec+10,	yyvstop+480,
yycrank+0,	yysvec+10,	yyvstop+483,
yycrank+0,	yysvec+10,	yyvstop+487,
yycrank+342,	yysvec+10,	yyvstop+491,
yycrank+353,	yysvec+10,	yyvstop+494,
yycrank+354,	yysvec+10,	yyvstop+497,
yycrank+370,	yysvec+10,	yyvstop+500,
yycrank+363,	yysvec+10,	yyvstop+503,
yycrank+371,	yysvec+10,	yyvstop+506,
yycrank+378,	yysvec+10,	yyvstop+509,
yycrank+379,	yysvec+10,	yyvstop+512,
yycrank+379,	yysvec+10,	yyvstop+515,
yycrank+371,	yysvec+10,	yyvstop+518,
yycrank+380,	yysvec+10,	yyvstop+521,
yycrank+0,	yysvec+10,	yyvstop+524,
yycrank+369,	yysvec+10,	yyvstop+528,
yycrank+387,	yysvec+10,	yyvstop+531,
yycrank+0,	0,		yyvstop+534,
yycrank+395,	0,		0,	
yycrank+-489,	yysvec+186,	yyvstop+536,
yycrank+-495,	yysvec+186,	yyvstop+538,
yycrank+1242,	yysvec+189,	0,	
yycrank+1442,	yysvec+191,	0,	
yycrank+1965,	yysvec+138,	0,	
yycrank+0,	yysvec+10,	yyvstop+540,
yycrank+0,	yysvec+10,	yyvstop+544,
yycrank+396,	yysvec+10,	yyvstop+548,
yycrank+399,	yysvec+10,	yyvstop+551,
yycrank+420,	yysvec+10,	yyvstop+554,
yycrank+413,	yysvec+10,	yyvstop+557,
yycrank+0,	yysvec+10,	yyvstop+560,
yycrank+411,	yysvec+10,	yyvstop+564,
yycrank+418,	yysvec+10,	yyvstop+567,
yycrank+0,	yysvec+10,	yyvstop+570,
yycrank+429,	yysvec+10,	yyvstop+574,
yycrank+428,	yysvec+10,	yyvstop+577,
yycrank+434,	yysvec+10,	yyvstop+580,
yycrank+420,	yysvec+10,	yyvstop+583,
yycrank+435,	yysvec+10,	yyvstop+586,
yycrank+439,	yysvec+10,	yyvstop+589,
yycrank+0,	yysvec+10,	yyvstop+592,
yycrank+431,	yysvec+10,	yyvstop+596,
yycrank+437,	yysvec+10,	yyvstop+599,
yycrank+0,	yysvec+10,	yyvstop+602,
yycrank+0,	0,		yyvstop+606,
yycrank+-533,	yysvec+186,	yyvstop+608,
yycrank+562,	0,		0,	
yycrank+575,	0,		0,	
yycrank+428,	yysvec+10,	yyvstop+610,
yycrank+430,	yysvec+10,	yyvstop+613,
yycrank+0,	yysvec+10,	yyvstop+616,
yycrank+0,	yysvec+10,	yyvstop+620,
yycrank+447,	yysvec+10,	yyvstop+624,
yycrank+0,	yysvec+10,	yyvstop+627,
yycrank+0,	yysvec+10,	yyvstop+631,
yycrank+0,	yysvec+10,	yyvstop+635,
yycrank+0,	yysvec+10,	yyvstop+639,
yycrank+0,	yysvec+10,	yyvstop+643,
yycrank+0,	yysvec+10,	yyvstop+647,
yycrank+447,	yysvec+10,	yyvstop+651,
yycrank+451,	yysvec+10,	yyvstop+654,
yycrank+456,	yysvec+10,	yyvstop+657,
yycrank+0,	0,		yyvstop+660,
yycrank+464,	yysvec+10,	yyvstop+662,
yycrank+0,	yysvec+10,	yyvstop+665,
yycrank+452,	yysvec+10,	yyvstop+669,
yycrank+0,	yysvec+10,	yyvstop+672,
yycrank+473,	yysvec+10,	yyvstop+676,
yycrank+474,	yysvec+10,	yyvstop+679,
yycrank+0,	yysvec+10,	yyvstop+682,
yycrank+0,	yysvec+10,	yyvstop+686,
yycrank+0,	yysvec+10,	yyvstop+690,
yycrank+0,	yysvec+10,	yyvstop+694,
0,	0,	0};
struct yywork *yytop = yycrank+2087;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,013 ,014 ,015 ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
040 ,01  ,'"' ,01  ,'$' ,01  ,01  ,047 ,
'(' ,')' ,'(' ,'+' ,')' ,'+' ,01  ,01  ,
'0' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,
'8' ,'8' ,01  ,';' ,01  ,01  ,01  ,'?' ,
01  ,'A' ,'A' ,'A' ,'A' ,'E' ,'F' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'L' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'U' ,'$' ,'$' ,
'X' ,'$' ,'$' ,01  ,0134,01  ,01  ,'$' ,
01  ,'a' ,'a' ,'A' ,'A' ,'E' ,'f' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'L' ,'$' ,'n' ,'$' ,
'$' ,'$' ,'n' ,'$' ,'n' ,'U' ,'n' ,'$' ,
'X' ,'$' ,'$' ,';' ,01  ,'}' ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,1,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,1,1,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
