static char rcsid[]="$Id: commands.c,v 1.10 94/02/06 14:33:02 mangin Exp $";
#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <math.h>
#include <tk.h>
#include <tcl.h>
#include <ppm.h>

#if HAS_INRIM
#include <inrimage/image.h>
extern struct image *image_();
#endif

/**  Computes the bounding box of non-white pixels in a ppm image  **/

void ppmBbox(st, x1, y1, x2, y2)
     FILE *st;
     int *x1, *y1, *x2, *y2;
{
  int width, height;
  pixval maxval;
  int format, i, j;
  int *xflag, *yflag, flag;
  pixel whitep;
  register pixel *linebuf, *plinebuf;

  fseek(st, 0, 0);
  ppm_readppminit(st, &width, &height, &maxval, &format);

  xflag = (int *)malloc(width * sizeof(int));
  yflag = (int *)malloc(height * sizeof(int));
  
  whitep = ppm_parsecolor("white", maxval);
  linebuf = ppm_allocrow(width);
  for (i = 0; i < width; i++)
    xflag[i] = 1;

  for (j = 0; j < height; j++) {
    /*  read in the line  */
    ppm_readppmrow(st, linebuf, width, maxval, format);

    yflag[j] = 1;
    plinebuf = linebuf;
    for (i = 0; i < width; i++, plinebuf++) {
      flag = PPM_EQUAL(whitep, *plinebuf);
      yflag[j] &= flag;
      xflag[i] &= flag;
    }
  }

  free(linebuf);

  *x1 = 0;
  while ((*x1 < width) && xflag[*x1]) (*x1)++;
  
  *x2 = width-1;
  while ((*x2 >= 0) && xflag[*x2]) (*x2)--;
  (*x2)++;
  
  *y1 = 0;
  while ((*y1 < height) && yflag[*y1]) (*y1)++;

  *y2 = height - 1;
  while ((*y2 >= 0) && yflag[*y2]) (*y2)--;
  (*y2)++;
  
  *x1 -= 2;
  if (*x1 < 0) *x1 = 0;
  *y1 -= 2;
  if (*y1 < 0) *y1 = 0;
  *x2 += 2;
  if (*x2 > width) *x2 = width;
  *y2 += 2;
  if (*y2 > height) *y2 = height;
  
  free(xflag);
  free(yflag);
}


/**
 **  ppm2picCmd
 **    Converts a ppm file into a file in internal pic format
 **/

int ppm2picCmd(clientData, interp, argc, argv)
     ClientData clientData;              /* Inutilise. */
     Tcl_Interp *interp;                 /* Interpreteur tcl. */
     int argc;                           /* Nombre d'arguments. */
     char **argv;                        /* Arguments passes a la commande tcl. */
{
  /**  syntax : ppm2pic ?-strip? ppmfile picfile ?offset?  **/

  char *ppmfile, *picfile;
  FILE *stin, *stout;
  int offset, width, height, format;
  int dstw, dsth;
  pixval maxval;
  float *dst, *pdst, *dstend;
  register pixel *src, *psrc, *srcend;
  float a, maxlum;
  int i, j, strip;
  int x1, x2, y1, y2;
    
  /****  Parse arguments  ****/

  if ((argc < 3) || (argc > 5)) {
    Tcl_AppendResult (interp, "Wrong # of arguments: should be \"",
		      argv[0], " ?-strip? ppmfile picfile ?offset?", "\"", (char*)0);
    return(TCL_ERROR);
  }

  if (!strcmp(argv[1], "-strip")) {
    i = 2;
    strip = 1;
  } else {
    i = 1;
    strip = 0;
  }

  ppmfile = argv[i++];
  picfile = argv[i++];

  if (i < argc) {
    if (Tcl_GetInt(interp, argv[i], &offset) != TCL_OK) {
      return(TCL_ERROR);
    }
  } else {
    offset = 0;
  }

  /****  open ppm input file  ****/

  stin = fopen(ppmfile, "r");
  if (stin == (FILE *)0) {
    Tcl_AppendResult (interp, "Couldn't open ", ppmfile, " for reading", (char*)0);
    return(TCL_ERROR);
  }

  ppm_readppminit(stin, &width, &height, &maxval, &format);
  src = ppm_allocrow(width);
  srcend = src + width;

  /****  Compute bbox  ****/
  if (strip) {
    ppmBbox(stin, &x1, &y1, &x2, &y2);
    dstw = x2-x1;
    dsth = y2-y1;
  } else {
    x1 = y1 = 0;
    x2 = width;
    y2 = height;
    dstw = width;
    dsth = height;
  }

  /****  open picasso output file  ****/

  stout = fopen(picfile, "a");
  if (stout == (FILE *)0) {
    Tcl_AppendResult (interp, "Couldn't open ", picfile, " for writing", (char*)0);
    fclose(stin);
    pbm_freerow(src);
    return(TCL_ERROR);
  }

  fseek(stout, (long)offset, 0);
  fwrite(&dstw, sizeof(int), 1, stout);
  fwrite(&dsth, sizeof(int), 1, stout);

  dst = (float *)malloc(dstw*dsth*sizeof(float));
  
  /****  Convert  ****/

  fseek(stin, 0, 0);
  ppm_readppminit(stin, &width, &height, &maxval, &format);

  for (j = 0; j < y1; j++)
    ppm_readppmrow(stin, src, width, maxval, format);

  pdst = dst;
  maxlum = 0.0;
  srcend = src + x2;
  for (j = y1; j < y2; j++) {
    ppm_readppmrow(stin, src, width, maxval, format);
    psrc = src + x1;
    while (psrc < srcend) {
      *pdst = PPM_LUMIN(*psrc);
      if (*pdst > maxlum) maxlum = *pdst;
      pdst++;
      psrc++;
    }
  }

  a = 1.0/maxlum;
  pdst = dst;
  dstend = dst + dstw*dsth;
  while (pdst < dstend)
    *pdst++ *= a;

  fwrite(dst, sizeof(float), dstw*dsth, stout);  
  
  /****  close and free ****/
  pbm_freerow(src);
  free(dst);
  fclose(stin);
  fclose(stout);

  return(TCL_OK);
}

#if HAS_INRIM

/**
 **  inrim2picCmd
 **  
 **    Converts an inrimage file
 **    into a pic internal format file
 **/

int inrim2picCmd(clientData, interp, argc, argv)
     ClientData clientData;              /* Inutilise. */
     Tcl_Interp *interp;                 /* Interpreteur tcl. */
     int argc;                           /* Nombre d'arguments. */
     char **argv;                        /* Arguments passes a la commande tcl. */
{
  /**  syntax : inrim2pic inrimfile picfile ?offset?  **/
  char *inrimfile, *picfile;
  FILE *stout;
  struct image *im;
  long lfmt[9];
  int offset;
  float *dst, *pdst, *dstend;
  float a, b, minval, maxval;
  int width, height;
    
  /****  Parse arguments  ****/

  if ((argc < 3) || (argc > 4)) {
    Tcl_AppendResult (interp, "Wrong # of arguments: should be \"",
		      argv[0], " inrimfile picfile ?offset?", "\"", (char*)0);
    return(TCL_ERROR);
  }

  inrimfile = argv[1];
  picfile = argv[2];

  if (argc == 4) {
    if (Tcl_GetInt(interp, argv[3], &offset) != TCL_OK) {
      return(TCL_ERROR);
    }
  } else {
    offset = 0;
  }

  /****  open inrim input file  ****/

  im = (struct image *)image_(inrimfile, "e", "", lfmt);
  if (im == (struct image *)0) {
    Tcl_AppendResult (interp, "Couldn't open ", inrimfile, " for reading", (char*)0);
    return(TCL_ERROR);
  }

  width = lfmt[0];
  height = lfmt[1];

  /****  open picasso output file  ****/

  stout = fopen(picfile, "a");
  if (stout == (FILE *)0) {
    Tcl_AppendResult (interp, "Couldn't open ", picfile, " for writing", (char*)0);
    fermnf_(&im);
    return(TCL_ERROR);
  }

  fseek(stout, (long)offset, 0);
  fwrite(&width, sizeof(int), 1, stout);
  fwrite(&height, sizeof(int), 1, stout);

  dst = (float *)malloc(width*height*sizeof(float));
  
  /****  Convert  ****/

  c_lecflt(im, height, dst);

  pdst = dst;
  dstend = dst + width*height;
  minval = maxval = *dst;

  while (pdst < dstend) {
    if (*pdst > maxval) maxval = *pdst;
    if (*pdst < minval) minval = *pdst;
    pdst++;
  }

  a = 1.0 / (maxval - minval);
  b = 1.0 - a * maxval;

  pdst = dst;
  while (pdst < dstend) {
    *pdst = a * (*pdst) + b;
    if (*pdst < 0.0) *pdst = 0.0;
    if (*pdst > 1.0) *pdst = 1.0;
    pdst++;
  }

  fwrite(dst, sizeof(float), width*height, stout);
  
  /****  close and free ****/
  free(dst);
  fermnf_(&im);
  fclose(stout);

  return(TCL_OK);
}
#endif



/**
 **  rotateCoordsCmd
 **  
 **    Applies a rotation on a list of points.
 **    In angle mode (argv[1] == "-angle"),
 **      angle is argv[1] in degrees and
 **      center is center of bbox given in argv[2] .. argv[5]
 **    In point mode (argv[1] == "-points"),
 **      center is (xc,yc) and angle is the angle
 **      between (x1-xc,y1-yc) and (x2-xc,y2-yc)
 **/

int rotateCoordsCmd(clientData, interp, argc, argv)
     ClientData clientData;              /* Inutilise. */
     Tcl_Interp *interp;                 /* Interpreteur tcl. */
     int argc;                           /* Nombre d'arguments. */
     char **argv;                        /* Arguments passes a la commande tcl. */
{
  double angle;
  double xc, yc, x1, y1, x2, y2, n, rotc, rots, x, y;
  char buf[TCL_DOUBLE_SPACE];
  int i, firstCoord;
  
  /**  syntax : rotateCoords -angle <angle> xc yc <x1> <y1> ... **/
  /**  or       rotateCoords -points xc yc x1 y1 x2 y2 <x1> <y1> ...  **/

  if (argc < 5) {
    Tcl_AppendResult (interp, "Wrong # of arguments: should be \"",
		      argv[0],
		      " angle ?-angle angle xc yc?",
		      " ?-points xc yc x1 y1 x2 y2?",
		      " xcoord1 ycoord1 ...",
		      "\"", (char*)0);
    return(TCL_ERROR);
  }

  if (!strcmp(argv[1], "-points")) {
    if (argc == 8)
      return(TCL_OK);
    
    if ((Tcl_GetDouble(interp, argv[2], &xc) != TCL_OK) ||
	(Tcl_GetDouble(interp, argv[3], &yc) != TCL_OK) ||
	(Tcl_GetDouble(interp, argv[4], &x1) != TCL_OK) ||
	(Tcl_GetDouble(interp, argv[5], &y1) != TCL_OK) ||
	(Tcl_GetDouble(interp, argv[6], &x2) != TCL_OK) ||
	(Tcl_GetDouble(interp, argv[7], &y2) != TCL_OK)) {
      return(TCL_ERROR);
    }

    x1 -= xc;
    y1 -= yc;
    x2 -= xc;
    y2 -= yc;
    n = sqrt(x1*x1+y1*y1);
    x1 /= n;
    y1 /= n;
    n = sqrt(x2*x2+y2*y2);
    x2 /= n;
    y2 /= n;
    rotc = x1*x2 + y1*y2;
    rots = - x1*y2 + x2*y1; /* y screen != y math */
    firstCoord = 8;
    
  } else if (!strcmp(argv[1], "-angle")) {
    if (argc == 5)
      return(TCL_OK);

    if ((Tcl_GetDouble(interp, argv[2], &angle) != TCL_OK) ||
	(Tcl_GetDouble(interp, argv[3], &xc) != TCL_OK) ||
	(Tcl_GetDouble(interp, argv[4], &yc) != TCL_OK)) {
      return(TCL_ERROR);
    }

    angle *= M_PI / 180.0;
    rotc = (double)cos(angle);
    rots = (double)sin(angle);
    firstCoord = 5;
  }

  if (((argc - firstCoord)%2) != 0) {
    Tcl_AppendResult (interp, "Wrong # of arguments: odd number of coordinates",
		      (char*)0);
    return(TCL_ERROR);
  }

  for (i = firstCoord; i < argc; i += 2) {
    if ((Tcl_GetDouble(interp, argv[i], &x) != TCL_OK) ||
	(Tcl_GetDouble(interp, argv[i+1], &y) != TCL_OK)) {
      return(TCL_ERROR);
    }

    x -= xc;
    y -= yc;

    Tcl_PrintDouble(interp, xc + rotc * x + rots * y, buf);
    Tcl_AppendElement(interp, buf);
    Tcl_PrintDouble(interp, yc - rots * x + rotc * y, buf);
    Tcl_AppendElement(interp, buf);
  }

  return(TCL_OK);
}

/**
 **  pointAngleCmd
 **
 **    Compute the angle between M0M1 and M0M2  
 **/

int pointAngleCmd(clientData, interp, argc, argv)
     ClientData clientData;              /* Inutilise. */
     Tcl_Interp *interp;                 /* Interpreteur tcl. */
     int argc;                           /* Nombre d'arguments. */
     char **argv;                        /* Arguments passes a la commande tcl. */
{
  char *buf;
  double x0, y0, x1, y1, x2, y2;

  buf = (char *)malloc(TCL_DOUBLE_SPACE * sizeof(char));
  
  /**  syntax : pointAngle x0 y0 x1 y1 x2 y2  **/
  if (argc != 7) {
    Tcl_AppendResult (interp, "Wrong # of arguments: should be \"",
		      argv[0],
		      " x0 y0 x1 y1 x2 y2",
		      "\"", (char*)0);
    return(TCL_ERROR);
  }
  
  if ((Tcl_GetDouble(interp, argv[1], &x0) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[2], &y0) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[3], &x1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[4], &y1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[5], &x2) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[6], &y2) != TCL_OK)) {
    return(TCL_ERROR);
  }

  x1 -= x0;
  y1 -= y0;
  x2 -= x0;
  y2 -= y0;

  if (((x1==0.0)&&(y1==0.0)) ||
      ((x2==0.0)&&(y2==0.0))) {
    return(TCL_ERROR);
  } else {
    Tcl_PrintDouble(interp,
		    180.0*(atan2(-y2, x2) - atan2(-y1,x1))/M_PI, buf);
    Tcl_SetResult(interp, buf, TCL_DYNAMIC);
    return(TCL_OK);
  }
}

/***************************************************************
 ****       Computes axial symetry of a set of points        ****
 ***************************************************************/

int axialSymCoordsCmd(clientData, interp, argc, argv)
     ClientData clientData;              /* Inutilise. */
     Tcl_Interp *interp;                 /* Interpreteur tcl. */
     int argc;                           /* Nombre d'arguments. */
     char **argv;                        /* Arguments passes a la commande tcl. */
{
  char buf[TCL_DOUBLE_SPACE];
  double ax1, ay1, ax2, ay2, x, y;
  double u, v, norm, a, b, c;
  int i;
  
  /**  syntax : axialSymCoordsCmd axex1 axey1 axex2 axey2 x1 y1 ... **/
  
  if (argc < 5) {
    Tcl_AppendResult (interp, "Wrong # of arguments: should be \"",
		      argv[0],
		      " axe_x1 axe_y1 axe_x2 axe_y2", 
		      " xcoord1 ycoord1 ...",
		      "\"", (char*)0);
    return(TCL_ERROR);
  }

  if ((Tcl_GetDouble(interp, argv[1], &ax1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[2], &ay1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[3], &ax2) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[4], &ay2) != TCL_OK)) {
      return(TCL_ERROR);
    }


  u = ax2-ax1;
  v = ay2-ay1;

  norm = 1.0/(u*u+v*v);
  a = norm*v*v;
  b = 2*norm*u*v;
  c = norm*u*u;
  
  for (i = 5; i < argc; i += 2) {
    if ((Tcl_GetDouble(interp, argv[i], &x) != TCL_OK) ||
	(Tcl_GetDouble(interp, argv[i+1], &y) != TCL_OK)) {
      return(TCL_ERROR);
    }

    Tcl_PrintDouble(interp,
		    a*(2*ax1-x) + b*(y - ay1) + c*x, buf);
    Tcl_AppendElement(interp, buf);
    Tcl_PrintDouble(interp,
		    a*y + b*(x - ax1) + c*(2*ay1-y), buf);
    Tcl_AppendElement(interp, buf);
  }
    
  return(TCL_OK);
}

/***************************************************************
 ****	Flips horizontally a set of coordinates             ****
 ****     Axe of symetry is the middle line of the bbox      ****
 ****	     passed in argv[1] ... argv[4]                  ****
 ***************************************************************/

int hflipCoordsCmd(clientData, interp, argc, argv)
     ClientData clientData;              /* Inutilise. */
     Tcl_Interp *interp;                 /* Interpreteur tcl. */
     int argc;                           /* Nombre d'arguments. */
     char **argv;                        /* Arguments passes a la commande tcl. */
{
  double bbx1, bby1, bbx2, bby2;
  double y, yc2;
  char buf[TCL_DOUBLE_SPACE];
  int i;
  
  /**  syntax : hflipCoords <bbx1> <bby1> <bbx2> <bby2> <x1> <y1> ... **/

  if ((argc < 4) || ((argc%1) != 0)) {
    Tcl_AppendResult (interp, "Wrong # of arguments: should be \"",
		      argv[0],
		      " bbx1 bby1 bbx2 bby2 x1 y1 ...",
		      "\"", (char*)0);
    return(TCL_ERROR);
  }

  if (argc == 4)
    return(TCL_OK);

  if ((Tcl_GetDouble(interp, argv[1], &bbx1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[2], &bby1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[3], &bbx2) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[4], &bby2) != TCL_OK)) {
    return(TCL_ERROR);
  }

  yc2 = (bby1+bby2);

  for (i = 5; i < argc; i += 2) {
    if (Tcl_GetDouble(interp, argv[i+1], &y) != TCL_OK) {
      return(TCL_ERROR);
    }

    Tcl_AppendElement(interp, argv[i]);
    Tcl_PrintDouble(interp,  yc2 - y, buf);
    Tcl_AppendElement(interp, buf);
  }

  return(TCL_OK);
}
  
/***************************************************************
 ****	Flips vertically a set of coordinates             ****
 ****     Axe of symetry is the middle line of the bbox      ****
 ****	     passed in argv[1] ... argv[4]                  ****
 ***************************************************************/

int vflipCoordsCmd(clientData, interp, argc, argv)
     ClientData clientData;              /* Inutilise. */
     Tcl_Interp *interp;                 /* Interpreteur tcl. */
     int argc;                           /* Nombre d'arguments. */
     char **argv;                        /* Arguments passes a la commande tcl. */
{
  double bbx1, bby1, bbx2, bby2;
  double x, xc2;
  char buf[TCL_DOUBLE_SPACE];
  int i;
  
  /**  syntax : vflipCoords <bbx1> <bby1> <bbx2> <bby2> <x1> <y1> ... **/

  if ((argc < 4) || ((argc%2) != 1)) {
    Tcl_AppendResult (interp, "Wrong # of arguments: should be \"",
		      argv[0],
		      " bbx1 bby1 bbx2 bby2 x1 y1 ...",
		      "\"", (char*)0);
    return(TCL_ERROR);
  }

  if (argc == 4)
    return(TCL_OK);

  if ((Tcl_GetDouble(interp, argv[1], &bbx1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[2], &bby1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[3], &bbx2) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[4], &bby2) != TCL_OK)) {
    return(TCL_ERROR);
  }

  xc2 = (bbx1+bbx2);

  for (i = 5; i < argc; i += 2) {
    if (Tcl_GetDouble(interp, argv[i], &x) != TCL_OK) {
      return(TCL_ERROR);
    }

    Tcl_PrintDouble(interp,  xc2 - x, buf);
    Tcl_AppendElement(interp, buf);
    Tcl_AppendElement(interp, argv[i+1]);
  }

  return(TCL_OK);
}

/***************************************************************
 ****	  Given coordinates of image vertices,              ****
 ****	    returns image config parameters:                ****
 ****	   center, dims, angle, and flip flag               ****
 ***************************************************************/

int vertices2ConfigCmd(clientData, interp, argc, argv)
     ClientData clientData;              /* Inutilise. */
     Tcl_Interp *interp;                 /* Interpreteur tcl. */
     int argc;                           /* Nombre d'arguments. */
     char **argv;                        /* Arguments passes a la commande tcl. */
{
  double xc, yc, x1, y1, x2, y2, x3, y3, x4, y4;
  double d12, d34, d23, d41;
  double angle;
  int flip;
  
  char buf[TCL_DOUBLE_SPACE];
  
  if (argc != 11) {
    Tcl_AppendResult (interp, "Wrong # of arguments: should be \"",
		      argv[0], " xc yc x1 y1 x2 y2 x3 y3 x4 y4",
		      "\"", (char*)0);
    return(TCL_ERROR);
  }

  if ((Tcl_GetDouble(interp, argv[1], &xc) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[2], &yc) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[3], &x1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[4], &y1) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[5], &x2) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[6], &y2) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[7], &x3) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[8], &y3) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[9], &x4) != TCL_OK) ||
      (Tcl_GetDouble(interp, argv[10], &y4) != TCL_OK)) {
    return TCL_ERROR;
  }
  
  /**  center  **/
  Tcl_PrintDouble(interp, 0.25 * (x1+x2+x3+x4), buf);
  Tcl_AppendResult(interp, buf, (char *)0);
  Tcl_PrintDouble(interp, 0.25 * (y1+y2+y3+y4), buf);
  Tcl_AppendResult(interp, " ", buf, (char *)0);

  /**  dims  **/
  d12 = sqrt((x2-x1)*(x2-x1) + (y2-y1)*(y2-y1));
  d34 = sqrt((x4-x3)*(x4-x3) + (y4-y3)*(y4-y3));
  Tcl_PrintDouble(interp, 0.5 * (d12+d34), buf);
  Tcl_AppendResult(interp, " -width ", buf, (char *)0);

  d23 = sqrt((x3-x2)*(x3-x2) + (y3-y2)*(y3-y2));
  d41 = sqrt((x1-x4)*(x1-x4) + (y1-y4)*(y1-y4));
  Tcl_PrintDouble(interp, 0.5 * (d23+d41), buf);
  Tcl_AppendResult(interp, " -height ", buf, (char *)0);

  /**  angle & flip **/
  angle = 0.5*atan2(y1-y2, x2-x1) + 0.5*atan2(y4-y3, x3-x4);
  flip = ( (x2-x1)*(y3-y2) - (y2-y1)*(x3-x2) < 0 );

  if (flip) {
    angle = 180.0 + angle * 180.0 / M_PI;
    if (angle >= 360.0) angle -= 360.0;

    Tcl_PrintDouble(interp, angle, buf);
    Tcl_AppendResult(interp, " -angle ", buf, " -flip 1", (char *)0);
  } else {
    Tcl_PrintDouble(interp, angle * 180.0 / M_PI, buf);
    Tcl_AppendResult(interp, " -angle ", buf, " -flip 0", (char *)0);
  }

  return(TCL_OK);
}
