static char rcsid[]="$Id: picasso.c,v 1.16 94/02/14 14:54:44 mangin Exp $";

/*
 * Modified by Frank Mangin - Tue Jan 25 12:16:05 MET 1994
 * to start-up picasso with interactive shell if Debug
 */

/*
 * tkXshell.c
 *
 * Version of Tk main that is modified to build a wish shell with the Extended
 * Tcl command set and libraries.  This makes it easier to use a different
 * main.
 *-----------------------------------------------------------------------------
 * Copyright 1991-1993 Karl Lehenbauer and Mark Diekhans.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Karl Lehenbauer and
 * Mark Diekhans make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *-----------------------------------------------------------------------------
 * $Id: picasso.c,v 1.16 94/02/14 14:54:44 mangin Exp $
 *-----------------------------------------------------------------------------
 */

/* 
 * main.c --
 *
 *	This file contains the main program for "wish", a windowing
 *	shell based on Tk and Tcl.  It also provides a template that
 *	can be used as the basis for main programs for other Tk
 *	applications.
 *
 * Copyright (c) 1990-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#ifndef PicassoLib
#define PicassoLib ""
#endif

#ifndef HAS_INRIM
#define HAS_INRIM 0
#endif

#include <tclExtend.h>
#include <tk.h>
#include <stdlib.h>
#ifndef PicassoLib
#define PicassoLib ""
#endif

#ifndef HAS_INRIM
#define HAS_INRIM 0
#endif

#ifdef __cplusplus
#    include <tcl++.h>
#    include <unistd.h>
#else
#    include <tclExtend.h>
#endif

#include <tk.h>
#include <stdlib.h>
#include <string.h>

#define strinit(S,V) \
  ((S) = (char *)malloc((1+strlen(V))*sizeof(char)), sprintf((S),(V)))

/*
 * The following variable is a special hack that allows applications
 * to be linked using the procedure "main" from the Tk library.  The
 * variable generates a reference to "main", which causes main to
 * be brought in from the library (and all of Tk and Tcl with it).
 */

extern int main();
int *tclDummyMainPtr = (int *) main;

/*
 * Global variables used by the main program:
 */

static Tk_Window mainWindow;	/* The main window for the application.  If
				 * NULL then the application no longer
				 * exists. */
static Tcl_Interp *interp;	/* Interpreter for this application. */
char *tcl_RcFileName = NULL;	/* Name of a user-specific startup script
				 * to source if the application is being run
				 * interactively (e.g. "~/.wishrc").  Set
				 * by Tcl_AppInit.  NULL means don't source
				 * anything ever. */
static Tcl_DString command;	/* Used to assemble lines of terminal input
				 * into Tcl commands. */
static int gotPartial = 0;      /* Partial command in buffer. */
static int tty;			/* Non-zero means standard input is a
				 * terminal-like device.  Zero means it's
				 * a file. */
static char errorExitCmd[] = "exit 1";

/*
 * Command-line options:
 */

int synchronize = 0;
char *display = NULL;
char *geometry = NULL;
char *name = NULL;
char *fileName = NULL;
char *libDir;

Tk_ArgvInfo argTable[] = {
    {"-geometry", TK_ARGV_STRING, (char *) NULL, (char *) &geometry,
	"Initial geometry for window"},
    {"-display", TK_ARGV_STRING, (char *) NULL, (char *) &display,
	"Display to use"},
    {"-sync", TK_ARGV_CONSTANT, (char *) 1, (char *) &synchronize,
	"Use synchronous mode for display server"},
    {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
	(char *) NULL}
};

/*
 * Forward declarations for procedures defined later in this file:
 */

static void		StdinProc _ANSI_ARGS_((ClientData clientData,
			    int mask));
static void		SignalProc _ANSI_ARGS_((int signalNum));



/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	Main program for Wish.
 *
 * Results:
 *	None. This procedure never returns (it exits the process when
 *	it's done
 *
 * Side effects:
 *	This procedure initializes the wish world and then starts
 *	interpreting commands;  almost anything could happen, depending
 *	on the script being interpreted.
 *
 *----------------------------------------------------------------------
 */

int
main (argc, argv)
    int argc;				/* Number of arguments. */
    char **argv;			/* Array of argument strings. */
{
    char *args, *p, *msg;
    char buf[20];
    int code;

    interp = Tcl_CreateInterp();
#ifdef TCL_MEM_DEBUG
    Tcl_InitMemory(interp);
#endif

    /*
     * Parse command-line arguments.
     */

    if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv, argTable, 0)
	    != TCL_OK) {
	fprintf(stderr, "%s\n", interp->result);
	exit(1);
    }

    strinit(name, "picasso");
    
    /*
     * If a display was specified, put it into the DISPLAY
     * environment variable so that it will be available for
     * any sub-processes created by us.
     */

    if (display != NULL) {
	Tcl_SetVar2(interp, "env", "DISPLAY", display, TCL_GLOBAL_ONLY);
    }

    /*
     * Set the "tcl_interactive" variable.
     */

#ifdef DEBUG
    Tcl_SetVar(interp, "tcl_interactive", "1", TCL_GLOBAL_ONLY);
#else
    Tcl_SetVar(interp, "tcl_interactive", "0", TCL_GLOBAL_ONLY);
#endif

    /*
     * Initialize the Tk application.
     */

    mainWindow = Tk_CreateMainWindow(interp, display, name, "Tk");
    if (mainWindow == NULL) {
	fprintf(stderr, "%s\n", interp->result);
	exit(1);
    }
    Tk_SetClass(mainWindow, "Picasso");
    if (synchronize) {
	XSynchronize(Tk_Display(mainWindow), True);
    }
    Tk_GeometryRequest(mainWindow, 200, 200);

    /*
     * Make command-line arguments available in the Tcl variables "argc"
     * and "argv".  Also set the "geometry" variable from the geometry
     * specified on the command line.
     */
    
    args = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    sprintf(buf, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", (fileName != NULL) ? fileName : argv[0],
	    TCL_GLOBAL_ONLY);
    if (geometry != NULL) {
	Tcl_SetVar(interp, "geometry", geometry, TCL_GLOBAL_ONLY);
    }

    /*
     * Invoke application-specific initialization.
     */
#if HAS_INIRM
    inr_init(argc, argv, 0, 0, 0);
#endif

    if (TclX_AppInit(interp) != TCL_OK) {
	TclX_ErrorExit (interp, 255);
    }

    /*
     * Set the geometry of the main window, if requested.
     */

    if (geometry != NULL) {
	code = Tcl_VarEval(interp, "wm geometry . ", geometry, (char *) NULL);
	if (code != TCL_OK) {
	    fprintf(stderr, "%s\n", interp->result);
	}
    }

    /**  Run the tcl file  **/

    code = Tcl_VarEval(interp, "source ",  libDir, "/picasso.tcl", (char *)0);
    if (code != TCL_OK) {
      goto error;
    }
    tty = 0;
    
    /*
     * Commands will come from standard input.  Set up a handler
     * to receive those characters and print a prompt if the input
     * device is a terminal.
     */

#ifdef DEBUG
    tclErrorSignalProc = SignalProc;
    Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
    tty = isatty(0);
    if (tty) {
      TclX_OutputPrompt (interp, 1);
    }
    Tcl_DStringInit(&command);
#endif

    tclSignalBackgroundError = Tk_BackgroundError;

    fflush(stdout);

    /*
     * Loop infinitely, waiting for commands to execute.  When there
     * are no windows left, Tk_MainLoop returns and we exit.
     */

    Tk_MainLoop();

    /*
     * Don't exit directly, but rather invoke the Tcl "exit" command.
     * This gives the application the opportunity to redefine "exit"
     * to do additional cleanup.
     * (Tcl_VarEval is used to keep GCC happy).
     */
    
    Tcl_VarEval(interp, "exit", (char *) NULL);
    exit(1);

  error:
    msg = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    if (msg == NULL) {
	msg = interp->result;
    }
    fprintf(stderr, "%s\n", msg);
    Tcl_VarEval(interp, errorExitCmd, (char *) NULL);
    exit (1);
    return 1;   /* Needed only to prevent compiler warnings. */
}

/*
 *----------------------------------------------------------------------
 *
 * SignalProc --
 *
 *	Function called on a signal generating an error to clear the stdin
 *   	buffer.
 *----------------------------------------------------------------------
 */

static void
SignalProc (signalNum)
    int  signalNum;
{
    tclGotErrorSignal = 0;
    Tcl_DStringFree (&command);
    gotPartial = 0;
    if (tty) {
        fputc ('\n', stdout);
        TclX_OutputPrompt (interp, !gotPartial);
    }
}

/*
 *----------------------------------------------------------------------
 *
 * StdinProc --
 *
 *	This procedure is invoked by the event dispatcher whenever
 *	standard input becomes readable.  It grabs the next line of
 *	input characters, adds them to a command being assembled, and
 *	executes the command if it's complete.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Could be almost arbitrary, depending on the command that's
 *	typed.
 *
 *----------------------------------------------------------------------
 */

static void
StdinProc(clientData, mask)
    ClientData clientData;		/* Not used. */
    int mask;				/* Not used. */
{
#define BUFFER_SIZE 4000
    char input[BUFFER_SIZE+1];
    char *cmd;
    int code, count;

    count = read(fileno(stdin), input, BUFFER_SIZE);
    if (count <= 0) {
	if (!gotPartial) {
	    if (tty) {
		Tcl_VarEval(interp, "exit", (char *) NULL);
		exit(1);
	    } else {
		Tk_DeleteFileHandler(0);
	    }
	    return;
	} else {
	    count = 0;
	}
    }
    cmd = Tcl_DStringAppend(&command, input, count);
    if (count != 0) {
	if ((input[count-1] != '\n') && (input[count-1] != ';')) {
	    gotPartial = 1;
	    goto exitPoint;
	}
	if (!Tcl_CommandComplete(cmd)) {
	    gotPartial = 1;
	    goto exitPoint;
	}
    }
    gotPartial = 0;

    /*
     * Disable the stdin file handler;  otherwise if the command
     * re-enters the event loop we might process commands from
     * stdin before the current command is finished.  Among other
     * things, this will trash the text of the command being evaluated.
     */

    Tk_CreateFileHandler(0, 0, StdinProc, (ClientData) 0);
    code = Tcl_RecordAndEval(interp, cmd, 0);
    Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
    if (tty)
        TclX_PrintResult (interp, code, cmd);
    Tcl_DStringFree(&command);

  exitPoint:
    if (tty) {
        TclX_OutputPrompt (interp, !gotPartial);
    }
}

/****  Additionnal Tcl commands  ****/
extern void ImageItemTypeCreate();
extern void LatexItemTypeCreate();
extern void RrectangleItemTypeCreate();
extern void DlineItemTypeCreate();
extern void DRectOvalItemTypeCreate();
extern void TexPosItemTypeCreate();

extern int ppm2picCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

extern int rotateCoordsCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

extern int pointAngleCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

extern int vertices2ConfigCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

extern int hflipCoordsCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

extern int vflipCoordsCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

extern int axialSymCoordsCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

extern int boxinCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

#if HAS_INRIM
extern int inrim2picCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

#endif

extern int ctailCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

extern int lfindCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));

extern int lvarrmCmd
  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	       int argc, char **argv));


/*
 *----------------------------------------------------------------------
 *
 * TclX_AppInit --
 *
 *      This procedure performs application-specific initialization.
 *      Most applications, especially those that incorporate additional
 *      packages, will have their own version of this procedure.
 *
 * Results:
 *      Returns a standard Tcl completion code, and leaves an error
 *      message in interp->result if an error occurs.
 *
 * Side effects:
 *      Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
TclX_AppInit(interp)
    Tcl_Interp *interp;         /* Interpreter for application. */
{
    Tk_Window main;
    
    main = Tk_MainWindow(interp);

    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */

    if (TclX_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
    if (TkX_Init(interp) == TCL_ERROR) {
        return TCL_ERROR;
    }
    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

#define ShortCreateCommand(A,B) \
    Tcl_CreateCommand(interp, (A), (B), (ClientData)0, (Tcl_CmdDeleteProc *)0)
    
    ImageItemTypeCreate();
    LatexItemTypeCreate();
    RrectangleItemTypeCreate();
    DlineItemTypeCreate();
    DRectOvalItemTypeCreate();
    TexPosItemTypeCreate();
    ShortCreateCommand("ppm2pic", ppm2picCmd);
    ShortCreateCommand("rotateCoords", rotateCoordsCmd);
    ShortCreateCommand("pointAngle", pointAngleCmd);
    ShortCreateCommand("hflipCoords", hflipCoordsCmd);
    ShortCreateCommand("vflipCoords", vflipCoordsCmd);
    ShortCreateCommand("axialSymCoords", axialSymCoordsCmd);
    ShortCreateCommand("vertices2Config", vertices2ConfigCmd);
#if HAS_INRIM
    ShortCreateCommand("inrim2pic", inrim2picCmd);
#endif

    ShortCreateCommand("ctail", ctailCmd);
    ShortCreateCommand("lfind", lfindCmd);
    ShortCreateCommand("lvarrm", lvarrmCmd);
    ShortCreateCommand("boxin",  boxinCmd);

    /**  Set search paths for tcl from environment variables, or **/
    /**  from compilation defines  **/

  if (((libDir = getenv("PicassoLib")) == (char *)0) ||
      (*libDir == '\0'))
    libDir = PicassoLib;

  if (Tcl_SetVar(interp, "PicassoLib", libDir,
		 TCL_GLOBAL_ONLY | TCL_LEAVE_ERR_MSG) == NULL)
    return(TCL_ERROR);

  if (Tcl_SetVar(interp, "HasInrim",
#if HAS_INRIM  
		 "1",

#else
		 "0",
#endif		 
		 TCL_GLOBAL_ONLY | TCL_LEAVE_ERR_MSG) == NULL)
    return(TCL_ERROR);

#ifdef DEBUG
  Tcl_SetVar(interp, "Debug", "1", TCL_GLOBAL_ONLY);
#else
  Tcl_SetVar(interp, "Debug", "0", TCL_GLOBAL_ONLY);
#endif

  return(TCL_OK);
}
