################################################################
####		    Object creation                         ####
################################################################

####  Start Creation Hook  ####

proc createStart_hook {} {
  focus [cv]
  grab set [cv]
}

####  End creation hook  ####

proc createEnd_hook {} {

  grab release [cv]
  foreach item [[cv] find withtag inCreation] {
    
    ##  Minimal size checking  ##
    switch [[cv] type $item] {
      text {
	if {[[cv] index $item 0] == [[cv] index $item end]} {
	  [cv] delete $item
	  continue
	}	
      }
      default {
	lassign [[cv] bbox $item] x1 y1 x2 y2
	if {([expr "abs($x1-$x2)"] < 8) && ([expr "abs($y1-$y2)"] < 8)} {
	  [cv] delete $item
	  continue
	}
      }
    }
    
    ##  init group tags  ##
    set tags [[cv] gettags $item]
    if {[lsearch -glob $tags tGr*] < 0} {
      lappend tags "tGr.$item" "Gr.$item"
      [cv] itemconfigure $item -tags $tags
    }
    
    ##  Select created objects  ##
    [cv] addtag s withtag $item
    [cv] addtag sOfr withtag $item
    putFrame "tGr.$item"
  }
  
  [cv] dtag all inCreation
  focus .
  [cv] raise ltxFr
  [cv] raise latex
}

####  Generic functions for line, rectangle, oval and such  ####

proc csimpleMotion {x y} {
  dragMotion inCreation $x $y
}

proc csimpleEnd {} {
  createEnd_hook
}

################################################################
####			  Text                              ####
################################################################

set FontStyle {-adobe-courier-bold-r-normal--<SIZE>-0-100-100-m-0-iso8859-1}
set FontSize  14

proc setFontStyle {style} {
  global FontStyle FontSize

  set FontStyle $style
  regsub {<SIZE>} "$FontStyle" "$FontSize" name
  SetStyle font $name
}

proc setFontSize {size} {
  global FontStyle FontSize

  set FontSize $size
  regsub {<SIZE>} "$FontStyle" "$FontSize" name
  SetStyle font $name
}

proc ctextStart {x y} {

  global currentStyle
  
  set inc [[cv] find withtag inCreation]
  set cur [[cv] find withtag current]
  
  if {($inc != "") && ($inc != $cur)} {
    # an item is in creation and user clicked elsewhere #
    # => end creation #
    ctextEnd
  }

  if {($inc != "") && ($inc == $cur)} {
    # user clicked in the text item he's creating #
    [cv] icursor $cur @$x,$y
    return
  }

  ##  No item was being created  ##

  if {[[cv] type $cur] == "text"} {
    #  user wants to modify an old item  #
    deselect_all
    [cv] addtag inCreation withtag $cur
    createStart_hook
    # in case item comes from a load drawing #
    bind_item_emacs_like $cur
    [cv] focus $cur
    [cv] icursor $cur @$x,$y
    return
  }
  
  ## New item creation ##

  createStart_hook
  deselect_all
  focus [cv]
  set created [eval "[cv] create text $x $y $currentStyle(text) \
		 -tags {inCreation}"]
  
  [cv] focus $created
  bind_item_emacs_like $created
}

proc ctextEnd {} {
  [cv] focus {}
  createEnd_hook
}

####  Rectangle  ####

proc crectangleStart {x y} {
  global currentStyle
  global CurrentMode
  global xdragOrigin ydragOrigin

  set xdragOrigin $x
  set ydragOrigin $y

  createStart_hook
  deselect_all
  if {$CurrentMode == "RectangleMode"} {
    eval "[cv] create orectangle \
            $x $y -width 0 -height 0 \
            $currentStyle(orectangle) \
            -tags {inCreation}"
  } else {
    eval "[cv] create frectangle \
           $x $y -width 0 -height 0 \
            $currentStyle(frectangle) \
            -tags {inCreation}"
  }
}

proc crectangleMotion {x y} {
  global CurrentMode
  global xdragOrigin ydragOrigin
  
  set id [[cv] find withtag inCreation]
  [cv] coords $id \
    [expr 0.5 * ($xdragOrigin + $x)] \
    [expr 0.5 * ($ydragOrigin + $y)]
  [cv] itemconfigure $id \
    -width [abs "$x - $xdragOrigin"] \
    -height [abs "$y - $ydragOrigin"]
}

####  Generic functions for polygons and closed curves  ####

set ModeState 0
set NumPoints 0

proc cpolygonStart {x y type} {
  global ModeState NumPoints currentStyle
  
  switch $NumPoints {
    0 {
      #  create a temporary line  #
      createStart_hook
      deselect_all
      set ModeState 1
      set NumPoints 2
      eval "[cv] create line $x $y $x $y \
            -fill red \
            -tags {inCreation}"
    }
    1 {
      error "Bug..."
    }
    2 {
      #  replace the temporary line by the polygon  #
      incr NumPoints
      set coords [[cv] coords inCreation]
      [cv] delete withtag inCreation
      eval "[cv] create polygon \
              $coords [lrange $coords 2 3] \
              $currentStyle(polygon) \
              -tags {inCreation}"
      if {$type == "CloseCurveMode"} {
	[cv] itemconfigure inCreation -smooth 1
      }
    }
    default {
      incr NumPoints
      set it [[cv] find withtag inCreation]
      set cc [[cv] coords $it]
      set last [expr "[llength $cc] - 5"]
      eval "[cv] coords $it [lrange $cc 0 $last] $x $y $x $y"
    }
  }
}

proc cpolygonDelete {x y type} {
  global ModeState NumPoints currentStyle
  
  if {$NumPoints > 3} {
    incr NumPoints -1
    set it [[cv] find withtag inCreation]
    set cc [[cv] coords $it]
    set last [expr "[llength $cc] - 5"]
    eval "[cv] delete $it"
    eval "[cv] create polygon \
            [lrange $cc 0 $last] \
            $currentStyle(polygon) \
            -tags {inCreation}"
    if {$type == "CloseCurveMode"} {
      [cv] itemconfigure inCreation -smooth 1
    }
    update
    cpolygonMotion $x $y
  } else {
    if {$ModeState} {
      set ModeState 0
      set NumPoints 0
      [cv] delete inCreation
      createEnd_hook
    }
  }
}

proc cpolygonMotion {x y} {
  global ModeState NumPoints
  
  if {$ModeState} {
    set it [[cv] find withtag inCreation]
    set cc [[cv] coords $it]
    set last [expr "[llength $cc] - 3"]
    
    ##  polygon automatically adds start coordinates  ##
    ##  at the end of the coord list  ##
    if {$NumPoints > 2} {
      incr last -2
    }
    eval "[cv] coords $it [lrange $cc 0 $last] $x $y"
  }
}

proc cpolygonEnd {} {
  global ModeState NumPoints

  if {$NumPoints <= 2} {
    [cv] delete inCreation
  } else {
    createEnd_hook
  }
  set ModeState 0
  set NumPoints 0
}

####  Generic functions for polylines and curves  ####

set ModeState 0
set NumPoints 0

proc cpolylineStart {x y} {
  global ModeState NumPoints
  global currentStyle CurrentMode

  if {$ModeState == 0} {
    createStart_hook
    deselect_all
    set ModeState 1
    set  NumPoints 2
    eval "[cv] create dline $x $y $x $y \
            $currentStyle(dline) \
            -tags {inCreation}"
  } else {
    incr NumPoints
    set it [[cv] find withtag inCreation]
    if {$CurrentMode == "CurveMode"} {
      [cv] itemconfigure $it -smooth 1
    }
    set cc [[cv] coords $it]
    set last [expr "[llength $cc] - 2"]
    eval "[cv] coords $it [lreplace $cc $last end $x $y $x $y]"
  }
}

proc cpolylineDelete {x y} {
  global ModeState NumPoints CurrentMode

  if {$NumPoints > 2} {
    incr NumPoints -1
    set it [[cv] find withtag inCreation]
    set cc [[cv] coords $it]
    set last [expr "[llength $cc] - 3"]
    eval "[cv] coords $it [lrange $cc 0 $last]"
    if {($NumPoints == 2) &&
      ($CurrentMode == "CurveMode")} {
      [cv] itemconfigure $it -smooth 0
    }
  } else {
    if {$ModeState == 1} {
      set ModeState 0
      set NumPoints 0
      [cv] delete inCreation
      createEnd_hook
    }
  }
}

proc cpolylineMotion {x y} {
  global ModeState CurrentMode
  
  if {$ModeState > 0} {
    set it [[cv] find withtag inCreation]
    set cc [[cv] coords $it]
    set last [expr "[llength $cc] - 2"]
    eval "[cv] coords $it [lreplace $cc $last end $x $y]"
  }
}

proc cpolylineEnd {} {
  global ModeState NumPoints CurrentMode
  
  if {$CurrentMode == "CurveMode"} {
    [cv] itemconfigure inCreation -smooth 1
  }
  set ModeState 0
  set NumPoints 0
  createEnd_hook
}

####  Oval  ####

proc covalStart {x y} {
  global x1fixed y1fixed
  global currentStyle
  global CurrentMode

  createStart_hook
  deselect_all
  set x1fixed 1
  set y1fixed 1
  
  set item [eval "[cv] create doval $x $y $x $y \
                    $currentStyle(doval) \
                    -tags {inCreation}"]
}

####  Circles  ####

#  Only the motion function is changing  #

proc ccircleStart {x y} {
  return [covalStart $x $y]
}

proc ccircleMotion {x y} {
  global x1fixed y1fixed
  ##  Get the smallest from dx and dy  ##
  set bb [[cv] coords inCreation]
  if {$x1fixed} {
    set xbase [lindex $bb 0]
  } else {
    set xbase [lindex $bb 2]
  }
  if {$y1fixed} {
    set ybase [lindex $bb 1]
  } else {
    set ybase [lindex $bb 3]
  }
  if {[expr "(abs($x - $xbase)) > (abs($y - $ybase))"]} {
    dragMotion inCreation $x [expr "$ybase + $x - $xbase"]
  } else {
    dragMotion inCreation [expr "$xbase + $y - $ybase"] $y
  }
}

####  Arc  ####

##  Arcs are created by <1> once to set the center, second <1>  ##
##  to set first extremity, and third <1> to set second extremity  ##

set ModeState 0
set rad2deg [expr "180 / 3.14159"]

##  Utils  ##

proc angle {x1 y1 x2 y2} {
  global rad2deg
  ##  retourne l'angle en degre du vecteur M1M2  ##
  return \
    [expr "$rad2deg * atan2(-$y2+$y1,$x2-$x1)"]
}

proc computeArcCoords {id} {
  #  given id config, computes circle center and  #
  #  first arc extremity coords  #

  global ArcCoords rad2deg
  lassign [[cv] coords $id] bbx1 bby1 bbx2 bby2
  set rayon [abs [expr 0.5 * ($bbx2 - $bbx1)]]
  set xc [expr 0.5 * ($bbx2 + $bbx1)]
  set yc [expr 0.5 * ($bby2 + $bby1)]
  set alpha [expr [lindex [[cv] itemconfigure $id -start] 4] / $rad2deg]
  set x1 [expr $xc + $rayon * [cos $alpha]]
  set y1 [expr $yc - $rayon * [sin $alpha]]

  set ArcCoords($id) "$rayon $xc $yc $x1 $y1"
  return $ArcCoords($id)
}

##  Creation  ##

proc carcStart {x y} {
  global currentStyle
  global ModeState CurrentMode
  
  switch $ModeState {
    0 {
      saveMsg
      msg "Set first extremity with mouse button 1"
      createStart_hook
      deselect_all
      ##  set center ##
      [cv] create line $x $y $x $y \
	-width 1 -fill red \
	-tags {carcl1 ctl}
      incr ModeState
    }
    1 {
      ##  set first arc extremity  ##
      msg "Set second extremity with mouse button 1"
      lassign [[cv] coords carcl1] xc yc
      incr ModeState
      
      [cv] create line $xc $yc $x $y \
	-width 1 -fill red \
	-tags {carcl2 ctl}
      
      set dx [expr "$x - $xc"]
      set dy [expr "$y - $yc"]
      set rayon [sqrt [expr "$dx*$dx + $dy*$dy"]]
      
      switch $CurrentMode {
	ArcMode {
	  set id [eval "[cv] create arc \
	         [expr "$xc - $rayon"] [expr "$yc - $rayon"] \
	         [expr "$xc + $rayon"] [expr "$yc + $rayon"] \
	         -style arc \
                 -start [angle $xc $yc $x $y] \
	         -extent 0 \
                 $currentStyle(arc) \
                 -tags {inCreation}"]
	}
	PieMode {
	  set id [eval "[cv] create arc \
	         [expr "$xc - $rayon"] [expr "$yc - $rayon"] \
	         [expr "$xc + $rayon"] [expr "$yc + $rayon"] \
	         -style pieslice \
                 -start [angle $xc $yc $x $y] \
	         -extent 0 \
                 $currentStyle(pieslice) \
                 -tags {inCreation}"]
	}
      }

      global ArcCoords
      set ArcCoords($id) "$rayon $xc $yc $x $y"
    }
    2 {
      ## set second extremity and terminate creation ##
      restoreMsg
      set id [[cv] find withtag inCreation]

      lassign [[cv] coords carcl1] xc yc x1 y1

      [cv] delete carcl1
      [cv] delete carcl2
      
      [cv] itemconfigure $id \
	-extent [expr "[angle $xc $yc $x $y]-[angle $xc $yc $x1 $y1]"]
      
      set ModeState 0
      createEnd_hook
    }
  }
}

proc carcMotion {x y} {
  global ModeState
  
  switch $ModeState {
    0 {}
    1 {
      eval "[cv] coords carcl1 \
        [lrange [[cv] coords carcl1] 0 1] \
        $x $y"
    }
    2 {
      
      set bb [[cv] coords carcl1]
      if {$bb == ""} {
	set ModeState 0
	[cv] delete inCreation
	[cv] delete carcl1
	[cv] delete carcl2
	return
      }
 
      lassign $bb xc yc x1 y1
      
      eval "[cv] coords carcl2  \
            [lrange [[cv] coords carcl2] 0 1] $x $y"
      [cv] itemconfigure inCreation \
	-extent [expr "[angle $xc $yc $x $y]-[angle $xc $yc $x1 $y1]"]
    }
  }
}

