# $Id: picundo.tcl,v 1.11 94/02/06 14:32:49 mangin Exp $

set histList      {}
set histPos   0

##  A la Emacs undo  ##
##  maintain a list of all former states of the canvas  ##
##  (items + coords + config)  ##
##  Clicking on "undo" starts an undo sequence.  ##
##  Each undo call then birngs us back in previous state.  ##
##  Any call to histAdd ends up the undo sequence  ##

proc histAdd {} {
  ####  UNDO DISABLED  ####
  return

  global histList histPos

  set histPos 0
  lvarpush histList [getCurrentState]
}

proc Undo {} {
  ####  UNDO DISABLED  ####
  return

  global histList histPos

  #  No more states to undo => return #
  if {$histPos >= [expr [llength $histList] - 1]} { return }
  
  set cstate [lindex $histList $histPos]
  set newstate [lindex $histList [incr histPos]]

  ##  Switch states ##
  histSwitch $cstate $newstate
  
  ##  push new state on top of histList for redo  ##
  lvarpush histList $cstate
  incr histPos
}

proc histSwitch {st1 st2} {
  ####  UNDO DISABLED  ####
  return

  global histList

  set hids1 [lvarpop st1]
  set hids2 [lvarpop st2]
  set types1 [lvarpop st1]
  set types2 [lvarpop st2]
  set coords1 [lvarpop st1]
  set coords2 [lvarpop st2]
  set configs1 [lvarpop st1]
  set configs2 [lvarpop st2]

  lassign [intersect3 $hids1 $hids2] toDelete toModify toCreate

  #  hids3 = items of state 2 with ids updated according to recreations  #
  set hids3 $hids2
  
  foreach hid $toDelete {
    [cv] delete [lindex $hid 1]
  }

  foreach hid $toCreate {
    set i [lsearch -exact "$hids2" "$hid"]
    set cf [lindex $configs2 $i]
    set options {}
    foreach opt $cf {
      lappend options [lindex $opt 0] [lindex $opt 4]
    }

    set newid [eval "[cv] create [lindex $types2 $i] \
                       [lindex $coords2 $i] \
                       $options"]
    regsub -all -- "$hid" "$histList" "histId $newid" histList
    regsub -all -- "$hid" "$hids3" "histId $newid" hids3
  }

  foreach hid $toModify {
    set i [lsearch -exact "$hids2" "$hid"]
    set id [lindex $hid 1]
    set c2 [lindex $coords2 $i]
    if {$c2 != [lindex $coords1 $i]} {
      eval "[cv] coords $id $c2"
    }

    set cf2 [lindex $configs2 $i]
    if {$cf2 != [lindex $configs1 $i]} {
      set options {}
      foreach opt $cf2 {
	lappend options [lindex $opt 0] [lindex $opt 4]
      }
      eval "[cv] itemconfigure $id $options"
    }
  }

  #  Reset stacking order  #
  foreach hid $hids3 {
    [cv] raise [lindex $hid 1]
  }
}

proc getCurrentState {} {
  ##  A state is a list of 4 elements : the item ids list, ##
  ##  the types list, the coords list, and the configs list  ##

  #  save current tag #
  set currentItems [[cv] find withtag current]
  [cv] dtag all current
  
  set ids [[cv] find withtag all]
  set hids {}
  set types {}
  set coords {}
  set configs {}
  foreach id $ids {
    lappend hids [list histId $id]
    lappend types [[cv] type $id]
    lappend coords [[cv] coords $id]
    lappend configs [[cv] itemconfigure $id]
  }

  #  restore current tag  #
  foreach it $currentItems {
    [cv] addtag current withtag $it
  }

  return [list $hids $types $coords $configs]
}

proc rmCurrentTag {st} {
  
  #  Given a canvas state, removes occurences of the tag "current"  #
  #  from item configs  #

  set cfList {}
  foreach itemcf [lindex $st 3] {
    set cf {}
    foreach spec $itemcf {
      if {[lindex $spec 0] != "-tags"} {
	lappend cf "$spec"
      } else {
	set tags [lindex $spec 4]
	if {[set i [lsearch -exact $tags "current"]] >= 0} {
	  lappend cf "[lrange $spec 0 3] [lreplace $tags $i $i]"
	} else {
	  lappend cf "$spec"
	}
      }
    }
    lappend cfList "$cf"
  }

  return "[lrange $st 0 2] [list $cfList]"
}
  
