static char rcsid[]="$Id: tkCanvTexPos.c,v 1.2 94/02/14 14:53:08 mangin Exp $";

/* Modified by Frank Mangin, 94/01/06,
 *   to implement a dummy item whose only interest
 *   is to generate postscript code that writes the item postscript
 *   absolute position on stdout. Used to generate the \put
 *   coordinates in the auxiliary latex file.

 * 
 * tkCanvTexPos.c
 *
 *	This file implements dline items for canvas widgets.
 *
 * Copyright (c) 1991-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#include <stdio.h>
#include <tkInt.h>
#include "tkCanvas.h"
#include <tkConfig.h>

/*
 * The structure below defines the record for each dline item.
 */

typedef struct TexPosItem  {
    Tk_Item header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Canvas *canvasPtr;	/* Canvas containing item.  Needed for
				 * parsing arrow shapes. */
    double x, y;		/* item's position */
    char *text;			/* Comments to write along with postscript */
} TexPosItem;

/*
 * Prototypes for procedures defined in this file:
 */

static void		ComputeTexPosBbox _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    TexPosItem *TexPosPtr));
static int		ConfigureTexPos _ANSI_ARGS_((
			    Tk_Canvas *canvasPtr, Tk_Item *itemPtr, int argc,
			    char **argv, int flags));
static int		CreateTexPos _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    struct Tk_Item *itemPtr, int argc, char **argv));
static void		DeleteTexPos _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    Tk_Item *itemPtr));
static void		DisplayTexPos _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    Tk_Item *itemPtr, Drawable dst));
static int		TexPosCoords _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    Tk_Item *itemPtr, int argc, char **argv));
static int		TexPosToArea _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    Tk_Item *itemPtr, double *rectPtr));
static double		TexPosToPoint _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    Tk_Item *itemPtr, double *coordPtr));
static int		TexPosToPostscript _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    Tk_Item *itemPtr, Tk_PostscriptInfo *psInfoPtr));
static void		ScaleTexPos _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    Tk_Item *itemPtr, double originX, double originY,
			    double scaleX, double scaleY));
static void		TranslateTexPos _ANSI_ARGS_((Tk_Canvas *canvasPtr,
			    Tk_Item *itemPtr, double deltaX, double deltaY));

/*
 * Information used for parsing configuration specs.  If you change any
 * of the default strings, be sure to change the corresponding default
 * values in CreateTexPos.
 */

static Tk_ConfigSpec configSpecs[] = {
  {TK_CONFIG_STRING, "-text", (char *) NULL, (char *) NULL,
     "", Tk_Offset(TexPosItem, text), 0},
  {TK_CONFIG_CUSTOM, "-tags", (char *) NULL, (char *) NULL,
     (char *) NULL, 0, TK_CONFIG_NULL_OK, &tkCanvasTagsOption},
  {TK_CONFIG_END, (char *) NULL, (char *) NULL, (char *) NULL,
     (char *) NULL, 0, 0}
};

/*
 * The structures below defines the TexPos item type by means
 * of procedures that can be invoked by generic item code.
 */

Tk_ItemType TkTexPosType = {
    "texpos",				/* name */
    sizeof(TexPosItem),			/* itemSize */
    CreateTexPos,				/* createProc */
    configSpecs,			/* configSpecs */
    ConfigureTexPos,			/* configureProc */
    TexPosCoords,				/* coordProc */
    DeleteTexPos,				/* deleteProc */
    DisplayTexPos,			/* displayProc */
    0,					/* alwaysRedraw */
    TexPosToPoint,			/* pointProc */
    TexPosToArea,				/* areaProc */
    TexPosToPostscript,			/* postscriptProc */
    ScaleTexPos,				/* scaleProc */
    TranslateTexPos,			/* translateProc */
    (Tk_ItemIndexProc *) NULL,		/* indexProc */
    (Tk_ItemCursorProc *) NULL,		/* icursorProc */
    (Tk_ItemSelectionProc *) NULL,	/* selectionProc */
    (Tk_ItemInsertProc *) NULL,		/* insertProc */
    (Tk_ItemDCharsProc *) NULL,		/* dTextProc */
    (Tk_ItemType *) NULL		/* nextPtr */
};

/***************************************************************
 ****          Canvas dTexPos item creation                   ****
 ***************************************************************/

void TexPosItemTypeCreate()
{
  Tk_CreateItemType(&TkTexPosType);
}


/*
 *--------------------------------------------------------------
 *
 * CreateTexPos --
 *
 *	This procedure is invoked to create a new TexPos item in
 *	a canvas.
 *
 * Results:
 *	A standard Tcl return value.  If an error occurred in
 *	creating the item, then an error message is left in
 *	canvasPtr->interp->result;  in this case itemPtr is
 *	left uninitialized, so it can be safely freed by the
 *	caller.
 *
 * Side effects:
 *	A new TexPos item is created.
 *
 *--------------------------------------------------------------
 */

static int
CreateTexPos(canvasPtr, itemPtr, argc, argv)
    register Tk_Canvas *canvasPtr;	/* Canvas to hold new item. */
    Tk_Item *itemPtr;			/* Record to hold new item;  header
					 * has been initialized by caller. */
    int argc;				/* Number of arguments in argv. */
    char **argv;			/* Arguments describing TexPos. */
{
  register TexPosItem *TexPosPtr = (TexPosItem *) itemPtr;
  int i;

    if (argc < 2) {
      Tcl_AppendResult(canvasPtr->interp, "wrong # args:  should be \"",
		       Tk_PathName(canvasPtr->tkwin), "\" create ",
		       itemPtr->typePtr->name, " x y",
		       (char *) NULL);
      return TCL_ERROR;
    }

  /*
   * Carry out initialization that is needed to set defaults and to
   * allow proper cleanup after errors during the the remainder of
   * this procedure.
   */
  
  TexPosPtr->canvasPtr = canvasPtr;
  TexPosPtr->x = TexPosPtr->y = 0.0;

  if (TexPosCoords(canvasPtr, itemPtr, 2, argv) != TCL_OK) {
    goto error;
  }

  if (ConfigureTexPos(canvasPtr, itemPtr, argc-2, argv+2, 0) != TCL_OK) {
    return TCL_ERROR;
  }

  ComputeTexPosBbox(canvasPtr, TexPosPtr);
  
  return(TCL_OK);
  
 error:
  DeleteTexPos(canvasPtr, itemPtr);
  return TCL_ERROR;
}

/*
 *--------------------------------------------------------------
 *
 * TexPosCoords --
 *
 *	This procedure is invoked to process the "coords" widget
 *	command on TexPoss.  See the user documentation for details
 *	on what it does.
 *
 * Results:
 *	Returns TCL_OK or TCL_ERROR, and sets canvasPtr->interp->result.
 *
 * Side effects:
 *	The coordinates for the given item may be changed.
 *
 *--------------------------------------------------------------
 */

static int
TexPosCoords(canvasPtr, itemPtr, argc, argv)
    register Tk_Canvas *canvasPtr;	/* Canvas containing item. */
    Tk_Item *itemPtr;			/* Item whose coordinates are to be
					 * read or modified. */
    int argc;				/* Number of coordinates supplied in
					 * argv. */
    char **argv;			/* Array of coordinates: x1, y1,
					 * x2, y2, ... */
{
  register TexPosItem *TexPosPtr = (TexPosItem *) itemPtr;
  char x[TCL_DOUBLE_SPACE], y[TCL_DOUBLE_SPACE];

  if (argc == 0) {
    Tcl_PrintDouble(canvasPtr->interp, TexPosPtr->x, x);
    Tcl_PrintDouble(canvasPtr->interp, TexPosPtr->y, y);
    Tcl_AppendResult(canvasPtr->interp, x, " ", y, (char *) NULL);
  } else if (argc == 2) {
    if ((TkGetCanvasCoord(canvasPtr, argv[0], &TexPosPtr->x)
	 != TCL_OK) ||
	(TkGetCanvasCoord(canvasPtr, argv[1], &TexPosPtr->y)
	 != TCL_OK)) {
      return TCL_ERROR;
    }
  } else {
    sprintf(canvasPtr->interp->result,
            "wrong # coordinates:  expected 0 or 2, got %d",
            argc);
    return TCL_ERROR;
  }

  return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * ConfigureTexPos --
 *
 *	This procedure is invoked to configure various aspects
 *	of a TexPos item such as its background color.
 *
 * Results:
 *	A standard Tcl result code.  If an error occurs, then
 *	an error message is left in canvasPtr->interp->result.
 *
 * Side effects:
 *	Configuration information, such as colors and stipple
 *	patterns, may be set for itemPtr.
 *
 *--------------------------------------------------------------
 */

static int
ConfigureTexPos(canvasPtr, itemPtr, argc, argv, flags)
    Tk_Canvas *canvasPtr;	/* Canvas containing itemPtr. */
    Tk_Item *itemPtr;		/* TexPos item to reconfigure. */
    int argc;			/* Number of elements in argv.  */
    char **argv;		/* Arguments describing things to configure. */
    int flags;			/* Flags to pass to Tk_ConfigureWidget. */
{
  register TexPosItem *TexPosPtr = (TexPosItem *) itemPtr;

  if (Tk_ConfigureWidget(canvasPtr->interp, canvasPtr->tkwin,
			 configSpecs, argc, argv,
			 (char *) TexPosPtr, flags) != TCL_OK) {
    return(TCL_ERROR);
  }
  return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * DeleteTexPos --
 *
 *	This procedure is called to clean up the data structure
 *	associated with a TexPos item.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Resources associated with itemPtr are released.
 *
 *--------------------------------------------------------------
 */

static void
DeleteTexPos(canvasPtr, itemPtr)
    Tk_Canvas *canvasPtr;		/* Info about overall canvas widget. */
    Tk_Item *itemPtr;			/* Item that is being deleted. */
{
  return;
}

/*
 *--------------------------------------------------------------
 *
 * ComputeTexPosBbox --
 *
 *	This procedure is invoked to compute the bounding box of
 *	all the pixels that may be drawn as part of a TexPos.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The fields x1, y1, x2, and y2 are updated in the header
 *	for itemPtr.
 *
 *--------------------------------------------------------------
 */

static void
ComputeTexPosBbox(canvasPtr, TexPosPtr)
    register Tk_Canvas *canvasPtr;	/* Canvas that contains item. */
    TexPosItem *TexPosPtr;			/* Item whose bbos is to be
					 * recomputed. */
{
  TexPosPtr->header.x1 =
    TexPosPtr->header.x2 = (int)(0.5 + TexPosPtr->x);
  TexPosPtr->header.y1 =
    TexPosPtr->header.y2 = (int)(0.5 + TexPosPtr->y);
}

/*
 *--------------------------------------------------------------
 *
 * DisplayTexPos --
 *
 *	This procedure is invoked to draw a TexPos item in a given
 *	drawable.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	ItemPtr is drawn in drawable using the transformation
 *	information in canvasPtr.
 *
 *--------------------------------------------------------------
 */

static void
DisplayTexPos(canvasPtr, itemPtr, drawable)
    register Tk_Canvas *canvasPtr;	/* Canvas that contains item. */
    Tk_Item *itemPtr;			/* Item to be displayed. */
    Drawable drawable;			/* Pixmap or window in which to draw
					 * item. */
{
  return;
}

/*
 *--------------------------------------------------------------
 *
 * TexPosToPoint --
 *
 *	Computes the distance from a given point to a given
 *	TexPos, in canvas units.
 *
 * Results:
 *	The return value is 0 if the point whose x and y coordinates
 *	are pointPtr[0] and pointPtr[1] is inside the TexPos.  If the
 *	point isn't inside the TexPos then the return value is the
 *	distance from the point to the TexPos.
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

	/* ARGSUSED */
static double
TexPosToPoint(canvasPtr, itemPtr, pointPtr)
    Tk_Canvas *canvasPtr;	/* Canvas containing item. */
    Tk_Item *itemPtr;		/* Item to check against point. */
    double *pointPtr;		/* Pointer to x and y coordinates. */
{
  return(0.0);
}

/*
 *--------------------------------------------------------------
 *
 * TexPosToArea --
 *
 *	This procedure is called to determine whether an item
 *	lies entirely inside, entirely outside, or overlapping
 *	a given rectangular area.
 *
 * Results:
 *	-1 is returned if the item is entirely outside the
 *	area, 0 if it overlaps, and 1 if it is entirely
 *	inside the given area.
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */

	/* ARGSUSED */
static int
TexPosToArea(canvasPtr, itemPtr, rectPtr)
    Tk_Canvas *canvasPtr;	/* Canvas containing item. */
    Tk_Item *itemPtr;		/* Item to check against TexPos. */
    double *rectPtr;
{
  return(0);
}

/*
 *--------------------------------------------------------------
 *
 * ScaleTexPos --
 *
 *	This procedure is invoked to rescale a TexPos item.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The TexPos referred to by itemPtr is rescaled so that the
 *	following transformation is applied to all point
 *	coordinates:
 *		x' = originX + scaleX*(x-originX)
 *		y' = originY + scaleY*(y-originY)
 *
 *--------------------------------------------------------------
 */

static void
ScaleTexPos(canvasPtr, itemPtr, originX, originY, scaleX, scaleY)
    Tk_Canvas *canvasPtr;		/* Canvas containing TexPos. */
    Tk_Item *itemPtr;			/* TexPos to be scaled. */
    double originX, originY;		/* Origin about which to scale rect. */
    double scaleX;			/* Amount to scale in X direction. */
    double scaleY;			/* Amount to scale in Y direction. */
{
  return;
}

/*
 *--------------------------------------------------------------
 *
 * TranslateTexPos --
 *
 *	This procedure is called to move a TexPos by a given amount.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The position of the TexPos is offset by (xDelta, yDelta), and
 *	the bounding box is updated in the generic part of the item
 *	structure.
 *
 *--------------------------------------------------------------
 */

static void
TranslateTexPos(canvasPtr, itemPtr, deltaX, deltaY)
    Tk_Canvas *canvasPtr;		/* Canvas containing item. */
    Tk_Item *itemPtr;			/* Item that is being moved. */
    double deltaX, deltaY;		/* Amount by which item is to be
					 * moved. */
{
  return;
}

/*
 *--------------------------------------------------------------
 *
 * TexPosToPostscript --
 *
 *      This procedure is called to generate Postscript for
 *     texpos items.
 *
 * Results:
 *      The return value is a standard Tcl result.  If an error
 *      occurs in generating Postscript then an error message is
 *      left in canvasPtr->interp->result, replacing whatever used
 *      to be there.  If no error occurs, then Postscript for the
 *      item is appended to the result.
 *
 * Side effects:
 *      None.
 *
 *--------------------------------------------------------------
 */

static int
TexPosToPostscript(canvasPtr, itemPtr, psInfoPtr)
    Tk_Canvas *canvasPtr;		/* Information about overall canvas. */
    Tk_Item *itemPtr;			/* Item for which Postscript is
					 * wanted. */
    Tk_PostscriptInfo *psInfoPtr;	/* Information about the Postscript;
					 * must be passed back to Postscript
					 * utility procedures. */
{
  register TexPosItem *TexPosPtr = (TexPosItem *) itemPtr;
  char buffer[256];

  sprintf(buffer, "%.15g %.15g transform\n",
	  TexPosPtr->x, TkCanvPsY(psInfoPtr, TexPosPtr->y));

  Tcl_AppendResult(canvasPtr->interp,
		   "(", TexPosPtr->text, " ) print\n",
		   buffer,
		   "exch 32 string cvs print ( ) print 32 string cvs print\n",
		   "(\n) print\n",
		   (char *)0);
  return(TCL_OK);
}
