#
# displays a MIME message using Tcl
#
# usage: swish -messaging -messagebody fileName -file showmime.tcl
#

if {$argc != 0} {
    puts    stdout	"usage: swish -messaging -messagebody fileName -file showmime.tcl"
    exit    1
}

catch { source "~/.safetcl.conf" }

if {![catch { set msgName $env(MSGNAME) }]} {
    wm	title	 .	"showmime $msgName"
    wm	iconname .	$msgName
}

proc	main	{w} {
    global	bodyParts

    frame	$w.frame	-borderwidth 10

    pack append	$w.frame	[frame $w.frame.top \
					-borderwidth 1] \
				    {top fillx}

    set		i	[string length "part"]
    set		j	[string length "type/subtype"]
    set		k	[string length "size"]
    set		l	[string length "description"]

    foreach	part	[set bodyParts [SafeTcl_getparts]] {
	if {[set m [string length [set partno [lindex $part 0]]]] > $i} {
	    set	i	$m
	}
	if {[set m [string length [lindex $part 1]]] > $j} {
	    set	j	$m
	}
	if {[set m [string length [SafeTcl_getsize $partno]]] > $k} {
	    set	k	$m
	}
	if {[set m [string length [lindex $part 2]]] > $l} {
	    set	l	$m
	}
    }
    foreach	part	$bodyParts {
	lappend	contents \
			[format "%-*.*s %-*.*s  %*.*s   %s" \
			    $i $i [set partno [lindex $part 0]] \
			    $j $j [lindex $part 1] \
			    $k $k [SafeTcl_getsize $partno] \
				  [lindex $part 2]]
    }
    set		ncline		[llength $contents]

    set		hsep	""
    set		headers	""
    foreach	field	[list "Date" "Subject" "Comments" "From" "To" "cc" \
			    "Resent-From" "Resent-Note"] {
	if {[set value [SafeTcl_getheader $field]] == ""} {
	    continue
	}

	case $field {
	    Date		{
		catch { set value [SafeTcl_getdateprop $value "proper"] }
	    }

	    {From To cc Resent-From} {
		if {![catch { set addrs [SafeTcl_getaddrs $value] }]} {
		    set		asep	""
		    set		names	""
		    foreach	addr	$addrs {
			if {[catch { set friendly [SafeTcl_getaddrprop \
						       $addr "friendly"] }]} {
			    set	friendly	$addr
			}
			append	names	$asep $friendly
			set	asep	",\n          "
		    }
		    set	value	$names
		}
	    }
	}
	append	field	":"
	append	headers	[format "%s%-9.9s %s" $hsep $field $value]
	set	hsep	"\n"
    }
    set		hlines		[split $headers "\n"]
    set		nhline		[llength $hlines]
    if {[set x [expr $i+$j+$k+$l+6]] < 60} {
	set	x	60
    }
    foreach	header		$hlines {
	if {[set l [string length $header]] > $x} {
	    set	x	$l
	}
    }

    set		multiline	[expr ($nhline>12)||($ncline>16)]

    if {$nhline>0} {
	if {$multiline} {
	    pack append $w.frame.top \
				[scrollbar $w.frame.top.yscroll \
					-command "$w.frame.top.text yview" \
					-orient vertical \
					-relief sunken] \
				    {right filly}
	    set	y	12
	    if {$y > $nhline}	{ set y $nhline }
	} else {
	    set	y	$nhline
	}
	pack append $w.frame.top \
				[text $w.frame.top.text \
					-borderwidth 2 \
					-height $y \
					-relief sunken \
					-setgrid true \
					-width $x] \
				    {left fill}
	if {$multiline} {
	    $w.frame.top.text configure \
				-yscrollcommand "$w.frame.top.yscroll set"
	}
	catch { $w.frame.top.text configure -background khaki }

	$w.frame.top.text insert end $headers
	$w.frame.top.text yview 0
	$w.frame.top.text configure -state disabled
    }

    set		lbltxt		[format "%-*.*s" $x $x \
				    [format "%-*.*s %-*.*s  %-*.*s   %s" \
					$i $i "part" \
					$j $j "type/subtype" \
					$k $k "size" \
					      "description"]]
    if {$multiline} {
	append	lbltxt	"   "
    }
    pack append	$w.frame	[label $w.frame.label \
					-font -*courier-medium-r-normal-*-120-* \
					-relief sunken \
					-text $lbltxt \
					-width $x] \
				    {top fillx}
    catch { $w.frame.label configure -background lightskyblue }
    if {$multiline} {
	pack append $w.frame	[scrollbar $w.frame.yscroll \
					-command "$w.frame.list yview" \
					-orient vertical \
					-relief sunken] \
				    {right filly}
	set	y	16
	if {$y > $ncline}	{ set y $ncline }
    } else {
	set	y	$ncline
    }
    pack append $w.frame	[listbox $w.frame.list \
					-font -*courier-medium-r-normal-*-120-* \
					-geometry ${x}x$y \
					-relief sunken] \
			    {top expand}
    if {$multiline} {
	$w.frame.list configure	-yscroll "$w.frame.yscroll set"
    }
    catch { $w.frame.list configure -background lightskyblue }

    foreach	part	$contents {
	$w.frame.list \
		insert	end	$part
    }

    bind	$w.frame.list	<1>	{%W select from [%W nearest %y]}
    bind	$w.frame.list	<B1-Motion>\
					{%W select to [%W nearest %y]}
    bind	$w.frame.list	<Shift-1> \
					{%W select adjust [%W nearest %y]}
    bind	$w.frame.list	<Shift-B1-Motion> \
					{%W select to [%W nearest %y]}
    bind	$w.frame.list	<Double-1> \
					"ShowCommand $w.frame.list"

    frame	$w.bot		-borderwidth 1
    pack append	$w.bot		[button $w.bot.button \
					-command "destroy ." \
					-text Dismiss] \
				    {top padx 5 pady 5 expand}

    pack append	.		$w.frame \
				    {top expand filly} \
				$w.bot \
				    {bottom fill}
}

proc	SafeTcl_getsize	{partno} {
    if {([string match "*.1" $partno])
	    && ([SafeTcl_getbodyprop \
		     [string range $partno 0 \
		          [expr [string length $partno]-3]] \
		     "type"] == "message/external-body")} {
	return	""
    }

    set size [SafeTcl_getbodyprop $partno "size"]
    if {[SafeTcl_getbodyprop $partno "encoding"] == "base64"} {
	set	size	[expr ($size*3)>>2]
    }
    for {set i 0} {$size>9999} {set size [expr $size>>10]} {
	incr	i
    }
    case $i {
	{0 1 2 3 4}	{ return [format "%s%s" $size \
				      [lindex [list "" "K" "M" "G" "T"] $i]] }

	default		{ return "huge" }
    }
}


proc	ShowCommand	{w} {
    global	errorCode
    global	bodyParts

    foreach	i	[$w curselection] {
 	if {[catch { set part [SafeTcl_getbodyprop \
			           [set partno \
				        [lindex [lindex $bodyParts $i] 0]] \
				   "all"] } result]} {
	    case $result {
		{"mail-server access-type"} {
		    set partno [string range $partno 0 \
				    [expr [string length $partno]-3]]
		    set	server	""
		    set	subject	""
		    set	body	""
		    foreach param [SafeTcl_getbodyprop $partno "parms"] {
			case [lindex $param 0] {
			    server	{ set server [lindex $param 1] }
			    body	{ set body [lindex $param 1] }
			    subject	{ set subject [lindex $param 1] }
			}
		    }
		    if {($server == "") || (($body == "")&&($subject == ""))} {
			puts stdout "invalid mail-server access-type"
			break
		    }
		    if {$subject == ""} {
			set	subject	"mime-server request"
		    }
		    set	result	""
		    while {$result == ""} {
			puts -nonewline stdout \
			    "To:      $server\nSubject: $subject\n\n$body\nsend it? (y)es, (n)o: "
			set result	[string tolower [gets stdin]]
			if {$result == ""} {
			    continue
			}
			if {[string range $result 0 0] == "y"} {
			    catch { MIME_sendmessage -to $server \
				        -subject $subject \
			                -body [SafeTcl_makebody "text/plain" \
				               -parameter "charset=us-ascii" \
					       $body] } answer
			    if {$answer == ""} {
				set	answer	"request sent"
			    }
			    puts stdout "$answer"
			}
		    }
		}

		default {
		    puts stdout "unable to display, $errorCode: $result"
		}
	    }
	    continue
	}
	SafeTcl_displaybody -background $part

    }
    $w select clear
}

main ""
