/*
 *  Copyright (C) 1993 Michael Tiller
 *
 *  Permission is hereby granted by the author to use, copy, modify,
 *  and distribute this code for any purpose provided this copyright
 *  notice is included in all copies.  This code is provided "as is"
 *  without any expressed or implied warranty.
 *
 */

%{
#include <math.h>
#include "expr.h"

#define YYSTYPE ExprPtr
#define	YYDEBUG	1

/* This is how the result of the parsing is returned */
ExprPtr	expr_result;
%}

/* BISON Declarations */
%token NUM
%token ID
%token ADD SUB MULT DIV EXP LP RP
%left ADD SUB
%left MULT DIV
%left NEG     /* negation--unary minus */
%right EXP

/* Grammar follows */
%%
line	: exp
		{
			expr_result = $1;
		}
;

exp	: NUM
	{
		$$ = $1;
	}
	| ID
	{
		$$ = $1;
	}
	| exp ADD exp
	{
		$$ = MakeAdd($1,$3);
	}
	| exp SUB exp
	{
		$$ = MakeSub($1,$3);
	}
	| exp MULT exp
	{
		$$ = MakeMult($1,$3);
	}
	| exp DIV exp
	{
		$$ = MakeDiv($1,$3);
	}
	| SUB exp %prec NEG
	{
		$$ = MakeNeg($2);
	}
	| exp EXP exp
	{
		$$ = MakeExp($1,$3);
	}
	| LP exp RP
	{
		$$ = MakeSubExpr($2);
	}
;
%%
