##
## This is the initialization file for the tkined network editor.
##
## Copyright (c) 1993, 1994
##
## J. Schoenwaelder
## TU Braunschweig, Germany
## Institute for Operating Systems and Computer Networks
##
## Permission to use, copy, modify, and distribute this
## software and its documentation for any purpose and without
## fee is hereby granted, provided that this copyright
## notice appears in all copies.  The University of Braunschweig
## makes no representations about the suitability of this
## software for any purpose.  It is provided "as is" without
## express or implied warranty.
##

##
## Add some nice key bindings to the entry widgets. I would like
## some more but I do not know how to move the icursor...
## Perhaps someone can help? I know of the emacs key bindings
## postet in comp.lang.tcl but I would like small ones.
## (Do we really need prefixes in entry widgets?)
##

# remove tk's default binding to get good old X11 paste working
# use button three to do the motion stuff

bind Entry <2> {%W insert insert [selection get]; tk_entrySeeCaret %W}
bind Entry <B2-Motion> ""
bind Entry <3> {%W scan mark %x}
bind Entry <B3-Motion> {%W scan dragto %x}

option add Tkined*exportSelection true startupFile

##
## Set the colors to grey. You might change it.
##

if {[tk colormodel .] == "color"} {
    option add Tkined*background "#EAEAEA" startupFile
    option add Tkined*activeBackground "#DADADA" startupFile
    option add Tkined*selectBackground "#CACACA" startupFile
    option add Tkined*foreground "#000000" startupFile
    option add Tkined*Scrollbar*foreground "#AAAAAA" startupFile
    option add Tkined*Scrollbar*activeForeground "#9A9A9A" startupFile
    option add Tkined*Scrollbar*selectForeground "#8A8A8A" startupFile
    option add Tkined*Scale*foreground "#AAAAAA" startupFile
    option add Tkined*Scale*activeForeground "#9A9A9A" startupFile
    option add Tkined*Scale*selectForeground "#8A8A8A" startupFile
    option add Tkined*Scale*selectBackground "#8A8A8A" startupFile
    option add Tkined*Scale*sliderForeground "#AAAAAA" startupFile

    option add Tkined*plotBackground "#FFFFFF" startupFile
    option add Tkined*legendBackground "#EAEAEA" startupFile
}

##
## I dont like the fat font tk uses per default. So here is good
## old fixed font.
##

option add Tkined*Entry.font       fixed startupFile
option add Tkined*Text.font        fixed startupFile
option add Tkined*Message.font     fixed startupFile
option add Tkined*Listbox.font     fixed startupFile
option add Tkined*Radiobutton.font fixed startupFile
option add Tkined*Checkbutton.font fixed startupFile

option add Tkined*plotBorderWidth 1 startupFile
option add Tkined*plotRelief sunken startupFile
option add Tkined*legendBorderWidth 0 startupFile
option add Tkined*lineElemScale 0.5 startupFile
option add Tkined*lineElemLinewidth 1 startupFile
option add Tkined*lineElemBackground white startupFile
option add Tkined*lineElemActiveBackground black startupFile
# option add Tkined*halo 4 startupFile
option add Tkined*xTitle "" startupFile
option add Tkined*yTitle "" startupFile
option add Tkined*xFont fixed startupFile
option add Tkined*yFont fixed startupFile
option add Tkined*elemForeground black
option add Tkined*elemBackground white
    
##
## Read the site specific initialization file.
##

if [file exists $tkined_lib/site/init.tcl] {
    source $tkined_lib/site/init.tcl
}
