/* 
 * This file contains common declarations for "tkined".
 *
 * Copyright (c) 1993, 1994
 *
 * J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <tk.h>
#include <tkInt.h>
#include <tkCanvas.h>

#define TKINED_VERSION "1.2.0"

/*
 * The external declaration of the canvas extensions stripchart 
 * and barchart. The definition of Tk_CreateItemType belongs to
 * tkCanvas.h, but it is missing (at least in tk3.6).
 */

extern void Tk_CreateItemType _ANSI_ARGS_((Tk_ItemType *typePtr));

extern Tk_ItemType TkStripchartType;
extern Tk_ItemType TkBarchartType;

/*
 * This structure is used to hold all information belonging to an
 * editor window. Every object shown on the editor canvas keeps a 
 * pointer to an editor object.
 */

typedef struct {
    char *id;               /* The unique identifier for an editor object   */
    char *toplevel;         /* The toplevel window of the editor object     */

    char *dirname;          /* The current directory name                   */
    char *filename;         /* The filename for the current map             */
    char *psfilename;       /* The PostScript filename for the current map  */

    char *pagesize;         /* The size of the current map                  */
    int width, height;      /* The width and height in canvas pixels        */
    int  landscape;         /* The orientation (landscape or portrait)      */

    int  color;             /* The indicating the colormodel of the editor  */

    int  traceCount;        /* The number of traces for this editor         */

    Tcl_HashTable attr;     /* A hash table used to store editor attributes */
} tkined_editor;

/*
 * These are the constructor and destructor functions for 
 * editor objects.
 */

int create_editor  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
				int argc, char **argv));
void delete_editor _ANSI_ARGS_((ClientData clientData));

/*
 * The methods that can be invoked for an tkined editor object.
 */

int e_id          _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));
int e_toplevel    _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));
int e_graph       _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));
int e_retrieve    _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));
int e_selection   _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));

int e_dirname     _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));
int e_filename    _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));
int e_psfilename  _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));
int e_pagesize    _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));
int e_orientation _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));

int e_attribute   _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));

int e_cut         _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));
int e_copy        _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));
int e_paste       _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));

int e_new         _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));
int e_defaults    _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));
int e_load        _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));
int e_save        _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp, 
			       int argc, char **argv));
int e_delete      _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));
int e_quit        _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));
int e_postscript  _ANSI_ARGS_((tkined_editor *editor, Tcl_Interp *interp,
			       int argc, char **argv));

/*
 * The following structure is used to represent objects. I decided
 * to uses a flat structure since most tkined objects are very similar.
 */

typedef struct {
    unsigned type;      /* Type of the object. See below for object types    */
    char *id;           /* The unique identifier for this object             */
    char *name;         /* The name of the object (if any)                   */
    char *address;      /* The address of the object (if any)                */
    unsigned oid;       /* The external object identifier (if any)           */
    double x, y;        /* The position of the object (if any)               */
    char *icon;         /* The icon of the object (if any)                   */
    char *font;         /* The font of the object (if any)                   */
    char *color;        /* The color of the object (if any)                  */
    char *label;        /* The label of the object (if any)                  */
    char *text;         /* The text of a label or a text object              */
    char *canvas;       /* The widget name of the canvas we belong to        */
    char *items;        /* The item on the canvas that belong to this object */
    char *parent;       /* The parent group id of an object                  */
    char *size;         /* The size occupied by an object                    */
    char *member;       /* The elements of a group object                    */
    char *links;        /* The list of links of the object (if any)          */
    char *src;          /* The first object connected by a link object       */
    char *dst;          /* The second object connected by a link object      */
    char *action;       /* The action bound to this object                   */
    int queue;          /* The queue as reported by the interpreter          */
    int xv[2];          /* Socket pair of interpreter objects (read / write) */
    int pid;            /* The pid of this process                           */
    Tcl_DString buffer; /* The command buffer used by an interpreter         */
    int done:1;         /* Flag indicating if the Buffer is empty            */
    int trace:1;        /* Flag indicating if the interpreter needs a trace  */
    int selected:1;     /* Not zero if object currently selected             */
    int collapsed:1;    /* Not zero if group object currently collapsed      */
    int loaded:1;       /* Not zero if object was read from a file           */
    double scale;       /* The scaling factor for a strip- or barchart       */
    int flash;          /* The number of seconds the objects flashes         */
    int allocValues;    /* Number of allocated doubles to hold values        */
    int numValues;	/* The number of values stored in valuePtr	     */
    double *valuePtr;	/* Dynamically allocated memory for XY values        */
    tkined_editor *editor;  /* The pointer to the editor object we belong to */
    Tcl_HashTable attr;     /* A hash table used to store attributes         */
} tkined_object;

/*
 * Legal values for the type field of a TKINED_object. See tkined.1
 * for more details on tkined objects.
 */

#define TKINED_NONE         0x0000
#define TKINED_NODE         0x0001
#define TKINED_GROUP        0x0002
#define TKINED_NETWORK      0x0004
#define TKINED_LINK         0x0008
#define TKINED_TEXT         0x0010
#define TKINED_IMAGE        0x0020
#define TKINED_INTERPRETER  0x0040
#define TKINED_MENU         0x0080
#define TKINED_LOG          0x0100
#define TKINED_REFERENCE    0x0200
#define TKINED_STRIPCHART   0x0400
#define TKINED_BARCHART     0x0800
#define TKINED_GRAPH	    0x1000
#define TKINED_ALL          0xffff

/*
 * These are the constructor and destructor functions for 
 * tkined objects. dump_object() returns a string that can
 * be used to reconstruct an object.
 */

int create_object  _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
				int argc, char **argv));
void delete_object _ANSI_ARGS_((ClientData clientData));

void dump_object   _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object));

/*
 * Declaration of all functions that implement methods for tkined
 * objects. See the dispatch table in objects.c for more information
 * about which method can be executed for a given object type.
 */

int m_create           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
                                    int argc, char **argv));
int m_dump             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
                                    int argc, char **argv));
int m_retrieve         _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_delete           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));

int m_id               _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_type             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_parent           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_name             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_canvas           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_editor           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_items            _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_address          _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_oid              _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_action           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_select           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_unselect         _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_selected         _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_icon             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
		 		    int argc, char **argv));
int m_label            _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_font             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_color            _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_move             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_raise            _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_lower            _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_size             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_src              _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_dst              _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_text             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_append           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_hyperlink        _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_clear            _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_scale            _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_values           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_jump             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_member           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_collapse         _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_expand           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_collapsed        _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_ungroup          _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_links            _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_postscript       _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_points           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_network_labelxy  _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_interpreter      _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_send             _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_editor           _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_attribute        _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));
int m_flash            _ANSI_ARGS_((Tcl_Interp *interp, tkined_object *object,
				    int argc, char **argv));

/*
 * More utility functions.
 */

extern int Tkined_Init      _ANSI_ARGS_((Tcl_Interp *interp));

extern void receive         _ANSI_ARGS_((ClientData clientData, int mask));
extern int  ined            _ANSI_ARGS_((ClientData clientData,
					 Tcl_Interp *interp,
					 int argc, char **argv));

extern void flash           _ANSI_ARGS_((Tcl_Interp *interp,
					 tkined_object *object));

extern char *findfile       _ANSI_ARGS_((char *name));
extern char *type_to_string _ANSI_ARGS_((int type));
extern int string_to_type   _ANSI_ARGS_((char *str));

/*
 * Delete or append an item from/to a list stored as a tcl string list.
 */

extern void ldelete _ANSI_ARGS_((Tcl_Interp *interp, char *slist, char *item));
extern void lappend _ANSI_ARGS_((char **slist, char *item));

/*
 * The trace mechanism is implemented by a function that is called
 * whenever a trace relevant event happens. The arguments point to
 * the editor needed to handle the trace and to the object that caused
 * the trace. The command gets appended with the strings stored in argv.
 *
 * The function notrace() is just a shorthand to invoke methods that
 * dont get traced. For example, moving a group will call the move
 * method for all group members, but this is internal and should not
 * be traced. Therefore we use the notrace function to invoke further
 * moves.
 */

extern void trace _ANSI_ARGS_((tkined_editor *editor, tkined_object *object,
			       char *cmd, int argc, char **argv, 
			       char *result));

extern int notrace _ANSI_ARGS_((int (*method)(), Tcl_Interp *interp, 
				tkined_object *object, int argc, char **argv));

/*
 * The clipboard contains a global buffer of ined commands that
 * is used to implement cut&paste and load&save commands.
 */

extern Tcl_DString clip;

/*
 * Our hashtable that maps object ids to the object structure.
 */

extern Tcl_HashTable ht_object;
extern tkined_object* id_to_object _ANSI_ARGS_((char *str));

/*
 * This variable shows if we run in debug mode. It corresponds to
 * the tcl variable tkined_debug which contains a boolean to
 * indicate debug mode.
 */

extern int debug;

/*
 * Copy a string from b to a. This macro makes sure that the copy 
 * operation is only done when a and b are not the same string.
 */

#define STRCOPY(A,B) if (A != B) { free (A); A = xstrdup(B); }

/*
 * Here comes some portability stuff. There is no strdup in the
 * ultrix C library. So we fake one. And we like to use a somewhat 
 * fail-safe version of malloc and realloc.
 */

#ifdef DBMALLOC
#include <dbmalloc.h>
#define xmalloc  malloc
#define xrealloc realloc
#define xstrdup  strdup
#else
extern char *xstrdup _ANSI_ARGS_((char*));
extern char *xmalloc _ANSI_ARGS_((unsigned));
extern char *xrealloc _ANSI_ARGS_((char*, unsigned));
#endif

/*
 * A replacement for read() and write() for systems with broken 
 * read() and write() semantics.
 */

extern int xwrite _ANSI_ARGS_((int fd, char *buf, int len));
extern int xread  _ANSI_ARGS_((int fd, char *buf, int len));

/*
 * A strdup that replaces all newlines with "\n" sequences.
 */

extern char *xstrdupnn _ANSI_ARGS_((char*));

#ifdef NCCICON
extern void ncc_bitmap _ANSI_ARGS_((Tcl_Interp *interp));
#endif

/*
 * A general purpose sprintf buffer of 1024 bytes. Please use it
 * when you are absolutely sure 1024 bytes are enough. The function 
 * buffer_size() may be called to increase the buffer in case one 
 * needs more space. It will never shrink below 1024 bytes.
 */

extern char *buffer;
extern void buffersize _ANSI_ARGS_((int size));
