# editor.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script takes care of the functions in the texteditor
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
#### proc clearedit ####
# Clears the text, in which the cursor stand
#----------------------------------------------------------------------------
proc cleartextbody {} {
global bg1 bg2 actbg window
set window [focus]
set temp [split [focus] .]
.butt.label configure -text "Clearing everything in the current textbody..."\
	-foreground #3d55ff
if {[lindex $temp 2]=="text" } {
  toplevel .clear
  label .clear.label -text "Really want to clear?" -background $bg1 \
	-foreground red  -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" \
	-relief ridge -borderwidth 2
  pack .clear.label -fill x
  frame .clear.f1 -background $bg1
  pack .clear.f1 -fill x
  button .clear.f1.b1 -text Yes -width 10 -command "$window delete 1.0 end; \
	.butt.label configure -text \"Clearing everything in the current \
	textbody...done\" -foreground #000000; destroy .clear" -background \
	$bg1 -activebackground $actbg
  button .clear.f1.b2 -text Cancel -width 10 -command {destroy .clear; \
	.butt.label configure -text "Clearing everything in the current \
	textbody...Cancelled" -foreground #000000} -background $bg1 \
	-activebackground $actbg
  pack .clear.f1.b1 -side left
  pack .clear.f1.b2  -side right
  grab .clear
  } else {
  .butt.label configure -text "Clearing everything in the current textbody... \
	Cancelled " -foreground #000000
  }
}

#----------------------------------------------------------------------------
#### proc delete ####
# delete a selected text with the startpoint insert and the endpoint
#----------------------------------------------------------------------------
proc delete {} {
catch {[selection own] delete sel.first sel.last}
.butt.label configure -text "Deleting the selected text...done" \
	-foreground #000000
}

#----------------------------------------------------------------------------
#### proc cut ####
# cut a selected text with the startpoint insert and the endpoint
#----------------------------------------------------------------------------
proc cut {} {
global buffer
catch {
  set buffer [selection get]
  [selection own] delete sel.first sel.last
}
.butt.label configure -text "Cutting the selected text...done" \
        -foreground #000000
}

#----------------------------------------------------------------------------
#### proc copy ####
# copy a selected text
#----------------------------------------------------------------------------
proc copy {} {
global buffer
catch {set buffer [selection get]}
.butt.label configure -text "Copying the selected text...done" \
        -foreground #000000
}

#----------------------------------------------------------------------------
#### proc paste ####
# paste a selected text at the index
#----------------------------------------------------------------------------
proc paste {} {
global buffer
[focus] insert insert $buffer
.butt.label configure -text "Pasting text...done" -foreground #000000
}

#----------------------------------------------------------------------------
#### proc gotoline ####
#----------------------------------------------------------------------------
proc movecursor {window lineno} {
destroy .gotoline
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
  $window mark set insert $lineno.0
  $window yview -pickplace insert
  focus $window
.butt.label configure -text "Goto line $lineno...done" -foreground #000000
}
}

proc gotoline {} {

global bg1 bg2 actbg
global window
set window [focus]
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
.butt.label configure -text "Goto line..." -foreground #3d55ff
toplevel .gotoline
wm title .gotoline "Go to line"
wm iconname .gotoline "Go to"
label .gotoline.label -foreground red -background $bg1 -text "Go to line" \
	 -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*"
pack .gotoline.label -side top -fill x
frame .gotoline.f0 -background $bg2
pack .gotoline.f0 -fill both
label .gotoline.f0.l -width 14 -text "Line number :" -background $bg1 \
        -anchor w
entry .gotoline.f0.e -width 30  -background $bg2 \
        -textvariable lineno -relief sunken
set insertindex [split [[focus] index insert] {.}]
set lineno [lindex $insertindex 0]
.gotoline.f0.e delete 0 end
.gotoline.f0.e insert insert $lineno
pack .gotoline.f0.l -side left -anchor w
pack .gotoline.f0.e -side left
#
# Button actions
#
frame .gotoline.f1 -background $bg1
pack .gotoline.f1 -fill both
button .gotoline.f1.ok -text Ok -command {movecursor $window $lineno}\
	-background $bg1 -activebackground $actbg
button .gotoline.f1.cancel -text Cancel -command "destroy .gotoline; \
	.butt.label configure -text \"Goto line...Cancelled\" -foreground \
	#000000" -background $bg1 -activebackground $actbg

pack .gotoline.f1.ok .gotoline.f1.cancel -side left -expand yes -pady 5
focus .gotoline.f0.e
bind .gotoline.f0.e <Return> {movecursor $window $lineno} 
grab .gotoline
}
}

#----------------------------------------------------------------------------
#### proc selectall
# selects alll the text in the current textbody
#----------------------------------------------------------------------------
proc selectall {} {
set temp [split [focus] .]
if {[lindex $temp 2]=="text" } {
  [focus] tag add sel 1.0 end
.butt.label configure -text "Selecting all text in textbody...done" \
	-foreground #000000
}
}

#----------------------------------------------------------------------------
#### proc resizeXX
# Resizes the current textbody
#----------------------------------------------------------------------------
proc resizedefault {} {
global bheight
set window [focus]
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
    $window configure -height $bheight 
.butt.label configure -text "Resizing the textbody to $bheight lines...done" \
        -foreground #000000
}
}

proc resize5 {} {
set window [focus]
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
    $window configure -height 5
.butt.label configure -text "Resizing the textbody to 5 lines...done" \
        -foreground #000000
}
}

proc resize10 {} {
set window [focus]
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
    $window configure -height 10
.butt.label configure -text "Resizing the textbody to 10 lines...done" \
        -foreground #000000
}
}

proc resize20 {} {
set window [focus]
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
    $window configure -height 20
.butt.label configure -text "Resizing the textbody to 20 lines...done" \
        -foreground #000000
}
}

proc resize40 {} {
set window [focus]
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
    $window configure -height 40
.butt.label configure -text "Resizing the textbody to 40 lines...done" \
        -foreground #000000
}
}

