# messagepart.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script takes care of the cut, paste and undo cut of a messagepart.
#----------------------------------------------------------------------------


#----------------------------------------------------------------------------
#### proc cutpart ####
#----------------------------------------------------------------------------
proc cutpart {number} {
global sumofwin
global widgetname
global description
global contenttype
global body
global currentwidgetnumber
global cutmessage

if { $number>0 && $number<=$sumofwin } {
  set cutmessage(contenttype) $contenttype($number)
  set cutmessage(body) $body($number)
  set cutmessage(description) $description($number)
  set cutmessage(cut) "true"
  set cutmessage(position) $number

  set frame [split $widgetname($number) .]
  set cutmessage(frame) [lindex $frame 1]
  if {[lindex $frame 2]=="text" } {
    set cutmessage(text) [$widgetname($number) get 1.0 end]
  } else {
    set cutmessage(text) ""
  }
  set frame .[lindex $frame 1]
  destroy $frame

  for {set i $number} {$i < $sumofwin } {incr i 1} {
    set widgetname($i)  $widgetname([expr $i+1])
    set contenttype($i) $contenttype([expr $i+1])
    set body($i) $body([expr $i+1])
    set description($i) $description([expr $i+1])
    }
  ### update the new array
  for {set i $number} {$i < $sumofwin } {incr i 1} {
    set currentwidgetnumber($widgetname($i)) $i
    }
  set sumofwin [expr $sumofwin -1]
  } 
.butt.label configure -text "Cutting mesagepart...done" -foreground #000000
}

#----------------------------------------------------------------------------
#### proc cutmenu ####
#----------------------------------------------------------------------------
proc cutmenu {} {

global widgetname
global contenttype
global description
global sumofwin
global bg1 bg2 actbg
.butt.label configure -text "Cutting mesagepart..." -foreground #3d55ff

if {$sumofwin>1} {
  toplevel .delete
  wm title .delete "Cut Part of Message"
  wm iconname .delete "Messagepart"

  label .delete.l -text "Cut Part of Message" -background $bg1 -foreground \
	red -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*"
  pack .delete.l -fill x -side top

  for {set i 1} {$i <= $sumofwin} {incr i 1} {
    button .delete.b$i -text "$i. $description($i)" -anchor w -background \
	$bg1 -activebackground $actbg -command "destroy .delete; cutpart $i" 
    pack .delete.b$i -side top -fill x
    } 
  button .delete.cancel -width 10 -text "Cancel" -background $bg1 \
        -foreground black -activebackground $actbg -command "destroy .delete; \
	.butt.label configure -text \"Cutting mesagepart...Cancelled\" \
	-foreground #000000" -borderwidth 2 -relief ridge
  pack .delete.cancel -side top -fill x
  grab .delete
  } else {
  toplevel .delete
  wm title .delete "Cut Part of Message"
  wm iconname .delete "Messagepart"
  label .delete.l -text " You can't delete the last part! " -background $bg1 \
	-foreground  red -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*"
  pack .delete.l -fill x -side top
  button .delete.ok -width 10 -text "Ok" -background $bg1 \
        -foreground black -activebackground $actbg -command {destroy .delete} \
        -borderwidth 2 -relief ridge
  pack .delete.ok -side top -fill x
 .butt.label configure -text "Cutting mesagepart...Cancelled" -foreground #000000
  }
}

#----------------------------------------------------------------------------
#### proc undocutmessagepart
#----------------------------------------------------------------------------
proc undocutmessagepart {} {
global cutmessage
global winnumber
global includenum
global currentwidgetnumber
global sumofwin
global widgetname
global contenttype
global body
global description
global bg1 bg2 actbg bheight

if {$cutmessage(cut)=="true"} {
.butt.label configure -text "Inserting the cut messagepart...done" \
	-foreground #000000
  set cutmessage(cut) "false"
  set sumofwin [expr $sumofwin+1]
  set includenum [expr $includenum+1]

  if {$cutmessage(position)>=$sumofwin} {
    set currentframe  [split $widgetname([expr $cutmessage(position)-1]) .]
    set currentframe .[lindex $currentframe 1]
    frame .f$includenum -background $bg1
    pack .f$includenum -fill both -side top -after $currentframe 
    if {$cutmessage(description)!="textfield"} {
       canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
       pack .f$includenum.canvas -fill x
       .f$includenum.canvas create text 1 10 -text $cutmessage(description) \
          -anchor w
       set currentwidgetnumber(.f$includenum.canvas) \
        $cutmessage(position)
       set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
        .f$includenum.canvas
       set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(contenttype)
       set description($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(description)
       set body($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(body)
     } else {
       text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
       scrollbar .f$includenum.scroll -relief flat -background $bg2 \
        -foreground  $bg2 -activeforeground $actbg \
        -command ".f$includenum.text yview"
       pack .f$includenum.scroll -side right -fill y
       pack .f$includenum.text -expand yes -fill both
       .f$includenum.text insert 1.0 $cutmessage(text)
       set currentwidgetnumber(.f$includenum.text) \
         $cutmessage(position)
       set widgetname($currentwidgetnumber(.f$includenum.text)) \
        .f$includenum.text
       set contenttype($currentwidgetnumber(.f$includenum.text)) \
        $cutmessage(contenttype)
       set description($currentwidgetnumber(.f$includenum.text)) \
        $cutmessage(description)
       set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
    }
  } else {
  # If not last of the bodyparts
    set currentframe  [split $widgetname($cutmessage(position)) .]
    set currentframe .[lindex $currentframe 1]
    frame .f$includenum -background $bg1
    pack .f$includenum -fill both -side top -before $currentframe	
    if {$cutmessage(description)!="textfield"} {
       canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
       pack .f$includenum.canvas -fill x
       .f$includenum.canvas create text 1 10 -text $cutmessage(description) \
          -anchor w
       updatesendlist $cutmessage(position) $sumofwin
       set currentwidgetnumber(.f$includenum.canvas) \
        $cutmessage(position)
       set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
        .f$includenum.canvas
       set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(contenttype)
       set description($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(description)
       set body($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(body)
     } else {
       text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
       scrollbar .f$includenum.scroll -relief flat -background $bg2 \
        -foreground  $bg2 -activeforeground $actbg \
        -command ".f$includenum.text yview"
       pack .f$includenum.scroll -side right -fill y
       pack .f$includenum.text -expand yes -fill both
       .f$includenum.text insert 1.0 $cutmessage(text)
       updatesendlist $cutmessage(position) $sumofwin
       set currentwidgetnumber(.f$includenum.text) \
         $cutmessage(position)
       set widgetname($currentwidgetnumber(.f$includenum.text)) \
        .f$includenum.text
       set contenttype($currentwidgetnumber(.f$includenum.text)) \
        $cutmessage(contenttype)
       set description($currentwidgetnumber(.f$includenum.text)) \
        $cutmessage(description)
       set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
     }
  }
} else {
  ###If nothing is cut###
  toplevel .pastemessage
  label .pastemessage.l -text "You haven't cut any part!" -background $bg1 \
	-foreground red -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*"
  pack .pastemessage.l -fill x -side top
  button .pastemessage.b -width 10 -text "Ok" -background $bg1 \
        -activebackground $actbg -command {destroy .pastemessage}
  pack .pastemessage.b -side top -fill x
  grab .pastemessage
  .butt.label configure -text "Inserting the cut messagepart...Cancelled" \
        -foreground #000000

}
}

#----------------------------------------------------------------------------
#### proc pastemessagepart ####
#----------------------------------------------------------------------------
proc pastemessagepart {} {
global cutmessage
global bg1 bg2 actbg bheight

if {$cutmessage(cut)=="true"} {
  global breakpoint
  global currenttext
  global winnumber
  global includenum
  global sumofwin
  global currentwidgetnumber
  global widgetname
  global contenttype
  global body
  global description
  .butt.label configure -text "Pasting the cut messagepart...done" \
        -foreground #000000
  
  set cutmessage(cut) "false"
  set sumofwin [expr $sumofwin+1]
  set includenum [expr $includenum+1]
  set currentframe [split $currenttext .]
  set part2 [lindex $currentframe 2]
  set currentframe .[lindex $currentframe 1]
  ## Checks if cursor doesn't stand in an textfield, the input will be first
  if {$part2 !="text"} {
    set currenttext $widgetname(1)
    set currentframe [split $currenttext .]
    set currentframe .[lindex $currentframe 1]
    set breakpoint 1.0
    }
  frame .f$includenum -background $bg1
  #### if first position in the current textwidget
  if {$breakpoint=="1.0"} {
     pack .f$includenum -fill both -side top -before $currentframe
     if {$cutmessage(description)!="textfield"} {
       canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
       pack .f$includenum.canvas -fill x
       .f$includenum.canvas create text 1 10 -text $cutmessage(description) \
          -anchor w
       updatesendlist $currentwidgetnumber($currenttext) $sumofwin
       set currentwidgetnumber(.f$includenum.canvas) \
        [expr $currentwidgetnumber($currenttext)-1]
       set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
        .f$includenum.canvas
       set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(contenttype)
       set description($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(description)
       set body($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(body)
     } else {
       text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
       scrollbar .f$includenum.scroll -relief flat -background $bg2 \
	-foreground  $bg2 -activeforeground $actbg \
	-command ".f$includenum.text yview"
       pack .f$includenum.scroll -side right -fill y
       pack .f$includenum.text -expand yes -fill both
       .f$includenum.text insert 1.0 $cutmessage(text) 
       updatesendlist $currentwidgetnumber($currenttext) $sumofwin
       set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)-1]
       set widgetname($currentwidgetnumber(.f$includenum.text)) \
        .f$includenum.text
       set contenttype($currentwidgetnumber(.f$includenum.text)) \
        $cutmessage(contenttype)
       set description($currentwidgetnumber(.f$includenum.text)) \
        $cutmessage(description)
       set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
     } 
     # if position is not 1.0# # # #
     } else {
     pack .f$includenum -fill both -side top -after $currentframe
     text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
     scrollbar .f$includenum.scroll -relief flat -background $bg2 -foreground \
        $bg2 -activeforeground $actbg -command ".f$includenum.text yview"
     pack .f$includenum.scroll -side right -fill y
     pack .f$includenum.text -expand yes -fill both
     .f$includenum.text insert 1.0 [ $currenttext get insert end]
     $currenttext delete insert end
     updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin

     set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
     set widgetname($currentwidgetnumber(.f$includenum.text)) .f$includenum.text
     set contenttype($currentwidgetnumber(.f$includenum.text)) \
       "\[SafeTcl_makebody \"text/plain\" "
     set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
     set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"
     set sumofwin [expr $sumofwin+1]
     set includenum [expr $includenum+1]
     frame .f$includenum -background $bg1
     pack .f$includenum -fill both -side top -after $currentframe
     if {$cutmessage(description)!="textfield"} {
       canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
       pack .f$includenum.canvas -fill x
       .f$includenum.canvas create text 1 10 -text $cutmessage(description) \
          -anchor w
       set currentwidgetnumber(.f$includenum.canvas) \
        [expr $currentwidgetnumber($currenttext)+1]
       updatesendlist [expr $currentwidgetnumber($currenttext)+1]  $sumofwin
       set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
        .f$includenum.canvas
       set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(contenttype)
       set description($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(description)
       set body($currentwidgetnumber(.f$includenum.canvas)) \
        $cutmessage(body)
     } else {
       text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
       scrollbar .f$includenum.scroll -relief flat -background $bg2 \
        -foreground  $bg2 -activeforeground $actbg \
        -command ".f$includenum.text yview"
       pack .f$includenum.scroll -side right -fill y
       pack .f$includenum.text -expand yes -fill both
       .f$includenum.text insert 1.0 $cutmessage(text)
       set currentwidgetnumber(.f$includenum.text) \
        [expr $currentwidgetnumber($currenttext)+1]
       updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin
       set widgetname($currentwidgetnumber(.f$includenum.text)) \
        .f$includenum.text
       set contenttype($currentwidgetnumber(.f$includenum.text)) \
        $cutmessage(contenttype)
       set description($currentwidgetnumber(.f$includenum.text)) \
        $cutmessage(description)
       set body($currentwidgetnumber(.f$includenum.text)) \
        "\[.f$includenum.text get 1.0 end\]\] "
     }
    }
  } else {
  ###If nothing is cut###
    toplevel .pastemessage
    label .pastemessage.l -text "You haven't cut any part!" -background $bg1 \
	-foreground red -font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*"
    pack .pastemessage.l -fill x -side top
    button .pastemessage.b -width 10 -text "Ok" -background $bg1 \
  	-activebackground $actbg -command {destroy .pastemessage}
    pack .pastemessage.b -side top -fill x
    grab .pastemessage
.butt.label configure -text "Pasting the cut messagepart...Cancelled" \
        -foreground #000000

    }
}
