# textfile.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script generates a window with the  possibility to include a textfile.
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
#### textfile ####
# Calls a Fileselectbox with the label "Select textfile"
# When a file is selected, the selected file will be included at 
# the insert point of the texteditor
#---------------------------------------------------------------------------

proc textfile {} {
global fsBoxMessage window
set window [focus]
set temp [split $window .]
if {[lindex $temp 2]=="text" } {
  .butt.label configure -text "Include Text..." -foreground #3d55ff
  set fsBoxMessage "Select textfile"
  set filename [FSBox]
  if [file isfile $filename] {
     set f [open $filename]
     while {![eof $f]} {
        $window insert insert [read $f 10000]
        }
     close $f
     .butt.label configure -text "Include Text...done" -foreground #000000
     } else {
       .butt.label configure -text "Include Text...Cancelled" -foreground \
	#000000
     }
  }
}
