# x11dump.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script generates a window with the possibility to include an x11dump.
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
#### proc includex11dump ####
#----------------------------------------------------------------------------
proc wrapx11dump {} {
destroy .x11dump
}

#----------------------------------------------------------------------------
#### proc includex11dump ####
# Include an x11-dump and updates the mainwindow
# Just for sites with current (X11R5) pbm utilities
#----------------------------------------------------------------------------

proc includex11dump {} {
global breakpoint
global currenttext
global winnumber
global includenum
global sumofwin
global currentwidgetnumber
global widgetname
global contenttype
global body
global description
global bg1 bg2 actbg bheight

set dumpfile /tmp/[pid]$sumofwin.gif
exec xwd -frame | xwdtopnm 2> /dev/null | ppmtogif 2> /dev/null > $dumpfile

set sumofwin [expr $sumofwin+1]
set includenum [expr $includenum+1]
set currentframe [split $currenttext .]
set part2 [lindex $currentframe 2]
set currentframe .[lindex $currentframe 1]
## Checks if cursor doesn't stand in an textfield, then the input will be first
if {$part2 !="text"} {
   set currenttext $widgetname(1)
   set currentframe [split $currenttext .]
   set currentframe .[lindex $currentframe 1]
   set breakpoint 1.0
   }
frame .f$includenum -background $bg1
#### if first position in the current textwidget
if {$breakpoint=="1.0"} {
   pack .f$includenum -fill both -side top -before $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x 
   updatesendlist $currentwidgetnumber($currenttext) $sumofwin
   set currentwidgetnumber(.f$includenum.canvas) \
	[expr $currentwidgetnumber($currenttext)-1]
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
	.f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
	"\[SafeTcl_makebody \"image/gif\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
	"\[exec mimencode -b $dumpfile\] base64\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
	"X11 dump"	
   # # # # # 
} else {
   pack .f$includenum -fill both -side top -after $currentframe
   text .f$includenum.text -relief raised -bd 2 -background $bg2 \
        -yscrollcommand ".f$includenum.scroll set" -height $bheight
   scrollbar .f$includenum.scroll -relief flat -background $bg2 -foreground \
	$bg2 -activeforeground $actbg -command ".f$includenum.text yview"
   pack .f$includenum.scroll -side right -fill y
   pack .f$includenum.text -expand yes -fill both
   .f$includenum.text insert 1.0 [ $currenttext get insert end]
   $currenttext delete insert end 
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin

   set currentwidgetnumber(.f$includenum.text) \
	[expr $currentwidgetnumber($currenttext)+1]
   set widgetname($currentwidgetnumber(.f$includenum.text)) .f$includenum.text
   set contenttype($currentwidgetnumber(.f$includenum.text)) \
	"\[SafeTcl_makebody \"text/plain\" "
   set body($currentwidgetnumber(.f$includenum.text)) \
	"\[.f$includenum.text get 1.0 end\]\] "
   set description($currentwidgetnumber(.f$includenum.text)) \
        "textfield"
   set sumofwin [expr $sumofwin+1]
   set includenum [expr $includenum+1]
   frame .f$includenum -background $bg1
   pack .f$includenum -fill both -side top -after $currentframe
   canvas .f$includenum.canvas -background $bg1 -relief raised -height 20
   pack .f$includenum.canvas -fill x 

   set currentwidgetnumber(.f$includenum.canvas) [expr \
	$currentwidgetnumber($currenttext)+1]
   updatesendlist [expr $currentwidgetnumber($currenttext)+1] $sumofwin
   set widgetname($currentwidgetnumber(.f$includenum.canvas)) \
	.f$includenum.canvas
   set contenttype($currentwidgetnumber(.f$includenum.canvas)) \
	"\[SafeTcl_makebody \"image/gif\" "
   set body($currentwidgetnumber(.f$includenum.canvas)) \
	"\[exec mimencode -b $dumpfile\] base64\] "
   set description($currentwidgetnumber(.f$includenum.canvas)) \
        "X11 dump"
   }
.f$includenum.canvas create text 1 10 -text {X11 dump} -anchor w
destroy .x11dump
.butt.label configure -text "Including an X11 dump...done" -foreground #000000
}

#----------------------------------------------------------------------------
#### proc x11dump ####
# Creates a window which inform the user how to include an x11-dump
#----------------------------------------------------------------------------

proc x11dump {} {
global bg1 bg2 actbg 
.butt.label configure -text "Including an X11 dump..." -foreground #3d55ff
toplevel .x11dump
wm title .x11dump "An x11dump"
wm iconname .x11dump "x11dump"
frame .x11dump.labels -background $bg2 -relief ridge -borderwidth 2
pack .x11dump.labels -side top
label .x11dump.labels.label1 -text "An x11 dump" -background $bg2 \
	-font "-*-helvetica-*-r-*-*-*-240-*-*-*-*-*-*" -foreground red
label .x11dump.labels.label2 -text "If you want to include a x11dump" \
	-background $bg2
label .x11dump.labels.label3 -text "you first have to click Include, then" \
	-background $bg2
label .x11dump.labels.label4 -text "you can choose any window on the screen." \
	-background $bg2
label .x11dump.labels.label5 -text "After that you have to wait until" \
	-background $bg2
label .x11dump.labels.label6 -text "this window is destroyed." -background $bg2
label .x11dump.labels.label7 -text "It will take a few seconds." \
	-background $bg2
pack .x11dump.labels.label1 -side top -fill x
pack .x11dump.labels.label2 -side top -fill x 
pack .x11dump.labels.label3 -side top -fill x
pack .x11dump.labels.label4 -side top -fill x
pack .x11dump.labels.label5 -side top -fill x
pack .x11dump.labels.label6 -side top -fill x
pack .x11dump.labels.label7 -side top -fill x

#----------------------------------------------------------------------------
# Button actions 
#----------------------------------------------------------------------------

frame .x11dump.f2 -background $bg1
pack .x11dump.f2 -fill both
button .x11dump.f2.include -text Include -command "includex11dump" \
	-background $bg1 -activebackground $actbg
button .x11dump.f2.cancel -text Cancel -command "wrapx11dump; .butt.label \
	configure -text \"Including an X11 dump...Cancelled\" -foreground \
	#000000" -background $bg1 -activebackground $actbg
pack .x11dump.f2.include .x11dump.f2.cancel -side left -expand yes -pady 5
grab .x11dump
}

