
proc stat_group {group} {
    global ActiveTable 

    set ret ""
    lappend ret $group
    lappend ret $ActiveTable($group,first)
    lappend ret $ActiveTable($group,last)
    set num [expr $ActiveTable($group,last)-$ActiveTable($group,first)]
    incr num
    lappend ret $num
    return $ret
}

proc get_article {group number} {
    global Resources

    set i [catch {set file [open "[group_getpath $group]/$number" "r"]}]
    if {$i} {
	return ""
    } 
    set ret [GetFile $file]
    close $file
    return $ret
}



proc get_active {} {
    global Resources
    global ActiveTable NumActive

    set NumActive 0
    set File [open $Resources(NEWSACTIVEFILE) "r"]
    while {[gets $File line] != -1} {
	set list [split $line " "]
	# ignore any group with an = in its posting field -- it is
	# just a pointer to another group.
	if {[string first "=" [lindex $list 3]] != -1} {
	    continue
	}
	set name [lindex $list 0]
	set ActiveTable($name,name) $name
	scan [lindex $list 1] "%d" ActiveTable($name,last)
	scan [lindex $list 2] "%d" ActiveTable($name,first)
	set ActiveTable($name,post) [lindex $list 3]
	incr NumActive
    }
}



proc load_article_list {group range field_list} {
    global GroupTable GroupIndex
    global ArticleTable NumArticles ArticleList

    set ranges [split $range ","]
    foreach range $ranges {
	if {[string first "-" $range] != -1} {
	    set ltmp [split $range "-"]
	    set first [lindex $ltmp 0]
	    set last [lindex $ltmp 1]
	} else {
	    set first $range
	    set last $range
	}
	if {$first < $GroupTable($GroupIndex,first)} {
	    set first $GroupTable($GroupIndex,first)
	}
	if {$last > $GroupTable($GroupIndex,last)} {
	    set last $GroupTable($GroupIndex,last)
	}
	if {$first > $last} {
	    continue
	}
	set err [catch {set listing [GetArticleList $group $first $last]}]
	if {$err} {
	    continue
	}
	set list [split $listing "\n"]
	foreach line $list {
	    if {$line == ""} {continue}
	    # field separator is ascii character 004
	    set l [split $line "\004"]
	    set number [lindex $l 0]
	    if {[lsearch $ArticleList $number] == -1} {
		lappend ArticleList $number
		incr NumArticles
		set ArticleTable($number,status) "u"
	    }
	    set ArticleTable($number,number) $number
	    set ArticleTable($number,subject) [lindex $l 1]
	    set ArticleTable($number,from) [lindex $l 2]
	    set i [string first "(" [lindex $l 2]]
	    if {$i == -1} {
		set ArticleTable($number,email) [lindex $l 2]
		set ArticleTable($number,name) [lindex $l 2]
	    } else {
		set j [string last ")" [lindex $l 2]]
		set ArticleTable($number,email) \
		    [string range [lindex $l 2] 0 [expr $i-1]]
		set ArticleTable($number,name) \
		    [string range [lindex $l 2] [expr $i+1] [expr $j-1]]
	    }
	    set ArticleTable($number,date) [lindex $l 3]
	    set ArticleTable($number,lines) [lindex $l 4] 
	    set ArticleTable($number,message-id) [lindex $l 5]
	    set ArticleTable($number,references) [lindex $l 6]
	    set ArticleTable($number,followup-to) [lindex $l 7]
	}
    }
    set ArticleList [Lisort $ArticleList]
}



proc get_new_groups {time} {
    global Resources
    
    set file [open "|sort -r +1 -2 $Resources(NEWSACTIVEFILE).times"]
    set list {}
    while {[gets $file line] != -1} {
	set i [regexp "(\[^ \t\]+) (\[0-9\]+)" $line junk group gtime]
	if {!$i} {
	    puts stdout "Bad line '$line'... skipping"
	    continue;
	}
	if {$gtime >= $time} {
	    # This newsgroup is new...
	    lappend list $group
	} else {
	    # this newsgroup is old... we are done.
	    return $list
	}
    }
    return $list
}
	
