proc draw {f w h} {
set width $w
set area [expr $width * $width]
set tmp 1
set w [genName .draw]
set sideCanvas [expr {$width * 40}]
toplevel $w
wm title $w "Markings"
frame $w.m
canvas $w.c -height $sideCanvas -width $sideCanvas
button $w.m.dismiss -text "Dismiss" -command "destroy $w"
button $w.m.legend -text "Legend"  -command "legendSquare"
pack append $w.m $w.c top $w.m.dismiss left $w.m.legend right
pack append $w $w.m {top fillx}

loop num 0 $area {
   loop row 0 $width {
      loop col 0 $width {
      set number [getNumber $f $row $col]
      if {$number == $tmp} {
         set X [expr {(($row + 1) * 40) - 20}]
         set Y [expr {(($col + 1) * 40) - 20}]
         if {$num == 0} {
            set firstX $X
            set firstY $Y
            incr tmp
            set col [expr $width -1]
            set row [expr $width -1]
            } else {
            $w.c create line $firstY $firstX $Y $X
            $w.c create oval [expr $firstY -2] [expr $firstX -2] [expr $firstY +2] [expr $firstX +2]
            focus $w.c
            set firstX $X
            set firstY $Y
            incr tmp
            set col [expr $width -1]
            set row [expr $width -1]
            }
         }
      }
   }
}
}
