set width 4
set height 4

proc minwidth {} {return 3}
proc minheight {} {return 3}
proc maxwidth {} {return 9}
proc maxheight {} {return 9}

# $f is frame/top window (already created)
# $w is width
# $h is height
proc makeBoard {f w h} {
  global $f.width $f.height $f.area $f.sum
  set $f.width $w
  set $f.height $h
  set $f.area [expr {$w * $h}]
  set $f.sum [expr {((($w * $w) + 1) / 2) * $w}]

  # Le menu
  frame $f.m
  menubutton $f.m.mb -text "Options" -menu $f.m.mb.m -relief raised
  button $f.m.help -text "Help" -command "helpSquare"
  pack append $f.m $f.m.mb {left frame w} $f.m.help {right frame e}

  menu $f.m.mb.m
  $f.m.mb.m add command -label "Play Again" -command "askResetBoard $f"
  $f.m.mb.m add command -label "Resize" -command "askResizeBoard $f"
  $f.m.mb.m add command -label "About..." -command "aboutSquare"
  $f.m.mb.m add command -label "Gripe..." -command "gripe tksquare"
  $f.m.mb.m add command -label "Quit" -command "quit Square"

  # Status stuff
  frame $f.st

  frame $f.st.m
  frame $f.st.t
  pack append $f.st $f.st.m {left frame w padx 20} $f.st.t {left frame e padx 20}

  # Time
  label $f.st.t.l -text "Time:"
  label $f.st.t.n -relief sunken -width 4
  pack append $f.st.t $f.st.t.l {left frame w} $f.st.t.n {left frame e}

  # Buttons
  frame $f.b

  pack append $f $f.m {top fillx} $f.st {top pady 20} $f.b top

  #for {set row 0} {$row < $h} {incr row}
  loop row 0 $h {
    frame $f.b.$row
    pack append $f.b $f.b.$row top
    #for {set col 0} {$col < $w} {incr col}
    loop col 0 $w {
      button $f.b.$row.$col  -width 2
      pack append $f.b.$row $f.b.$row.$col left
      bind $f.b.$row.$col <1> {eval showSquare [getSquare %W]}
      bind $f.b.$row.$col <3> {eval markSquare [getSquare %W]}
    }
  }
  resetBoard $f
}

proc getSquare {w} {
  set l [split $w .]
  set len [llength $l]
  set f [join [lrange $l 0 [expr {$len - 4}]] .]
  set r [lindex $l [expr {$len - 2}]]
  set c [lindex $l [expr {$len - 1}]]
  return [list $f $r $c]
}

proc resetBoard {f} {
  global $f.height $f.width
  global $f.done $f.started onemore
  busy
  set h [set $f.height]
  set w [set $f.width]
  #for {set row 0} {$row < $h} {incr row}
  loop row 0 $h {
    #for {set col 0} {$col < $w} {incr col}
    loop col 0 $w {
      initSquare $f $row $col
    }
  }
  set onemore 1
  set $f.done 0
  set $f.started 0
  resetTime $f
  updateTime $f
}

proc askResetBoard {f} {
  global $f.done
  if {[set $f.done]} {
    resetBoard $f
    return
  }
  yesNo "Reset Square Board" "Are you sure you want to reset the board?" "resetBoard $f" "noop" No
}

proc askResizeBoard {f} {
  global $f.done $f.started
  set done [set $f.done]
  set started [set $f.started]
      customResize $f
      return
  if {$done || ! $started} {
    resizeBoard $f $width $height
    return
  }
  multChoice "Reset Board Size" "Are you sure you want to reset the board to $width x $height?" [list [list "Yes" "resizeBoard $f $width $height"] {No noop}] No
}

proc aboutSquare {} {
  global version
  inform "tksquare version $version, by Fabrizio Pivari"
}

proc helpSquare {} {
  global helpFile
  set id [open "$helpFile" r]
  set msg [read $id]
  inform $msg
}

proc legendSquare {} {
  global legendFile
  set id [open "$legendFile" r]
  set msg [read $id]
  inform $msg
}

proc customResize {f} {
  global $f.width $f.height
  set w [genName .customResetSize]
  toplevel $w
  dpos $w
  wm title $w "Custom Board Size"

  frame $w.m

  scale $w.w -label "Side:" -orient horizontal -length 200 -from [minwidth] -to [maxwidth]

  $w.w set [set $f.width]

  pack append $w $w.w top $w.m top

  frameMultChoice $w.yesNo "" [list [list "Resize Board" "resizeBoardCustom $f $w"] [list "Cancel" "destroy $w"]] Cancel
  pack append $w $w.yesNo {top fillx}
}

proc resizeBoardCustom {f win} {
  set w [$win.w get]
  set h [$win.w get]
  resizeBoard $f $w $h
  destroy $win
}

proc resizeBoard {f w h} {
  set win [inform "Resizing board. Please stand by."]
  destroy $f
  toplevel $f
  wm title $f Square
  makeBoard $f $w $h
  destroy $win
}

proc initSquare {f row col} {
  setGuess $f $row $col empty
  $f.b.$row.$col config -background lightgrey -activebackground grey -relief raised
}

proc resetTime {f} {
  global $f.time
  set $f.time [getclock]
}

proc updateTime {f} {
  global $f.done
  set time [getTime $f]
  $f.st.t.n config -text $time
  if {[set $f.done]} {return}
  after 1000 updateTime $f
}

proc checkWin {f} {
global $f.height $f.width $f.sum
set h [set $f.height]
set w [set $f.width]
set sum [set $f.sum]
set linea 0
set colonna 0
set diag1 0
set diag2 0
loop row 0 $h {
   loop col 0 $w {
   set tmp [getNumber $f $row $col]
   set tmp1 [getNumber $f $col $row]
   set linea [expr {$linea + $tmp}]
   set colonna [expr {$colonna + $tmp1}]
   }
if {$linea != $sum} {
   loseGame $f [getTime $f]
   return
   }
if {$colonna != $sum} {
   loseGame $f [getTime $f]
   return
   }
set linea 0
set colonna 0
set tmp2 [getNumber $f $row $row]
set tmp4 [expr {$h -1 -$row}]
set tmp3 [getNumber $f $tmp4 $row]
set diag1 [expr {$diag1 + $tmp2}]
set diag2 [expr {$diag2 + $tmp3}]
}
if {$diag1 != $sum} {
   loseGame $f [getTime $f]
   return
   }
if {$diag2 != $sum} {
   loseGame $f [getTime $f]
   return
   }
   winGame $f [getTime $f]
   draw $f $w $h
}

proc getTime {f} {
  global $f.time $f.started
  if {! [set $f.started]} {
    resetTime $f
  }
  set start [set $f.time]
  set now [getclock]
  set diff [expr {$now - $start}]
  return [fmtTime $diff]
}

proc fmtTime {time} {
  set min [expr {$time / 60}]
  set sec [expr {$time % 60}]
  # Format the time
  if {$sec == 0} {return "$min:00"}
  if {$sec < 10} {return "$min:0$sec"}
  return "$min:$sec"
}

proc showSquare {f row col} {
global onemore $f.done $f.started $f.area
if {[set $f.done]} {return}
set guess [getGuess $f $row $col]
if {$guess == "known"} {return}
setGuess $f $row $col $onemore
setGuess $f $row $col known
setNumber $f $row $col $onemore
if {! [set $f.started]} {
   set $f.started 1

}
update
set area [set $f.area]
if {$onemore == $area} {checkWin $f}
incr onemore
}

proc markSquare {f row col} {
global onemore
  set last [expr $onemore -1]
  set guess [getGuess $f $row $col]
  if {$guess == "empty"} {return}
  set number [getNumber $f $row $col]
  if {$guess == "known"} {
     if {$last != $number} {return}
  }
      set guess empty
      set onemore $last
  setGuess $f $row $col $guess
}

proc setNumber {f row col number} {
  global $f.$row.$col.number
  set $f.$row.$col.number $number
  }

proc setGuess {f row col guess} {
  global $f.$row.$col.guess onemore
  set $f.$row.$col.guess $guess
  if {$guess != "known"} {
     if {$guess == "empty"} {
       $f.b.$row.$col config -font {-*-Helvetica-Bold-R-Normal--24-*-*} -text ""
       return
       }
    $f.b.$row.$col config -font {-*-Helvetica-Bold-R-Normal--24-*-*} -text $guess
  }
}

proc getNumber {f row col} {
  getParam $f $row $col number
}

proc getGuess {f row col} {
  getParam $f $row $col guess
}

proc getParam {f row col param} {
  global $f.$row.$col.$param
  return [set $f.$row.$col.$param]
}

proc loseGame {f time} {
  global $f.done
  set $f.done 1
  update idletasks
  multChoice "No good!" "This isn't a Magic Square!" [list {OK noop} [list "Play Again" "resetBoard $f"] [list "Quit" "quit Square 0"]] "Play Again"
}

proc winGame {f time} {
  global $f.done
  set $f.done 1
  update idletasks
    multChoice "O.K.!" "This is a real Magic Square, in only $time!" [list {OK noop} [list "Play Again" "resetBoard $f"] [list "Quit" "quit Square 0"]] "Play Again"
}
