# Voreinstellungsmen fr Bibliographie
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen


proc bvanzeigen {s1} {
  global vv bitext bibtex bioptions
  writescr0 .bv.d.tt "$s1\n\n" \
                     "$bitext\n\n" \
                     " $vv(ausg2)  $bibtex\n" \
                     " $vv(ausg3)  $bioptions\n\n"
}


proc bvanzeige {} {
  global  vv bibtex bitext
  if {$bibtex==""} {set t $vv(bvbad1)} else {set t "$vv(bvbad2) $bibtex $bitext"}
  .bv.b.ad configure -text "$t"
}


proc bv  {} {

global  vv hlp_dir bibtex bitext bioptions bvsep


toplevel .bv
wm title .bv "$vv(bvvor)"
wm minsize .bv 0 0


set tyh 18


# Bereich a fuer erste Buttons

frame .bv.a -relief raised -borderwidth 1
pack configure .bv.a -in .bv -pady 10 -anchor w
 
button .bv.a.e -text "$vv(ae)"
bind   .bv.a.e <Button-3>   {+ cat_file0 "${hlp_dir}z_vstquit.hlp" .bv.d.tt }

button .bv.a.h -text "$vv(ah)" 
bind   .bv.a.h <Any-Button> {+ cat_file0 "${hlp_dir}bv_h.hlp" .bv.d.tt }

button .bv.a.l -text "$vv(al)" -command {clearscr .bv.d.tt}
bind   .bv.a.l <Button-3>   {+ cat_file0 "${hlp_dir}z_loeschetf.hlp" .bv.d.tt }

button .bv.a.g -text "$vv(ag)" -command {
  set foid [open_vst default.vst]
  while { [getscl $foid ein] > 0 } {
   mtest $ein 19 bibtex
   mtest $ein 19 bitext
   mtest $ein 19 bioptions
  }
  close $foid
  bvanzeige
  .bv.cb delete 0 end
  .bv.cb insert end "$bioptions"
  bvanzeigen "$vv(ausg1)"
}
bind   .bv.a.g <Button-3>   {+ cat_file0 "${hlp_dir}bv_grund.hlp" .bv.d.tt }

pack configure .bv.a.e .bv.a.h .bv.a.l .bv.a.g -in .bv.a -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame .bv.bv
pack configure .bv.bv -in .bv -pady 13 -anchor w

label  .bv.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
bind   .bv.bv.dv <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .bv.d.tt }

button .bv.bv.va -text "$vv(bvva)" -command {bvanzeigen "$vv(aus0)"}
bind  .bv.bv.va <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .bv.d.tt }

pack configure .bv.bv.dv .bv.bv.va -in .bv.bv -side left


# Bereich b fuer Anzeigen   

frame .bv.b
pack configure .bv.b -in .bv -anchor w

label .bv.b.ad -width 90 -anchor w
bind  .bv.b.ad <Button-3> {+ cat_file0 "${hlp_dir}bv_anzeig.hlp" .bv.d.tt }
pack configure .bv.b.ad -in .bv.b
bvanzeige

# Bereich c fuer Bibliographie-Programm-Auswahl

frame .bv.c
pack configure .bv.c -in .bv -anchor w

label .bv.c.l -text "$vv(bvcl)"
bind  .bv.c.l <Button-3> {+ cat_file0 "${hlp_dir}bv_progsel.hlp" .bv.d.tt}
frame .bv.c.fr -relief raised -borderwidth 2 
pack configure .bv.c.l .bv.c.fr -in .bv.c -side left

scrollbar .bv.c.fr.sb -command ".bv.c.fr.li yview"
bind      .bv.c.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}bv_progsel.hlp" .bv.d.tt}
listbox   .bv.c.fr.li -yscroll ".bv.c.fr.sb set" -geometry 45x10
set bvsep [fillboxsep   .bv.c.fr.li bibtex.vst]
bind      .bv.c.fr.li <Triple-Button-1> { }
bind      .bv.c.fr.li <Double-Button-1> {
  global bvsep
  foreach i [selection get] { set ii $i }
  set bibtex     [getvalue $ii 0 $bvsep]
  set bitext     [getvalue $ii 1 $bvsep]
  set bioptions  [getvalue $ii 2 $bvsep]
  .bv.cb delete 0 end 
  .bv.cb insert end "$bioptions"
  bvanzeige
  bvanzeigen "$vv(bv2)"
  selection clear .bv.c.fr.li
}
bind      .bv.c.fr.li <Button-3> {+ cat_file0 "${hlp_dir}bv_progsel.hlp" .bv.d.tt}
pack configure .bv.c.fr.sb .bv.c.fr.li -in .bv.c.fr -side right -fill y


# Ausgabe und Veraendern des Optionen-Strings

label .bv.ca -text "$vv(bvca)"
bind .bv.ca <Button-3> {+ cat_file0 "${hlp_dir}bv_optedi.hlp" .bv.d.tt }
pack configure .bv.ca -in .bv -anchor w

entry .bv.cb -width 80 -relief sunken
      .bv.cb delete 0 end 
      .bv.cb insert end "$bioptions"
bind  .bv.cb <Button-3> {+ cat_file0 "${hlp_dir}bv_optedi.hlp" .bv.d.tt }
bind  .bv.cb <Return> {
  set bioptions  [.bv.cb get] 
  writescr0 .bv.d.tt "$vv(aus4)\n $bioptions\n"
  focus none
}
pack configure .bv.cb -in .bv -anchor w
focus none


# Bereich d fuer Hilfe-Ausgaben

frame .bv.d -relief raised -borderwidth 2
pack configure .bv.d -in .bv -anchor sw -pady 6

scrollbar .bv.d.sb -command ".bv.d.tt yview"
bind      .bv.d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .bv.d.tt}
text      .bv.d.tt -yscroll ".bv.d.sb set" -height $tyh
bind      .bv.d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .bv.d.tt}
pack configure .bv.d.sb .bv.d.tt -in .bv.d -side right -fill y
.bv.d.tt configure -state disabled

}
