# call of printer driver and forewarding of output
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc dvi2printer {} {# call of printer driver and forewarding of output

  global vv austext prtdriver prt_file prtfilperm printer prtselstr

  if { $prtdriver == "" } {

  } else {
    if { [winfo exists .dm] } {destroy .dm}
    printmenu

    bind .dm.a.e <ButtonRelease-1> {#  OK, printer driver call request
      destroy .dm
      set sub 1
      set ret [prt_$prtdriver .d.tt austext];  writescr .d.tt "$austext"
      if { (($ret == "") || ($ret == "0")) && [file exists $prt_file] } {
        if { [winfo exists .t] == 1 } {destroy .t}; toplevel .t
        set frage "[eval list $vv(drafrage)]"
        request .t "$frage " "$vv(draja)" "$vv(dranein)" dm_ausdrucken.hlp .d.tt
        bind .t.bv.abb <ButtonRelease-1> {# output is not to be printed
          destroy .t
          if { $prtfilperm == "$vv(dm20)" } {unlink -nocomplain $prt_file}
          unlock_list
        }
        bind .t.bv.aus <ButtonRelease-1> {# output is to be printed
          destroy .t
          printing   .d.tt austext; writescr .d.tt "$austext"
          if { $prtfilperm == "$vv(dm20)" } {unlink -nocomplain $prt_file}
          unlock_list
        }
      } else {# prt_....tcl aborted or no output file produced by prt_....tcl
        if { ![file exists $prt_file] } {writescr .d.tt "\n*** $vv(drakd)\n";bell}
        if { $prtfilperm == $vv(dm20) } {unlink -nocomplain $prt_file}
        unlock_list
      }
    }

    bind .dm.a.a <ButtonRelease-1> {# cancel, i.e. no printer driver call
      destroy .dm
      unlock_list
    }

  }

}
