# Voreinstellungsmen fr Logfiles/Protokolldateien   
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc lvanzeigen {s1} {
  global vv logtext logform logback logxterm logoptions main_file lsuff
  writescr0 .lv.d.tt "$s1\n\n"  "$logtext\n\n" \
                     " $vv(lv2)  $logform$logback\n" \
                     " $vv(lv7)  $logxterm\n"  \
                     " $vv(lv3)  $logoptions\n" \
                     " $vv(lv4)  $main_file$lsuff\n\n" 
}


proc lv  {} {

global  vv hlp_dir
global  efile dir editor edback edtext edxterm edoptions esuff esuffl
global  main_file logform logtext logxterm logoptions logback lsuff lvsep


toplevel .lv
wm title .lv "$vv(lvvor)"
wm minsize .lv 0 0


set tyh 25
set dir [pwd]


# Bereich a fuer erste Buttons

frame .lv.a -relief raised -borderwidth 1
pack configure .lv.a -in .lv -pady 10 -anchor w
 
button .lv.a.e -text "$vv(ae)"
bind   .lv.a.e <Button-3>   {+ cat_file0 "${hlp_dir}z_vstquit.hlp" .lv.d.tt}
button .lv.a.h -text "$vv(ah)" 
bind   .lv.a.h <Any-Button> {+ cat_file0 "${hlp_dir}lv_h.hlp" .lv.d.tt}
button .lv.a.l -text "$vv(al)" -command {clearscr .lv.d.tt}
bind   .lv.a.l <Button-3>   {+ cat_file0 "${hlp_dir}z_loeschetf.hlp" .lv.d.tt}
button .lv.a.g -text "$vv(ag)" -command {
  set foid [open_vst default.vst]
  while { [getscl $foid ein] > 0 } {
    mtest $ein 19 logform
    mtest $ein 19 logxterm
    mtest $ein 19 logoptions
    mtest $ein 19 logtext
  }
  close $foid
  progback  logform logback
  if {$logform=="\$editor"} {set logform $editor; set logoptions $edoptions}
  lvanzeigen "$vv(ausg1)"
}
bind   .lv.a.g <Button-3>   {+ cat_file0 "${hlp_dir}lv_grund.hlp" .lv.d.tt}
pack configure .lv.a.e .lv.a.h .lv.a.l .lv.a.g -in .lv.a -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame .lv.bv
pack configure .lv.bv -in .lv -pady 13 -anchor w

label  .lv.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
bind   .lv.bv.dv <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .lv.d.tt}
button .lv.bv.va -text "$vv(bvva)" -command {lvanzeigen "$vv(aus0)"}
bind   .lv.bv.va <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .lv.d.tt}
pack configure .lv.bv.dv .lv.bv.va -in .lv.bv -side left


# Bereich c fuer Wechsel   

frame .lv.c 
pack configure .lv.c -in .lv -anchor w


# Bereich c1 fuer Wechsel Darstellungsart     

frame .lv.c.1 
pack configure .lv.c.1  -in .lv.c -side left -fill x

label .lv.c.1.fl -text "$vv(lvc1fl)" -anchor w 
bind  .lv.c.1.fl <Button-3> {+ cat_file0 "${hlp_dir}lv_logform.hlp" .lv.d.tt}
frame .lv.c.1.fr -relief raised -borderwidth 2 
pack configure .lv.c.1.fl .lv.c.1.fr -in .lv.c.1 -anchor w

scrollbar .lv.c.1.fr.sb -command ".lv.c.1.fr.li yview"
bind      .lv.c.1.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}lv_logform.hlp" .lv.d.tt}
listbox   .lv.c.1.fr.li -yscroll ".lv.c.1.fr.sb set" -geometry 32x10
set lvsep [fillboxsep   .lv.c.1.fr.li logform.vst]
bind      .lv.c.1.fr.li <Button-3> {+ cat_file0 "${hlp_dir}lv_logform.hlp" .lv.d.tt}
bind      .lv.c.1.fr.li <Triple-Button-1> { }
bind      .lv.c.1.fr.li <Double-Button-1> {
  foreach i [selection get] {set ii $i}
  set logtext     [getvalue $ii 0 $lvsep]
  set logxterm    [getvalue $ii 1 $lvsep]
  set logform     [getvalue $ii 2 $lvsep]
  set logoptions [getvalue $ii 3 $lvsep]
  progback  logform  logback
  if {$logform=="\$editor"} { 
    set logform $editor;          set logback $edback
    set logoptions $edoptions;  set logtext ""; set logxterm $edxterm
  }
  lvanzeigen "$vv(lv5)"
}
pack configure .lv.c.1.fr.sb .lv.c.1.fr.li -in .lv.c.1.fr -side right -fill y


# Bereich c2 fuer Wechsel Protokolldatei    

frame .lv.c.2
pack configure .lv.c.2 -in .lv.c -side left

label .lv.c.2.dl -text "$vv(lvc2dl) \"$main_file\":" -anchor w
bind  .lv.c.2.dl <Button-3> {+ cat_file0 "${hlp_dir}lv_filesel.hlp" .lv.d.tt}
frame .lv.c.2.fr -relief raised -borderwidth 2    
pack configure .lv.c.2.dl .lv.c.2.fr -in .lv.c.2 -anchor w

scrollbar .lv.c.2.fr.sb -command ".lv.c.2.fr.li yview"
bind      .lv.c.2.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}lv_filesel.hlp" .lv.d.tt}
listbox   .lv.c.2.fr.li -yscroll ".lv.c.2.fr.sb set" -geometry 45x10
pack configure .lv.c.2.fr.sb .lv.c.2.fr.li -in .lv.c.2.fr -side right -fill y

# List-Box fuer Protokolldateien fuellen
set dateiliste [lsort [glob -nocomplain -- *]]
set foid [open_vst logsuffix.vst]
while { [getscl $foid ein] > 0 } {
  set suff [string trim [string range $ein 0 [string first " " $ein]]]
  if { [string first $main_file$suff $dateiliste] >= 0 } {
    .lv.c.2.fr.li insert end $main_file[string trim $ein]
  }
}
close $foid

#bind fuer c2 (Protokolldatei)
bind .lv.c.2.fr.li <Triple-Button-1> { }
bind .lv.c.2.fr.li <Double-Button-1> {
  set ii [catch {selection get} i] 
  if { $ii == 0 } {
    set lsuff  $i
    set lsuff  [string range $lsuff 0 [expr [string first " " $lsuff]-1]]
    set lsuff  [string range $lsuff [string last "." $lsuff] end]
    writescr0 .lv.d.tt "$vv(lv6) $main_file$lsuff\n"
  }
}
bind .lv.c.2.fr.li <Button-3> {+ cat_file0 "${hlp_dir}lv_filesel.hlp" .lv.d.tt}


# Bereich d fuer Hilfe-Ausgaben

frame .lv.d -relief raised -borderwidth 2
pack configure .lv.d -in .lv -anchor sw -pady 6

scrollbar .lv.d.sb -command ".lv.d.tt yview"
bind      .lv.d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .lv.d.tt}
text      .lv.d.tt -yscroll ".lv.d.sb set" -height $tyh
bind      .lv.d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .lv.d.tt}
pack configure .lv.d.sb .lv.d.tt -in .lv.d -side right -fill y
.lv.d.tt configure -state disabled
 
}
