# call of the printer driver dvijep with the file $main_file,
#                                                    output into $prt_file
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc prt_dvijep {f austext} {

  upvar 1 $austext a

  global vv main_file prtoptions pg_start pg_end prmsel prt_file opsep printcops

  writescr $f ""
  set a ""

  set a "${a}[datime] $vv(dta1) \"dvijep\" $vv(dta2)\n"

  set opt1 "[lindex [split $prtoptions $opsep] 1] -c$printcops"
  set opt2 "[lindex [split $prtoptions $opsep] 2]"

  set opt_seiten ""  

  if { $prmsel=="rel" || $prmsel=="u_rel"  || $prmsel=="g_rel" } {

    if { ($pg_start=="$vv(dmstart)") } {set start 1}    else {set start $pg_start}
    if { ($pg_end =="$vv(dmend)") }   {set ende  9999} else {set ende  $pg_end}
    set incr "1"
    if { $prmsel=="u_rel" } {
      set start [expr "(($start/2)*2)+1"]
      set incr "2"
    }
    if { $prmsel=="g_rel" } {
      set start [expr "(($start+1)/2)*2"]
      set incr "2"
    }
    set opt_seiten "-o$start:$ende:$incr"

  } else {       # error: unexpected value of $prmsel      

    set a "${a}\n$vv(pra1) (prt_dvijep.tcl): $vv(dt1) $prmsel\n"
    set a "${a}$vv(pra2)\n"
    bell; return 1

  }
  
  eval mkCmd_wait $f dvijep [list "$opt1 $opt2 $opt_seiten $main_file"]
  if { $main_file$prtsuf != $prt_file } {exec mv $main_file$prtsuf $prt_file}

  return 0

}
