# Voreinstellungsmen fr Rechtschreibprfung
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc rvanzeigen {s1} {
  global vv sptext spcmd splang spoptions
  writescr0 .rv.d.tt "$s1\n\n"  "$sptext\n\n" \
                     " $vv(rv2)  $spcmd\n" \
                     " $vv(rv3)  $splang\n" \
                     " $vv(rv4)  $spoptions\n\n"
}


proc rv  {} {

global  vv hlp_dir spcmd splang spoptions spcorr spselect sptext rvsep


toplevel .rv
wm title .rv "$vv(rvvor)"
wm minsize .rv 0 0


set tyh 19


# Bereich a fuer erste Buttons

frame .rv.a -relief raised -borderwidth 1
pack configure .rv.a -in .rv -pady 10 -anchor w
 
button .rv.a.e -text "$vv(ae)"
bind   .rv.a.e <Button-3> {+ cat_file0 "${hlp_dir}z_vstquit.hlp" .rv.d.tt}
button .rv.a.h -text "$vv(ah)" 
bind   .rv.a.h <Any-Button> {+ cat_file0 "${hlp_dir}rv_h.hlp" .rv.d.tt}
button .rv.a.l -text "$vv(al)" -command {clearscr .rv.d.tt}
bind   .rv.a.l <Button-3> {+ cat_file0 "${hlp_dir}z_loeschetf.hlp" .rv.d.tt}
button .rv.a.g -text "$vv(ag)" -command {
  set foid [open_vst default.vst]
  while { [getscl $foid ein] > 0 } {
   mtest $ein 19 spcmd
   mtest $ein 19 sptext
   mtest $ein 19 splang
   mtest $ein 19 spcorr
   mtest $ein 19 spselect
   mtest $ein 19 spoptions
  }
  close $foid
  if { $spcmd == "" } {
    .rv.b.ad configure -text "$vv(rvbad1)" 
  } else {
    .rv.b.ad configure -text "$vv(rvbad2)  $spcmd  ($sptext)"
  }
  .rv.cb delete 0 end
  .rv.cb insert end "$spoptions"
  rvanzeigen "$vv(ausg1)"
}
bind   .rv.a.g <Button-3> {+ cat_file0 "${hlp_dir}rv_grund.hlp" .rv.d.tt}
pack configure .rv.a.e .rv.a.h .rv.a.l .rv.a.g -in .rv.a -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame .rv.bv
pack configure .rv.bv -in .rv -pady 13 -anchor w

label  .rv.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
bind   .rv.bv.dv <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .rv.d.tt}
button .rv.bv.va -text "$vv(bvva)" -command {rvanzeigen "$vv(aus0)"}

bind   .rv.bv.va <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .rv.d.tt}
pack configure .rv.bv.dv .rv.bv.va -in .rv.bv -side left


# Bereich b fuer Anzeigen   

frame .rv.b
pack configure .rv.b -in .rv -anchor w

label .rv.b.ad -width 90 -anchor w
if { $spcmd == "" } {
  .rv.b.ad configure -text "$vv(rvbad1)" 
} else {
  .rv.b.ad configure -text "$vv(rvbad2) $spcmd ($sptext)"
}
bind  .rv.b.ad <Button-3> {+ cat_file0 "${hlp_dir}rv_anzeig.hlp" .rv.d.tt}
pack configure .rv.b.ad -in .rv.b


# Bereich c fuer Wechsel   

frame .rv.c
pack configure .rv.c -in .rv -anchor w

label .rv.c.dl -text "$vv(rvcdl)"
bind  .rv.c.dl <Button-3> {+ cat_file0 "${hlp_dir}rv_progsel.hlp" .rv.d.tt}
frame .rv.c.fr -relief raised -borderwidth 2 
pack configure .rv.c.dl .rv.c.fr -in .rv.c -anchor w

scrollbar .rv.c.fr.sb -command ".rv.c.fr.li yview"
bind      .rv.c.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}rv_progsel.hlp" .rv.d.tt}
listbox   .rv.c.fr.li -yscroll ".rv.c.fr.sb set" -geometry 80x10
set rvsep [fillboxsep .rv.c.fr.li spellcheck.vst]
bind      .rv.c.fr.li <Button-3> {+ cat_file0 "${hlp_dir}rv_progsel.hlp" .rv.d.tt}
bind      .rv.c.fr.li <Triple-Button-1> { }
bind      .rv.c.fr.li <Double-Button-1> {
  global rvsep
  foreach i [selection get] {set ii $i}
  set sptext    [getvalue $ii 0 $rvsep]
  set spcmd     [getvalue $ii 1 $rvsep]
  set splang    [getvalue $ii 2 $rvsep]
  set spcorr    [getvalue $ii 3 $rvsep]
  set spselect  [getvalue $ii 4 $rvsep]
  set spoptions [getvalue $ii 5 $rvsep]
  .rv.cb delete 0 end 
  .rv.cb insert end "$spoptions"
  .rv.b.ad configure -text "$vv(rvbad2) $spcmd ($sptext)"
  rvanzeigen "$vv(rv5)"
  selection clear .rv.c.fr.li
}
pack configure .rv.c.fr.sb .rv.c.fr.li -in .rv.c.fr -side right -fill y


# Ausgabe und Veraendern des Optionen-Strings

label .rv.ca  -anchor w -text "$vv(rvca)"
bind  .rv.ca <Button-3> {+ cat_file0 "${hlp_dir}rv_optedi.hlp" .rv.d.tt}
pack configure .rv.ca -in .rv -anchor sw -pady 12

entry .rv.cb -width 80 -relief sunken
      .rv.cb delete 0 end 
      .rv.cb insert end "$spoptions"
bind  .rv.cb <Button-3> {+ cat_file0 "${hlp_dir}rv_optedi.hlp" .rv.d.tt}
bind  .rv.cb <Return> {
  set spoptions  [.rv.cb get] 
  writescr0 .rv.d.tt  "$vv(aus4)\n $spoptions\n"
  focus none
}
pack configure .rv.cb -in .rv -anchor nw
focus none


# Bereich d fuer Hilfe-Ausgaben

frame .rv.d -relief raised -borderwidth 2
pack configure .rv.d -in .rv -anchor sw -pady 6

scrollbar .rv.d.sb -command ".rv.d.tt yview"
bind      .rv.d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .rv.d.tt}
text      .rv.d.tt -yscroll ".rv.d.sb set" -height $tyh
bind      .rv.d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .rv.d.tt}
pack configure .rv.d.sb .rv.d.tt -in .rv.d -side right -fill y
.rv.d.tt configure -state disabled

}
