# call of the spelling check program  $spcmd  for the file  $efile$spsuff
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc spellcheck {f austext} {

  upvar 1 $austext a

  global  vv spcmd splang spoptions spselect efile spsuff main_file

  if { $spoptions != "" } {
    # Substitution von $HOME (und ggfs. weiteren $-Variablen im Optionenstring)
    global env
    set HOME $env(HOME)
    set spoptions "[eval concat $spoptions]"
  }

  writescr0 $f ""
  set a ""

  if { "$efile" == "" } {set a "${a}***** $vv(ea2) \n$vv(ea3)\n"; bell; return}

  writescr0 $f "[datime] $vv(re1) \"$efile$spsuff\"\n"


  if { [file exists $efile$spsuff] } { 


    if { $spcmd == "spell" } {

      # translate, as <spell> is sensitive to special characters!

      writescr $f "$vv(re2)\n"

       # Umlaute -> ae oe ue Ae Oe Ue ss
        set message ""
        eval set res [catch "exec umcod -ascii7 $efile$spsuff $efile$spsuff-sp1" message]
        if {"$res"!="0"} {writescr0 $f "$message\n$vv(re3) $res\n\n"; bell}
       # replace all "non-7Bit-Alpha-Num-characters"  by blanks
        ######     12 chars    6 chars     6 chars     4 chars
        ######    [\041-\057] [\072-\077] [\133-\140] [\173-\176]
        exec tr {"[\041-\057][\072-\077][\133-\140]"} \
                {"                        "}      < $efile$spsuff-sp1 > $efile$spsuff-sp
        unlink -nocomplain $efile$spsuff-sp1
        exec tr {"[\173-\176]\344\366\374\304\326\334\337[0-9]"} \
                {"    aouAOUs          "}         < $efile$spsuff-sp > $efile$spsuff-spl
        unlink -nocomplain $efile$spsuff-sp


      set zusatzwb ""
      if { [file exists $main_file.wb]}  {set zusatzwb "+$main_file.wb"}
      if { [file exists $efile.wb]}       {set zusatzwb "+$efile.wb"}
  

      writescr $f  "$vv(re4)\n"
      eval mkCmd_wait $f $spcmd [list "$spoptions $zusatzwb $efile$spsuff-spl"]
      unlink -nocomplain $efile$spsuff-spl

      # words not found in the dictionary --> $efile.wb-erg
      if {"$res"=="0"} {write_file $efile.wb-erg $message}
      set a "${a}$vv(re5) \"$efile.wb-erg\".\n"


    } elseif { $spcmd == "ispell" } {

      eval set res [catch "exec xterm -e $spcmd $spoptions $efile$spsuff" message]
      set a "${a}\n$vv(re6)\n\n"
      if {"$res" != "0"} { set a "${a}$vv(re7) $spcmd: $res\n"; bell }

    } else {

      set a "${a}\n***** $vv(re8) $spcmd $vv(re9)\n"

    }

  } else {                                 # file doesn't exist!

    set a "${a}\n\n***** $vv(aus5)   $efile$spsuff   $vv(ea4)\n"
    bell

  }

}
