# Voreinstellungsmen fr Syntaxprfung
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc svanzeigen {s1} {
  global vv sytext syntax syoptions
  writescr0 .sv.d.tt "$s1\n\n"    "$sytext\n\n" \
                     " $vv(ausg2)  $syntax\n" \
                     " $vv(ausg3)  $syoptions\n\n"
}

proc sv  {} {

global  vv hlp_dir syntax sytext syoptions svsep


toplevel .sv
wm title .sv "$vv(svvor)"
wm minsize .sv 0 0


set tyh 18


# Bereich a fuer erste Buttons

frame .sv.a -relief raised -borderwidth 1
pack configure .sv.a -in .sv -pady 10 -anchor w
 
button .sv.a.e -text "$vv(ae)"
bind   .sv.a.e <Button-3> {+ cat_file0 "${hlp_dir}z_vstquit.hlp" .sv.d.tt}
button .sv.a.h -text "$vv(ah)" 
bind   .sv.a.h <Any-Button> {+ cat_file0 "${hlp_dir}sv_h.hlp" .sv.d.tt}
button .sv.a.l -text "$vv(al)" -command {clearscr .sv.d.tt}
bind   .sv.a.l <Button-3> {+ cat_file0 "${hlp_dir}z_loeschetf.hlp" .sv.d.tt}
button .sv.a.g -text "$vv(ag)" -command {
  set foid [open_vst default.vst]
  while { [getscl $foid ein] > 0 } {
   mtest $ein 19 syntax
   mtest $ein 19 sytext
   mtest $ein 19 syoptions
  }
  close $foid
  if { $syntax == "" } {
    .sv.b.ad configure -text "$vv(svbad1)" 
  } else {
    .sv.b.ad configure -text "$vv(svbad2)  $syntax    $sytext"
  }
  .sv.cb delete 0 end
  .sv.cb insert end "$syoptions"
  svanzeigen "$vv(ausg1)"
}
bind   .sv.a.g <Button-3> {+ cat_file0 "${hlp_dir}sv_grund.hlp" .sv.d.tt}
pack configure .sv.a.e .sv.a.h .sv.a.l .sv.a.g -in .sv.a -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame .sv.bv
pack configure .sv.bv -in .sv -pady 13 -anchor w

label  .sv.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
bind   .sv.bv.dv <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .sv.d.tt}
button .sv.bv.va -text "$vv(bvva)" -command {svanzeigen "$vv(aus0)"}
bind   .sv.bv.va <Button-3> {+ cat_file0 "${hlp_dir}z_voreinst1.hlp" .sv.d.tt}
pack configure .sv.bv.dv .sv.bv.va -in .sv.bv -side left


# Bereich b fuer Anzeigen   

frame .sv.b
pack configure .sv.b -in .sv -anchor w

label .sv.b.ad -width 90 -anchor w
if { $syntax == "" } {
  .sv.b.ad configure -text "$vv(svbad1)" 
} else {
  .sv.b.ad configure -text "$vv(svbad2)  $syntax    $sytext"
}

pack configure .sv.b.ad -in .sv.b -anchor w

bind .sv.b.ad <Button-3> {+ cat_file0 "${hlp_dir}sv_anzeig.hlp" .sv.d.tt}


# Bereich c fuer Syntax-Prfprogramm-Auswahl

frame .sv.c
pack configure .sv.c -in .sv -anchor w

label .sv.c.l -text "$vv(svcl)" -anchor w -pady 30
bind  .sv.c.l <Button-3> {+ cat_file0 "${hlp_dir}sv_progsel.hlp" .sv.d.tt}
frame .sv.c.fr -relief raised -borderwidth 2
pack configure .sv.c.l  .sv.c.fr -in .sv.c -side left

scrollbar .sv.c.fr.sb -command ".sv.c.fr.li yview"
bind      .sv.c.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}sv_progsel.hlp" .sv.d.tt}
listbox   .sv.c.fr.li -yscroll ".sv.c.fr.sb set" -geometry 55x10
set svsep [fillboxsep .sv.c.fr.li syntax.vst]
bind      .sv.c.fr.li <Button-3> {+ cat_file0 "${hlp_dir}sv_progsel.hlp" .sv.d.tt}
pack configure .sv.c.fr.sb .sv.c.fr.li -in .sv.c.fr -side right -fill y

# bind fuer Syntax-Prfprogramm-Selektionen
bind    .sv.c.fr.li <Triple-Button-1> { }
bind    .sv.c.fr.li <Double-Button-1> {
  global svsep
  foreach i [selection get] {set ii $i}
  set sytext     [getvalue $ii 0 $svsep]
  set syntax     [getvalue $ii 1 $svsep]
  set syoptions [getvalue $ii 2 $svsep]
  .sv.cb delete 0 end 
  .sv.cb insert end "$syoptions"
  .sv.b.ad configure -text "Syntax-Prfprogramm: $syntax    $sytext"
  svanzeigen "$vv(sv1)"
  selection clear .sv.c.fr.li
}


# Ausgabe und Veraendern des Optionen-Strings

label .sv.ca  -anchor w -text "$vv(svca)"
bind  .sv.ca <Button-3> {+ cat_file0 "${hlp_dir}sv_optedi.hlp" .sv.d.tt}
pack configure .sv.ca -in .sv -anchor sw

entry .sv.cb -width 80 -relief sunken
      .sv.cb delete 0 end 
      .sv.cb insert end "$syoptions"
bind  .sv.cb <Button-3> {+ cat_file0 "${hlp_dir}sv_optedi.hlp" .sv.d.tt}
bind  .sv.cb <Return> {
  set syoptions  [.sv.cb get] 
  writescr0 .sv.d.tt  "$vv(aus4)\n $syoptions\n"
  focus none
}
pack configure .sv.cb -in .sv -anchor nw
focus none


# Bereich d fuer Hilfe-Ausgaben

frame .sv.d -relief raised -borderwidth 2
pack configure .sv.d -in .sv -anchor sw -pady 6

scrollbar .sv.d.sb -command ".sv.d.tt yview"
bind      .sv.d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .sv.d.tt}
text      .sv.d.tt -yscroll ".sv.d.sb set" -height $tyh
bind      .sv.d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .sv.d.tt}
pack configure .sv.d.sb .sv.d.tt -in .sv.d -side right -fill y
.sv.d.tt configure -state disabled

}
