# Voreinstellungsmen fr TeX 
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc tvanzeigen {s1} {
  global  vv texfmt texmem texmtext texmax texsuffix dir efile esuff
  global  main_file tsuff
  writescr0 .tv.d.tt "$s1\n\n"  " TeX-$vv(tv2) $texfmt\n" \
                     [alternative $texmem \
                       "    $vv(tv3) $texmtext\n" \
                       "    $vv(tv3) $texmtext   <$texmem>\n"] \
                     "    $vv(tv4) $texmax\n" \
                     " $vv(tv6) $texsuffix\n\n" \
                     " $vv(tv5) $dir\n" \
                     [alternative $efile \
                       " $vv(bad1)\n" \
                       " $vv(bad2) $efile$esuff\n"] \
                     [alternative $main_file \
                       " $vv(tvbad1) $texfmt $vv(tvbad3)\n" \
                       " $vv(tvbad2) $texfmt $vv(tvbad3): $main_file$tsuff\n\n"]
}


proc tvanzeige {} {
  global  vv main_file texfmt tsuff
  if {$main_file == ""} {
    .tv.b.ad configure -text "$vv(tvbad1) $texfmt $vv(tvbad3)" 
  } else {
    .tv.b.ad configure -text "$vv(tvbad2) $texfmt $vv(tvbad3): $main_file$tsuff"
  }
}


proc tv  {} {

global  vv hlp_dir texsuffix liste tvsep1 tvsep2
global  texfmt main_file efile texmem texmtext texmax dir esuff tsuff env


toplevel .tv
wm title .tv "$vv(tvvor)"
wm minsize .tv 0 0

set tyh 16
set dir [pwd]


proc tfuellen {} {
  global texsuffix tdatsort sub

  set subalt $sub
  .tv.c.2.d.fr.li delete 0 end
  if { $tdatsort == "0" } {set liste [exec ls]} else {set liste [exec ls -t]}

  foreach i $liste {
      if { [file isfile $i] } {
         if {[string match "*$texsuffix" $i]} {.tv.c.2.d.fr.li insert end $i}
      }
  }
  lock
  set sub $subalt
}


# Bereich a fuer erste Buttons
frame .tv.a -relief raised -borderwidth 1
pack configure .tv.a -in .tv -pady 10 -anchor w
 
button .tv.a.e -text "$vv(ae)"
bind   .tv.a.e <Button-3>   {cat_file0 "${hlp_dir}z_vstquit.hlp" .tv.d.tt}
button .tv.a.h -text "$vv(ah)" 
bind   .tv.a.h <Any-Button> {cat_file0 "${hlp_dir}tv_h.hlp" .tv.d.tt}
button .tv.a.l -text "$vv(al)" -command {clearscr .tv.d.tt}
bind   .tv.a.l <Button-3>   {cat_file0 "${hlp_dir}z_loeschetf.hlp" .tv.d.tt}
button .tv.a.g -text "$vv(ag)" -command {
  set texfmt "latex";    set texmem  "";    set texmtext "";    set texmax "1"
  set oldsuff $texsuffix
  set foid [open_vst default.vst]
  while {[getscl $foid ein] > 0} {
    mtest $ein 19 texfmt
    mtest $ein 19 texmem
    mtest $ein 19 texmtext
    mtest $ein 19 texmax
    mtest $ein 19 texsuffix
  }
  close $foid
  if {$oldsuff != $texsuffix} {set main_file "";  set efile "";   set tsuff ""}
  .tv.c.2.d.f.l configure -text "$vv(c2al) ($texsuffix): "
  .tv.c.2.n.l configure -text "$vv(c2nl) ($texsuffix): "
  .tv.c.2.d.fr.li delete 0 end
  tfuellen;     tvanzeige;    tvanzeigen "$vv(ausg1)"
}
bind   .tv.a.g <Button-3>   {cat_file0 "${hlp_dir}tv_grund.hlp" .tv.d.tt}

pack configure .tv.a.e .tv.a.h .tv.a.l .tv.a.g -in .tv.a -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame .tv.bv
pack configure .tv.bv -in .tv -pady 13 -anchor w

label  .tv.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
bind   .tv.bv.dv <Button-3> {cat_file0 "${hlp_dir}z_voreinst1.hlp" .tv.d.tt}
button .tv.bv.va -text "$vv(bvva)" -command {tvanzeigen "$vv(aus0)"}
bind   .tv.bv.va <Button-3> {cat_file0 "${hlp_dir}z_voreinst1.hlp" .tv.d.tt}

pack configure .tv.bv.dv .tv.bv.va -in .tv.bv -side left


# Bereich b fuer Anzeigen   

frame .tv.b
bind  .tv.b <Button-3> {cat_file0 "${hlp_dir}tv_anzeig.hlp" .tv.d.tt}
pack configure .tv.b -in .tv -anchor w

label .tv.b.ad -width 70 -anchor w
bind  .tv.b.ad <Button-3> {cat_file0 "${hlp_dir}tv_anzeig.hlp" .tv.d.tt}
label .tv.b.dv -text "$vv(bdv)  $dir" -width 90 -anchor w
bind  .tv.b.dv <Button-3> {cat_file0 "${hlp_dir}tv_anzeig.hlp" .tv.d.tt}

pack configure .tv.b.ad .tv.b.dv -in .tv.b -anchor w
tvanzeige


# Bereich c fuer Wechsel   

frame .tv.c
pack configure .tv.c -in .tv -anchor w

frame .tv.c.1
frame .tv.c.2
pack configure .tv.c.1  -in .tv.c -side left -fill x
pack configure .tv.c.2 -in .tv.c -side right -fill x

# Bereich c1 (Directory-Liste, Format, Speichergre, max.TeX-Durchlufe)

frame .tv.c.1.d
frame .tv.c.1.f
frame .tv.c.1.s
frame .tv.c.1.m
pack configure .tv.c.1.d .tv.c.1.f .tv.c.1.s .tv.c.1.m -in .tv.c.1 -anchor e -pady 3


label .tv.c.1.d.l -text "$vv(tvc1dl) "
bind  .tv.c.1.d.l <Button-3> {cat_file0 "${hlp_dir}tv_dirsel.hlp" .tv.d.tt}
frame .tv.c.1.d.fr -relief raised -borderwidth 2 
pack configure .tv.c.1.d.l .tv.c.1.d.fr -in .tv.c.1.d -side left -anchor w
scrollbar .tv.c.1.d.fr.sb -command ".tv.c.1.d.fr.li yview"
bind      .tv.c.1.d.fr.sb <Button-3> {cat_file0 "${hlp_dir}tv_dirsel.hlp" .tv.d.tt}
listbox   .tv.c.1.d.fr.li -yscroll ".tv.c.1.d.fr.sb set" -geometry 20x10
bind      .tv.c.1.d.fr.li <Button-3> {cat_file0 "${hlp_dir}tv_dirsel.hlp" .tv.d.tt}
pack configure .tv.c.1.d.fr.sb .tv.c.1.d.fr.li -in .tv.c.1.d.fr -side right -fill y


label .tv.c.1.f.l -text "$vv(tvc1fl) "
bind  .tv.c.1.f.l <Button-3> {cat_file0 "${hlp_dir}tv_fmtsel.hlp" .tv.d.tt}
frame .tv.c.1.f.fr -relief raised -borderwidth 2    
pack configure .tv.c.1.f.l .tv.c.1.f.fr -in .tv.c.1.f -side left 
scrollbar .tv.c.1.f.fr.sb -command ".tv.c.1.f.fr.li yview"
bind      .tv.c.1.f.fr.sb <Button-3> {cat_file0 "${hlp_dir}tv_fmtsel.hlp" .tv.d.tt}
listbox   .tv.c.1.f.fr.li -yscroll ".tv.c.1.f.fr.sb set" -geometry 20x3
set tvsep2 [fillboxsep  .tv.c.1.f.fr.li texfmt.vst]
bind      .tv.c.1.f.fr.li <Button-3> {cat_file0 "${hlp_dir}tv_fmtsel.hlp" .tv.d.tt}
bind      .tv.c.1.f.fr.li <Triple-Button-1> { }
bind      .tv.c.1.f.fr.li <Double-Button-1> {
  global tvsep2
  foreach i [selection get] {set texfmt [getvalue $i 1 $tvsep2]}
  tvanzeige
  writescr0 .tv.d.tt  "$vv(tvt1) $vv(tv2) $texfmt\n"
  selection clear .tv.c.1.f.fr.li
}
pack configure .tv.c.1.f.fr.sb .tv.c.1.f.fr.li -in .tv.c.1.f.fr -side right -fill y


label   .tv.c.1.s.l -text "$vv(tvc1sl) "
bind    .tv.c.1.s.l <Button-3> {cat_file0 "${hlp_dir}tv_speich.hlp" .tv.d.tt}
listbox .tv.c.1.s.li -relief raised -geometry 22x2
set tvsep1 [fillboxsep .tv.c.1.s.li texsize.vst]
bind    .tv.c.1.s.li <Button-3> {cat_file0 "${hlp_dir}tv_speich.hlp" .tv.d.tt}
bind    .tv.c.1.s.li <Triple-Button-1> { }
bind    .tv.c.1.s.li <Double-Button-1> {
  global tvsep1
  foreach i [selection get] {
    set texmtext   [getvalue $i 0 $tvsep1]
    set texmem [getvalue $i 1 $tvsep1]
  }
  selection clear .tv.c.1.s.li
  if { $texmem == "" } {
    writescr0 .tv.d.tt "$vv(tvt1) $vv(tv3) $texmtext\n"
  } else {
    writescr0 .tv.d.tt "$vv(tvt1) $vv(tv3) $texmtext  <$texmem>\n"
  }
}
pack configure .tv.c.1.s.l .tv.c.1.s.li -in .tv.c.1.s -side left 


label   .tv.c.1.m.l -text "$vv(tv4) "
bind    .tv.c.1.m.l <Button-3> {cat_file0 "${hlp_dir}tv_dlz.hlp"    .tv.d.tt}
listbox .tv.c.1.m.li -relief raised -geometry 22x4 
bind    .tv.c.1.m.li <Button-3> {cat_file0 "${hlp_dir}tv_dlz.hlp" .tv.d.tt}
bind    .tv.c.1.m.li <Triple-Button-1> { }
bind    .tv.c.1.m.li <Double-Button-1> {
  foreach i [selection get] {set texmax $i}
  writescr0 .tv.d.tt "$vv(tvt1) $vv(tv4) $texmax\n"
  selection clear .tv.c.1.m.li
}
.tv.c.1.m.li insert end "1" "2" "3" "4"
pack configure .tv.c.1.m.l .tv.c.1.m.li -in .tv.c.1.m -side left 


# Bereich c2 (Suffix- und Datei-Wechsel)

# c2s Suffixwechsel

frame .tv.c.2.s
frame .tv.c.2.d
frame .tv.c.2.n
pack configure .tv.c.2.s .tv.c.2.d .tv.c.2.n -in .tv.c.2 -anchor e -pady 5

label .tv.c.2.s.l -text "$vv(tvc2sl) " -anchor e -width 19
bind  .tv.c.2.s.l <Button-3> {cat_file0 "${hlp_dir}tv_suffsel.hlp" .tv.d.tt}
frame .tv.c.2.s.fr -relief raised -borderwidth 2
pack configure .tv.c.2.s.l .tv.c.2.s.fr -in .tv.c.2.s -side left

scrollbar .tv.c.2.s.fr.sb -command ".tv.c.2.s.fr.li yview"
listbox .tv.c.2.s.fr.li -yscroll ".tv.c.2.s.fr.sb set" -geometry 20x3
bind .tv.c.2.s.fr.sb <Button-3> {cat_file0 "${hlp_dir}tv_suffsel.hlp" .tv.d.tt}
bind .tv.c.2.s.fr.li <Button-3> {cat_file0 "${hlp_dir}tv_suffsel.hlp" .tv.d.tt}
pack configure .tv.c.2.s.fr.sb .tv.c.2.s.fr.li -in .tv.c.2.s.fr -side right -fill y
fillbox  .tv.c.2.s.fr.li texsuffix.vst

bind .tv.c.2.s.fr.li <Double-Button-1> {
  set os $texsuffix
  set texsuffix [selection get]
  if {$os != $texsuffix} {set main_file "";set efile "";set tsuff "";tvanzeige}
  .tv.c.2.d.f.l configure -text "$vv(c2al) ($texsuffix): "
  .tv.c.2.n.l configure -text "$vv(c2nl) ($texsuffix): "
  .tv.c.2.d.fr.li delete 0 end
  tfuellen
  writescr0 .tv.d.tt "$vv(evt3): $texsuffix\n\n"
}


#c2d/c2n Dateiwechsel

frame .tv.c.2.d.f
frame .tv.c.2.d.fr -relief raised -borderwidth 2
pack configure .tv.c.2.d.f .tv.c.2.d.fr -in .tv.c.2.d -side left -padx 2
label .tv.c.2.d.f.l -text "$vv(c2al) ($texsuffix): " -anchor c -width 18
radiobutton .tv.c.2.d.f.t -text "$vv(c2aft)" -variable tdatsort -value "0" \
                          -width 12 -anchor w -command {
  tfuellen
}
radiobutton .tv.c.2.d.f.tt -text "$vv(c2aftt)" -variable tdatsort -value "1" \
                           -width 12 -anchor w -command {
  tfuellen
}

pack configure .tv.c.2.d.f.l .tv.c.2.d.f.t .tv.c.2.d.f.tt -in .tv.c.2.d.f -anchor c

bind  .tv.c.2.d.f.l <Button-3> {cat_file0 "${hlp_dir}tv_filesel.hlp" .tv.d.tt}
bind  .tv.c.2.d.f.t <Button-3> {cat_file0 "${hlp_dir}tv_filesel.hlp" .tv.d.tt}
bind  .tv.c.2.d.f.tt <Button-3> {cat_file0 "${hlp_dir}tv_filesel.hlp" .tv.d.tt}

scrollbar .tv.c.2.d.fr.sb -command ".tv.c.2.d.fr.li yview"
listbox .tv.c.2.d.fr.li -yscroll ".tv.c.2.d.fr.sb set" -geometry 20x15
bind .tv.c.2.d.fr.sb <Button-3> {cat_file0 "${hlp_dir}tv_filesel.hlp" .tv.d.tt}
bind .tv.c.2.d.fr.li <Button-3> {cat_file0 "${hlp_dir}tv_filesel.hlp" .tv.d.tt}
pack configure .tv.c.2.d.fr.sb .tv.c.2.d.fr.li -in .tv.c.2.d.fr -side right -fill y

label .tv.c.2.n.l -text "$vv(c2nl) ($texsuffix): " -anchor e
bind  .tv.c.2.n.l <Button-3> {cat_file0 "${hlp_dir}tv_fileedi.hlp" .tv.d.tt}
entry .tv.c.2.n.i -width 22 -relief sunken
bind  .tv.c.2.n.i <Button-3> {cat_file0 "${hlp_dir}tv_fileedi.hlp" .tv.d.tt}
.tv.c.2.n.i delete 0 end
pack configure .tv.c.2.n.l .tv.c.2.n.i -in .tv.c.2.n -side left


# Directory-Liste 

.tv.c.1.d.fr.li insert end "\$HOME" ".."
foreach i [lsort [glob -nocomplain -- *]] {
    if [file isdirectory $i] {
       .tv.c.1.d.fr.li insert end $i
    }
}

# Datei-Liste fllen

tfuellen

# bind fuer Directory-Selektion

focus .tv.c.1.d.fr.li
bind  .tv.c.1.d.fr.li <Triple-Button-1> { }
bind  .tv.c.1.d.fr.li <Double-Button-1> {
  .tv.c.2.n.i delete 0 end
  foreach i [selection get] {
    set dir $i
      if { $dir == "\$HOME" } {set dir $env(HOME)}
    if { [catch {cd $dir} errormessage] != 0} {
      bell
      writescr0 .tv.d.tt "$vv(tvt2)\n$vv(tvt3)\n$errormessage\n"
    } else {
      writescr0 .tv.d.tt "$vv(tvt4) [pwd]\n\n" 
    }
    set dir [pwd]
    .tv.b.dv configure -text "$vv(bdv)  $dir"
    .tv.c.1.d.fr.li delete 0 end
    .tv.c.2.d.fr.li delete 0 end
    set main_file ""
    set efile ""
    if { [lsearch $liste .c.1.ed] < 0 } {set liste [linsert $liste 1 .c.1.ed]}
    if { [lsearch $liste .c.1.pf] < 0 } {set liste [linsert $liste 1 .c.1.pf]}
    tvanzeige   
    selection clear .tv.c.1.d.fr.li
    .tv.c.1.d.fr.li insert end "\$HOME" ".."
    foreach k [lsort [glob -nocomplain -- *]] {
      if [file isdirectory $k] {
        .tv.c.1.d.fr.li insert end $k
      }
    }
  }
  tfuellen

}


# bind fuer Datei-Selektion

focus .tv.c.2.d.fr.li
bind  .tv.c.2.d.fr.li <Triple-Button-1> { }
bind  .tv.c.2.d.fr.li <Double-Button-1> {
  .tv.c.2.n.i delete 0 end
  foreach ii [catch {selection get} i] {
    if { $ii == 0 } {
    regsub "$texsuffix\$" $i "" main_file
    set tsuff "$texsuffix"
    tvanzeige
    set efile $main_file
    set esuff $tsuff
    if { [lsearch $liste .c.1.ed] < 0 } {set liste [linsert $liste 1 .c.1.ed]}
    if { [lsearch $liste .c.1.pf] < 0 } {set liste [linsert $liste 1 .c.1.pf]}
    writescr0 .tv.d.tt "$vv(aus2) $main_file$tsuff\n\n" 
  }
  selection clear .tv.c.2.d.fr.li
}
}

# Eingabe eines neuen Dateinamens

focus none
bind  .tv.c.2.n.i <Return> {
  set datvar [string trim [.tv.c.2.n.i get]]
  regsub "$texsuffix$" $datvar "" hvar
  if { "$hvar$texsuffix" == "$datvar"} {set datvar "$hvar"}
  set main_file [string trim $datvar]
  if {"$main_file" == ""} {set tsuff ""} else {set tsuff $texsuffix}
  writescr0 .tv.d.tt "$vv(aus3) $main_file$tsuff\n\n" 
  testfilename $main_file .tv.d.tt $tsuff
  tvanzeige
  set efile $main_file
  set esuff $tsuff
  if { [lsearch $liste .c.1.ed] < 0 } {set liste [linsert $liste 1 .c.1.ed]}
  if { [lsearch $liste .c.1.pf] < 0 } {set liste [linsert $liste 1 .c.1.pf]}
  .tv.c.2.n.i delete 0 end 
  focus none
}
bind .tv.c.2.n.i <Button-2> {
  writescr0 .tv.d.tt "$vv(aus1)  $main_file$tsuff\n"
  .tv.c.2.n.i delete 0 end
  .tv.c.2.n.i insert end $main_file$tsuff
  focus none
}


# Bereich d fuer Hilfe-Ausgaben

frame .tv.d -relief raised -borderwidth 2
pack configure .tv.d -in .tv -anchor sw -pady 6

scrollbar .tv.d.sb -command ".tv.d.tt yview"
bind      .tv.d.sb <Button-3>  {cat_file0 "${hlp_dir}z_textfeld.hlp" .tv.d.tt}
text      .tv.d.tt -yscroll ".tv.d.sb set" -height $tyh
bind      .tv.d.tt  <Button-3> {cat_file0 "${hlp_dir}z_textfeld.hlp" .tv.d.tt}
pack configure .tv.d.sb .tv.d.tt -in .tv.d -side right -fill y
.tv.d.tt configure -state disabled

}
