/* Umkodier-Programm                                                    */
/*                                                                      */
/* Copyright (C) 1994  G. Lamprecht, R. Weibezahn; LRW c/o Uni Bremen   */

#include <stdio.h>
#include <string.h>
#ifndef AIX
  #include <sys/fcntl.h>
#else
  #include <fcntl.h>
  #include <unistd.h>
#endif
#define PMODE 0666
#define BUFLEN_E 32768
#define BUFLEN_A 32768

char buffer_a[BUFLEN_A];
int  cnt_a=0;
int  filed1, filed2;
char *ptr_a;
int  anznl=0, tpos=0, anzz=0;

extern void nl();     /* Anzahl der newlines zhlen, alle 100 newlines "." ausgeben */
extern void wchar();  /* 1 Zeichen in Puffer stellen */
extern void wchar0(); /*Ausgabepuffer leeren */
extern int  gchar();  /* 1 Zeichen aus Puffer holen */
extern void ibmiso(); /* Konvertierung ISO <---> IBM */

main (Anz,Vekt)
int   Anz;
char  *Vekt[]; /* [1]=Umcodierungsart; [2]=Eingabedatei, [3]=Ausgabedatei */

{
  extern int errno;
  int i, rret, ivar;
  unsigned char ch;
  int  soz=0, suz=0;
  int errorparam=0;
  
  if ( Anz < 3 ) errorparam++;
  if ( Anz==3 && (strcmp(Vekt[1],"-analyse")!=0) ) { errorparam++; } 
  if ( errorparam != 0 ) {  
    printf("Aufruf: umcod [ -Umwandlungsform ] Herkunftsdatei Zieldatei\n"); 
    printf("                -u2t      Umlaute --> TeX-Konvention\n");         
    printf("                -u2gt     Umlaute --> german-TeX-Konvention\n");  
    printf("                -tgt2u    TeX- & german-TeX-Konvention --> Umlaute\n");  
    printf("                -d2u      DOS --> Unix\n");                       
    printf("                -u2d      Unix --> DOS\n");                       
    printf("                -ibm2iso  8 Bit IBM-PC-Code -->  8 Bit-ISO-Code\n");
    printf("                -iso2ibm  8 Bit-ISO-Code --> 8 Bit IBM-PC-Code\n");
    printf("                -tabexp   Tabulator durch Leerzeichen expandieren\n");
    printf("                -ascii7   Umlaute --> ae ou ue Ae Oe Ue ss\n");
    printf("                -analyse  Datei-Analyse\n");                       
    exit(1);                                                                 
  }                                                                           
  /* Autoren: R. Weibezahn, G. Lamprecht; LRW c/o Uni Bremen, Tel. 0421-218-3532 */
  printf("\numcod  LRW(Wz.) V.06/30.08.93-SOLARIS2.1");

  if ( (Anz==3) || (strcmp(Vekt[1],"-analyse")==0) ) {
    printf("\n%s mit Option: %s",Vekt[2],Vekt[1]);
  }
  else {
    printf("\n%s --> %s mit Option: %s",Vekt[2],Vekt[3],Vekt[1]);
  }

  ptr_a=buffer_a;
  anznl=0;
  filed1=open(Vekt[2],O_RDONLY);     /* filed1 >= 0 : OK, sonst Fehler */
  filed2=creat(Vekt[3],PMODE);

  if ((int)filed1 <= 0) {printf("\nEingabedatei nicht vorhanden\n");exit(1);}

  
  if ( strcmp(Vekt[1],"-u2t") == 0 ) { /* Umcodieren f. TeX-Konvention */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,
	
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};
    
    rret=gchar(&ch);
    while (rret > 0) {             /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("a");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("o");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("u");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("A");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("O");suz++;break;
	case (unsigned char) '' : wchar("\\");wchar("\"");wchar("U");suz++;break;
	case (unsigned char) '' : wchar("{"); wchar("\\");wchar("s");
	                           wchar("s"); wchar("}"); suz++; break;
	case (unsigned char) '\n': wchar("\n");nl(); break;
	default                  : wchar(&ch); soz++; break;
	}
      }
      rret=gchar(&ch);
    }
  }
  
  else if ( strcmp(Vekt[1],"-u2gt") == 0 ) {/* Umcodieren f. german-LaTeX-Konvention */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,
	
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
	1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};
    
    rret=gchar(&ch);
    while (rret > 0) {             /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '' : wchar("\""); wchar("a"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("o"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("u"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("A"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("O"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("U"); suz++; break;
	case (unsigned char) '' : wchar("\""); wchar("s"); suz++; break;
	case (unsigned char) '\n': wchar("\n"); nl(); break;
	default                  : wchar(&ch); soz++; break;
	}
      }
      rret=gchar(&ch);
    }
  }

  else if ( strcmp(Vekt[1],"-tgt2u") == 0 ) { /* Rckkodieren aus TeX-Konvention */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,1,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,1,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,1,0,0,0,1,
	
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};
    
    rret=gchar(&ch);
    while (rret > 0) {             /*     printf("ch=%c(%d) ",ch,ch);     */
     Zeichen_gelesen_in_ch:
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	  
	case (unsigned char) '\\'  :  /* liegt \"a \"o \"u \"A \"O \"U  vor? */
	                              /* auf Zeilenumbruch ("\\" in Datei) achten! */
	  if (gchar(&ch)==0) {wchar("\\");break;}
	  if (ch=='\\') {wchar("\\");wchar("\\");break;}     /* Zeilenumbruch! */
	  if (ch!='"')  {wchar("\\");wchar(&ch); break;}     /* kein Umlaut! */
	  if (gchar(&ch)==0) {wchar("\\");wchar(&ch);break;} 
          switch (ch) {      /* liegt \"a \"o \"u \"A \"O \"U \"s  vor? */
	  case (unsigned char) 'a' : wchar("");suz++; break;   /* \"a */
	  case (unsigned char) 'o' : wchar("");suz++; break;   /* \"o */
	  case (unsigned char) 'u' : wchar("");suz++; break;   /* \"u */
	  case (unsigned char) 'A' : wchar("");suz++; break;   /* \"A */
	  case (unsigned char) 'O' : wchar("");suz++; break;   /* \"O */
	  case (unsigned char) 'U' : wchar("");suz++; break;   /* \"U */
	  default                  : wchar("\\");wchar("\"");wchar(&ch); break;
          }
	  break;

	case (unsigned char) '{'  :  /* liegt {\ss}  {\"a  .. {\"U  {"a .. {"U  vor? */
	  if (gchar(&ch)==0) {wchar("{");break;}
	  if (ch=='{') {wchar("{");goto Zeichen_gelesen_in_ch;} /* Doppelklammern! */
	  if ( (ch!='\\') && (ch!='\"') ) {wchar("{");wchar(&ch); break;}
	  if (ch=='\"') {
	    if (gchar(&ch)==0) {wchar("{");wchar("\\");wchar("\"");break;}
            switch (ch) {      /* liegt {"a {"o {"u {"A {"O {"U {"s  vor? */
	    case (unsigned char) 'a' : wchar("{");wchar("");suz++; break; /* {"a */
	    case (unsigned char) 'o' : wchar("{");wchar("");suz++; break; /* {"o */
	    case (unsigned char) 'u' : wchar("{");wchar("");suz++; break; /* {"u */
	    case (unsigned char) 'A' : wchar("{");wchar("");suz++; break; /* {"A */
	    case (unsigned char) 'O' : wchar("{");wchar("");suz++; break; /* {"O */
	    case (unsigned char) 'U' : wchar("{");wchar("");suz++; break; /* {"U */
	    case (unsigned char) 's' : wchar("{");wchar("");suz++; break; /* {"s */
	    default                  : break;
	    }
	    break;
	  }
	  if (gchar(&ch)==0) {wchar("{");wchar("\\");break;}
	  if ( (ch!='s') && (ch!='\"') )  {wchar("{");wchar("\\");wchar(&ch);break;}
	  if (ch=='\"') {
	    if (gchar(&ch)==0) {wchar("{");wchar("\\");wchar("\"");break;}
            switch (ch) {      /* liegt {\"a {\"o {\"u {\"A {\"O {\"U {\"s  vor? */
	    case (unsigned char) 'a' : wchar("{");wchar("");suz++; break; /* {\"a */
	    case (unsigned char) 'o' : wchar("{");wchar("");suz++; break; /* {\"o */
	    case (unsigned char) 'u' : wchar("{");wchar("");suz++; break; /* {\"u */
	    case (unsigned char) 'A' : wchar("{");wchar("");suz++; break; /* {\"A */
	    case (unsigned char) 'O' : wchar("{");wchar("");suz++; break; /* {\"O */
	    case (unsigned char) 'U' : wchar("{");wchar("");suz++; break; /* {\"U */
	    default                  : break;
	    }
	    break;
	  }
	  if (gchar(&ch)==0) {wchar("{");wchar("\\");wchar("s");break;}
	  if (ch!='s')  {wchar("{");wchar("\\");wchar("s");wchar(&ch);break;} 
	  if (gchar(&ch)==0) {wchar("{");wchar("\\");wchar("s");wchar("s");break;}
	  if (ch!='}')  {wchar("{");wchar("\\");wchar("s");wchar("s");wchar(&ch);break;}
	  wchar("");suz++;                                       /* {\ss} */
	  break;

        case (unsigned char) '"'  :        /* liegt "a "o "u "A "O "U "s  vor? */
	  if (gchar(&ch)==0) {wchar("\"");break;}
          switch (ch) {
	    case (unsigned char) 'a' : wchar("");suz++; break;    /* "a */
	    case (unsigned char) 'o' : wchar("");suz++; break;    /* "o */
	    case (unsigned char) 'u' : wchar("");suz++; break;    /* "u */
	    case (unsigned char) 'A' : wchar("");suz++; break;    /* "A */
	    case (unsigned char) 'O' : wchar("");suz++; break;    /* "O */
	    case (unsigned char) 'U' : wchar("");suz++; break;    /* "U */
	    case (unsigned char) 's' : wchar("");suz++; break;    /* "s */
	    default                  : wchar("\"");wchar(&ch); break;
          }
	  break;

	case (unsigned char) '\n'  : wchar("\n"); nl(); break;

	default                    : wchar(&ch); soz++; break;

	}
      }
      rret=gchar(&ch);
    }
  }
  
  else if ( strcmp(Vekt[1],"-u2d") == 0 ) {     /* Umcodieren Unix -> DOS */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,
	
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};

    rret=gchar(&ch);
    while (rret > 0) {            /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '\r'  : break;  
	/*case (unsigned char) '\032': break;  Unix: Substitute Char.; DOS: Dateiende*/
	case (unsigned char) '\n'  : wchar("\r"); wchar("\n"); nl(); break;
	default                    : wchar(&ch); soz++; break;
	}
      }
      rret=gchar(&ch);
    }
  }

  else if ( strcmp(Vekt[1],"-d2u") == 0 ) {       /* Umcodieren DOS -> Unix */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,
	
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};

    rret=gchar(&ch);
    while (rret > 0) {            /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '\n'  : wchar("\n"); nl(); break;
	case (unsigned char) '\r'  : break;  /* in DOS vor new-line */
	case (unsigned char) '\032': break;  /* in DOS(alt) vor EOF */
	default                    : wchar(&ch); soz++; break;
	}
      }
      rret=gchar(&ch);
    }
  }

  else if ( strcmp(Vekt[1],"-ibm2iso") == 0 ) { /* 8 Bit-IBM-Code --> 8 Bit-ISO-Code */

    ibmiso(0);

  }
  
  else if ( strcmp(Vekt[1],"-iso2ibm") == 0 ) { /* 8 Bit-ISO-Code --> 8 Bit-IBM-Code */

    ibmiso(1);

  }
  
  else if ( strcmp(Vekt[1],"-tabexp") == 0 ) { /* Tabulatoren durch Leerzeichen expandieren */

    static int feld []
      ={0,0,0,0,0,0,0,0, 0,1,1,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
	
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0};
    int zb=0, zt=0;

    rret=gchar(&ch); tpos++;
    while (rret > 0) {            /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0)
	   { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) '\n' : wchar("\n");nl(); break;
	case (unsigned char) '\t' : zt++;
	                            for (i=1; i<=(9-(tpos%8)); i++) {wchar(" ");zb++;}
				    tpos=tpos+(8-(tpos%8));
				    break;
	default  :  
		      printf("\n%c(%d): Zeichen entfernt",ch,ch);
		      printf(" (in Zeile %d)\n",anznl+1);
		      break;
	}
      }
      rret=gchar(&ch); tpos++;
    }
    printf("\n\n %i Tabulatoren durch  %i Leerzeichen ersetzt!",zt,zb);
  }
  
  else if ( strcmp(Vekt[1],"-analyse") == 0 ) { /* Test auf 7-Bit ASCII-Datei */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,
	
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0};
    int anztab=0;
    int anzcr=0;
    int anzeof=0;
    int anzsonst=0;
    int anz8=0;
    int maxzl=0, zl=0;
    
    rret=gchar(&ch); tpos++; zl++;
    while (rret > 0) { /*  printf(" %i ",zl);  */
      if (feld[ch]!=0) {
	switch (ch) {
	case (unsigned char) '\t'   :  for (i=1 ;i<=(9-(tpos%8)) ;i++) {wchar(" ");zl++;}
				       tpos=tpos+(8-(tpos%8));
	                               anztab++;
				       break;
	case (unsigned char) '\n'   : anznl++; if(zl>maxzl) {maxzl=zl;} zl=0;  break;
	case (unsigned char) '\r'   : anzcr++;    break;
	case (unsigned char) '\032' : anzeof++;   break;
	default                     : anzsonst++; break;
	}
      }
      if ( ch >= 127) anz8++;
      rret=gchar(&ch); tpos++; zl++;
    }
    printf ("\nDatei:  %s",Vekt[2]);
    printf ("\n             %9i Zeilen",anznl);
    printf ("\n             %9i Zeichen in lngster Zeile",maxzl);
    printf ("\n             %9i Zeichen insgesamt",anzz);
    if (anztab > 0)   
      printf ("\n                 %9i Tabulatoren",anztab);
    if (anzcr > 0)   
      printf ("\n                 %9i CR-Zeichen",anzcr);
    if (anzeof > 0)   
      printf ("\n                 %9i DOS-Dateiende",anzeof);
    if (anzsonst > 0)
      printf ("\n                 %9i Sonstige Steuer-Zeichen",anzsonst);
  }
  
  else if ( strcmp(Vekt[1],"-ascii7") == 0 ) { /* Erstellen einer 7-Bit ASCII-Datei */

    static int feld []
      ={1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,1,
	
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1};
    
    rret=gchar(&ch); tpos++;
    while (rret > 0) {            /*     printf("ch=%c(%d) ",ch,ch);     */
      if (feld[ch]==0) { wchar(&ch); }
      else {
	switch (ch) {
	case (unsigned char) ''   : wchar("a"); wchar("e"); break;
	case (unsigned char) ''   : wchar("o"); wchar("e"); break;
	case (unsigned char) ''   : wchar("u"); wchar("e"); break;
	case (unsigned char) ''   : wchar("A"); wchar("e"); break;
	case (unsigned char) ''   : wchar("O"); wchar("e"); break;
	case (unsigned char) ''   : wchar("U"); wchar("e"); break;
	case (unsigned char) ''   : wchar("s"); wchar("s"); break;
	case (unsigned char) '\n'  : wchar("\n");nl(); break;
	default  :  
		      printf("\n%c(%d): Zeichen entfernt",ch,ch);
		      printf(" (in Zeile %d)\n",anznl+1);
		      break;
	}
      }
      rret=gchar(&ch); tpos++;
    }
  }
  
  else { printf("\nOption (Typ der Konvertierung) falsch\n");  exit(1);  }

  /* Wenn fr alte DOS-Version gewnscht (Dateiende explizit!): */
  /* if ( strcmp(Vekt[1],"-u2d") == 0 ) { wchar("\032"); } */

  if ( suz!=0 )
    printf("\n%6i Umlaute aus Eingabedatei wurden umgewandelt",suz);
  if ( soz!=0 )
    printf("\n       Datei enthlt %i Sonderzeichen (Steuerz.,8bit-Erweiterung)",soz);
  
  close(filed1);
  wchar0();   close(filed2);
  printf("\n");
  /*(void) system("ls -l"); */  /* oder */ /*  ivar = system("ls -l"); */
  exit(0);                                                                 
}

/******************************************************************************/

void nl()
{
  anznl=anznl+1;  /* newlines zaehlen! */
  tpos=0;
  if (anznl%100==0) write(1,".",1);
}

/******************************************************************************/

int  gchar(byt)
   /* liest (gepuffert) 1 Zeichen ein und  gibt es als Arbument byt an das
      rufende Programm    */
  char   *byt;
{
  static char buffer[BUFLEN_E];
  static int cnt=0;
  static char *ptr;

  if (cnt == 0)
   {cnt=read(filed1,buffer,BUFLEN_E);
		      /* printf("\n%d Zeichen gelesen",cnt); */
    ptr=buffer;
   }
  if (cnt > 0)
   {*byt = *ptr;     /*  printf("*%c,%d*",*ptr,cnt);  */
    cnt--;  ptr++;  anzz++;
    return (1);
   }
  else if (cnt < 0)
   {printf("\nFehler beim Einlesen, returncode=%d\n",cnt);
    return (cnt);
   }
  else
   {return (cnt);
   }
}

/******************************************************************************/

void wchar(byt)
  /* stellt 1 Zeichen (=byt) in den Puffer; zuletzt muss ein Aufruf wchar0() erfolgen!) */
  char   *byt;
{
  *ptr_a = *byt;
  cnt_a++;  ptr_a++;
  if (cnt_a == BUFLEN_A) {
    write(filed2,buffer_a,BUFLEN_A);
    /*   printf("\n#%c..%c#\n",buffer_a[0],buffer_a[BUFLEN_A-1]); */
    cnt_a=0;   ptr_a=buffer_a;
  }

  return;
}

/******************************************************************************/

void wchar0()
   /* leert den Ausgabepuffer                            */
{
  write(filed2,buffer_a,cnt_a);
  /*   printf("\n#%c..%c#\n",buffer_a[0],buffer_a[cnt_a]);  */
  cnt_a=0;   ptr_a=buffer_a;
   
  return;
}

/******************************************************************************/


#define AAA '\251'	     /* in ASCII nicht darstellbar, daher Copyr.  */
#define III '\333'           /* in IBM   nicht darstellbar, daher Graphic */

void ibmiso(int index)
{

/*       Index 0:    IBM  -->  ASCII
			       Index 1:  ASCII  -->  IBM        */


                             /* Dez Okt | IBM --> ASCII || ASCII --> IBM   */
static unsigned char w[256][2]=
     { { '\000' , '\000' },  /*   0 000 | NUL      --> NUL      || NUL      --> NUL      */ 
       { '\001' , '\001' },  /*   1 001 | SOH      --> SOH      ||   SOH    --> SOH      */ 
       { '\002' , '\002' },  /*   2 002 | STX      --> STX      ||   STX    --> STX      */ 
       { '\003' , '\003' },  /*   3 003 | ETX      --> ETX      ||   ETX    --> ETX      */ 
       { '\004' , '\004' },  /*   4 004 | EOT      --> EOT      ||   EOT    --> EOT      */ 
       { '\005' , '\005' },  /*   5 005 | ENQ      --> ENQ      ||   ENQ    --> ENQ      */ 
       { '\006' , '\006' },  /*   6 006 | ACK      --> ACK      ||   ACK    --> ACK      */ 
       { '\007' , '\007' },  /*   7 007 | BEL      --> BEL      ||   BEL    --> BEL      */ 
       { '\010' , '\010' },  /*   8 010 | BS       --> BS       ||   BS     --> BS       */ 
       { '\011' , '\011' },  /*   9 011 | HT       --> HT       ||   HT     --> HT       */ 
       { '\012' , '\012' },  /*  10 012 | LF       --> LF       ||   LF     --> LF       */ 
       { '\013' , '\013' },  /*  11 013 | VT       --> VT       ||   VT     --> VT       */ 
       { '\014' , '\014' },  /*  12 014 | FF       --> FF       ||   FF     --> FF       */ 
       { '\015' , '\015' },  /*  13 015 | CR       --> CR       ||   CR     --> CR       */ 
       { '\016' , '\016' },  /*  14 016 | SO       --> SO       ||   SO     --> SO       */ 
       { '\017' , '\017' },  /*  15 017 | SI       --> SI       ||   SI     --> SI       */ 
       { '\020' , '\020' },  /*  16 020 | DLE      --> DLE      ||   DLE    --> DLE      */ 
       { '\021' , '\021' },  /*  17 021 | DC1      --> DC1      ||   DC1    --> DC1      */ 
       { '\022' , '\022' },  /*  18 022 | DC2      --> DC2      ||   DC2    --> DC2      */ 
       { '\023' , '\023' },  /*  19 023 | DC3      --> DC3      ||   DC3    --> DC3      */ 
       { '\266' ,  III   },  /*  20 024 | \P       --> \P       ||   DC4    --> ***      */ 
       { '\247' ,  III   },  /*  21 025 | \S       --> \S       ||   NAK    --> ***      */ 
       { '\026' , '\026' },  /*  22 026 | SYN      --> SYN      ||   SYN    --> SYN      */ 
       { '\027' , '\027' },  /*  23 027 | ETB      --> ETB      ||   ETB    --> ETB      */ 
       { '\030' , '\030' },  /*  24 030 | CAN      --> CAN      ||   CAN    --> CAN      */ 
       { '\031' , '\031' },  /*  25 031 | EM       --> EM       ||   EM     --> EM       */ 
       { '\032' , '\032' },  /*  26 032 | SUB      --> SUB      ||   SUB    --> SUB      */ 
       { '\033' , '\033' },  /*  27 033 | ESC      --> ESC      ||   ESC    --> ESC      */ 
       { '\034' , '\034' },  /*  28 034 | FS       --> FS       ||   FS     --> FS       */ 
       { '\035' , '\035' },  /*  29 035 | GS       --> GS       ||   GS     --> GS       */ 
       { '\036' , '\036' },  /*  30 036 | RS       --> RS       ||   RS     --> RS       */ 
       { '\037' , '\037' },  /*  31 037 | US       --> US       ||   US     --> US       */ 
       { '\040' , '\040' },  /*  32 040 | blank    --> blank    ||   blank  --> blank    */ 
       { '\041' , '\041' },  /*  33 041 | !        --> !        ||   !      --> !        */
       { '\042' , '\042' },  /*  34 042 | "        --> "        ||   "      --> "        */
       { '\043' , '\043' },  /*  35 043 | #        --> #        ||   #      --> #        */
       { '\044' , '\044' },  /*  36 044 | $        --> $        ||   $      --> $        */
       { '\045' , '\045' },  /*  37 045 | %        --> %        ||   %      --> %        */
       { '\046' , '\046' },  /*  38 046 | &        --> &        ||   &      --> &        */
       { '\047' , '\047' },  /*  39 047 | '        --> '        ||   '      --> '        */
       { '\050' , '\050' },  /*  40 050 | (        --> (        ||   (      --> (        */
       { '\051' , '\051' },  /*  41 051 | )        --> )        ||   )      --> )        */
       { '\052' , '\052' },  /*  42 052 | *        --> *        ||   *      --> *        */
       { '\053' , '\053' },  /*  43 053 | +        --> +        ||   +      --> +        */
       { '\054' , '\054' },  /*  44 054 | , (Komma)--> ,        ||   ,      --> ,        */
       { '\055' , '\055' },  /*  45 055 | - (Minus)--> -        ||   -      --> -        */
       { '\056' , '\056' },  /*  46 056 | . (Punkt)--> .        ||   .      --> .        */
       { '\057' , '\057' },  /*  47 057 | /        --> /        ||   /      --> /        */
       { '\060' , '\060' },  /*  48 060 | 0        --> 0        ||   0      --> 0        */
       { '\061' , '\061' },  /*  49 061 | 1        --> 1        ||   1      --> 1        */
       { '\062' , '\062' },  /*  50 062 | 2        --> 2        ||   2      --> 2        */
       { '\063' , '\063' },  /*  51 063 | 3        --> 3        ||   3      --> 3        */
       { '\064' , '\064' },  /*  52 064 | 4        --> 4        ||   4      --> 4        */
       { '\065' , '\065' },  /*  53 065 | 5        --> 5        ||   5      --> 5        */
       { '\066' , '\066' },  /*  54 066 | 6        --> 6        ||   6      --> 6        */
       { '\067' , '\067' },  /*  55 067 | 7        --> 7        ||   7      --> 7        */
       { '\070' , '\070' },  /*  56 070 | 8        --> 8        ||   8      --> 8        */
       { '\071' , '\071' },  /*  57 071 | 9        --> 9        ||   9      --> 9        */
       { '\072' , '\072' },  /*  58 072 | :        --> :        ||   :      --> :        */
       { '\073' , '\073' },  /*  59 073 | ;        --> ;        ||   ;      --> ;        */
       { '\074' , '\074' },  /*  60 074 | <        --> <        ||   <      --> <        */
       { '\075' , '\075' },  /*  61 075 | =        --> =        ||   =      --> =        */
       { '\076' , '\076' },  /*  62 076 | >        --> >        ||   >      --> >        */
       { '\077' , '\077' },  /*  63 077 | ?        --> ?        ||   ?      --> ?        */
       { '\100' , '\100' },  /*  64 100 | @        --> @        ||   @      --> @        */
       { '\101' , '\101' },  /*  65 101 | A        --> A        ||   A      --> A        */
       { '\102' , '\102' },  /*  66 102 | B        --> B        ||   B      --> B        */
       { '\103' , '\103' },  /*  67 103 | C        --> C        ||   C      --> C        */
       { '\104' , '\104' },  /*  68 104 | D        --> D        ||   D      --> D        */
       { '\105' , '\105' },  /*  69 105 | E        --> E        ||   E      --> E        */
       { '\106' , '\106' },  /*  70 106 | F        --> F        ||   F      --> F        */
       { '\107' , '\107' },  /*  71 107 | G        --> G        ||   G      --> G        */
       { '\110' , '\110' },  /*  72 110 | H        --> H        ||   H      --> H        */
       { '\111' , '\111' },  /*  73 111 | I        --> I        ||   I      --> I        */
       { '\112' , '\112' },  /*  74 112 | J        --> J        ||   J      --> J        */
       { '\113' , '\113' },  /*  75 113 | K        --> K        ||   K      --> K        */
       { '\114' , '\114' },  /*  76 114 | L        --> L        ||   L      --> L        */
       { '\115' , '\115' },  /*  77 115 | M        --> M        ||   M      --> M        */
       { '\116' , '\116' },  /*  78 116 | N        --> N        ||   N      --> N        */
       { '\117' , '\117' },  /*  79 117 | O        --> O        ||   O      --> O        */
       { '\120' , '\120' },  /*  80 120 | P        --> P        ||   P      --> P        */
       { '\121' , '\121' },  /*  81 121 | Q        --> Q        ||   Q      --> Q        */
       { '\122' , '\122' },  /*  82 122 | R        --> R        ||   R      --> R        */
       { '\123' , '\123' },  /*  83 123 | S        --> S        ||   S      --> S        */
       { '\124' , '\124' },  /*  84 124 | T        --> T        ||   T      --> T        */
       { '\125' , '\125' },  /*  85 125 | U        --> U        ||   U      --> U        */
       { '\126' , '\126' },  /*  86 126 | V        --> V        ||   V      --> V        */
       { '\127' , '\127' },  /*  87 127 | W        --> W        ||   W      --> W        */
       { '\130' , '\130' },  /*  88 130 | X        --> X        ||   X      --> X        */
       { '\131' , '\131' },  /*  89 131 | Y        --> Y        ||   Y      --> Y        */
       { '\132' , '\132' },  /*  90 132 | Z        --> Z        ||   Z      --> Z        */
       { '\133' , '\133' },  /*  91 133 | [        --> [        ||   [      --> [        */
       { '\134' , '\134' },  /*  92 134 | \        --> \        ||   \      --> \        */
       { '\135' , '\135' },  /*  93 135 | ]        --> ]        ||   ]      --> ]        */
       { '\136' , '\136' },  /*  94 136 | ^        --> ^        ||   ^      --> ^        */
       { '\137' , '\137' },  /*  95 137 | _        --> _        ||   _      --> _        */
       { '\140' , '\140' },  /*  96 140 | `        --> `        ||   `      --> `        */
       { '\141' , '\141' },  /*  97 141 | a        --> a        ||   a      --> a        */
       { '\142' , '\142' },  /*  98 142 | b        --> b        ||   b      --> b        */
       { '\143' , '\143' },  /*  99 143 | c        --> c        ||   c      --> c        */
       { '\144' , '\144' },  /* 100 144 | d        --> d        ||   d      --> d        */
       { '\145' , '\145' },  /* 101 145 | e        --> e        ||   e      --> e        */
       { '\146' , '\146' },  /* 102 146 | f        --> f        ||   f      --> f        */
       { '\147' , '\147' },  /* 103 147 | g        --> g        ||   g      --> g        */
       { '\150' , '\150' },  /* 104 150 | h        --> h        ||   h      --> h        */
       { '\151' , '\151' },  /* 105 151 | i        --> i        ||   i      --> i        */
       { '\152' , '\152' },  /* 106 152 | j        --> j        ||   j      --> j        */
       { '\153' , '\153' },  /* 107 153 | k        --> k        ||   k      --> k        */
       { '\154' , '\154' },  /* 108 154 | l        --> l        ||   l      --> l        */
       { '\155' , '\155' },  /* 109 155 | m        --> m        ||   m      --> m        */
       { '\156' , '\156' },  /* 110 156 | n        --> n        ||   n      --> n        */
       { '\157' , '\157' },  /* 111 157 | o        --> o        ||   o      --> o        */
       { '\160' , '\160' },  /* 112 160 | p        --> p        ||   p      --> p        */
       { '\161' , '\161' },  /* 113 161 | q        --> q        ||   q      --> q        */
       { '\162' , '\162' },  /* 114 162 | r        --> r        ||   r      --> r        */
       { '\163' , '\163' },  /* 115 163 | s        --> s        ||   s      --> s        */
       { '\164' , '\164' },  /* 116 164 | t        --> t        ||   t      --> t        */
       { '\165' , '\165' },  /* 117 165 | u        --> u        ||   u      --> u        */
       { '\166' , '\166' },  /* 118 166 | v        --> v        ||   v      --> v        */
       { '\167' , '\167' },  /* 119 167 | w        --> w        ||   w      --> w        */
       { '\170' , '\170' },  /* 120 170 | x        --> x        ||   x      --> x        */
       { '\171' , '\171' },  /* 121 171 | y        --> y        ||   y      --> y        */
       { '\172' , '\172' },  /* 122 172 | z        --> z        ||   z      --> z        */
       { '\173' , '\173' },  /* 123 173 | {        --> {        ||   {      --> {        */
       { '\174' , '\174' },  /* 124 174 | |        --> |        ||   |      --> |        */
       { '\175' , '\175' },  /* 125 175 | }        --> }        ||   }      --> }        */
       { '\176' , '\176' },  /* 126 176 | ~        --> ~        ||   ~      --> ~        */
       { '\177' , '\177' },  /* 127 177 | DEL      --> DEL      ||   DEL    --> DEL      */
       { '\307' , III    },  /* 128 200 | \c{C}    --> \c{C}    || ***      --> ***      */
       { '\374' , III    },  /* 129 201 | \"u      --> \"u      || ***      --> ***      */
       { '\351' , III    },  /* 130 202 | \acute{e}--> \acute{e}|| ***      --> ***      */
       { '\342' , III    },  /* 131 203 | \hat{a}  --> \hat{a}  || ***      --> ***      */
       { '\344' , III    },  /* 132 204 | \"a      --> \"a      || ***      --> ***      */
       { '\340' , III    },  /* 133 205 | \grave{a}--> \grave{a}|| ***      --> ***      */
       { '\345' , III    },  /* 134 206 | \aa      --> \aa      || ***      --> ***      */
       { '\347' , III    },  /* 135 207 | \c{c}    --> \c{c}    || ***      --> ***      */
       { '\352' , III    },  /* 136 210 | \hat{e}  --> \hat{e}  || ***      --> ***      */
       { '\353' , III    },  /* 137 211 | \"e      --> \"e      || ***      --> ***      */
       { '\350' , III    },  /* 138 212 | \grave{e}--> \grave{e}|| ***      --> ***      */
       { '\357' , III    },  /* 139 213 | \"i      --> \"i      || ***      --> ***      */
       { '\356' , III    },  /* 140 214 | \hat{i}  --> \hat{i}  || ***      --> ***      */
       { '\354' , III    },  /* 141 215 | \grave{i}--> \grave{i}|| ***      --> ***      */
       { '\304' , III    },  /* 142 216 | \"A      --> \"A      || ***      --> ***      */
       { '\305' , III    },  /* 143 217 | \AA      --> \AA      || ***      --> ***      */
       { '\311' , III    },  /* 144 220 | \acute{E}--> \acute{E}|| ***      --> ***      */
       { '\346' , III    },  /* 145 221 | \ae      --> \ae      || ***      --> ***      */
       { '\306' , III    },  /* 146 222 | \AE      --> \AE      || ***      --> ***      */
       { '\364' , III    },  /* 147 223 | \hat{o}  --> \hat{o}  || ***      --> ***      */
       { '\366' , III    },  /* 148 224 | \"o      --> \"o      || ***      --> ***      */
       { '\362' , III    },  /* 149 225 | \grave{o}--> \grave{o}|| ***      --> ***      */
       { '\373' , III    },  /* 150 226 | \hat{u}  --> \hat{u}  || ***      --> ***      */
       { '\371' , III    },  /* 151 227 | \grave{u}--> \grave{u}|| ***      --> ***      */
       { '\377' , III    },  /* 152 230 | \"y      --> \"y      || ***      --> ***      */
       { '\326' , III    },  /* 153 231 | \"O      --> \"O      || ***      --> ***      */
       { '\334' , III    },  /* 154 232 | \"U      --> \"U      || ***      --> ***      */
       { '\242' , III    },  /* 155 233 | \|C      --> \|C      || ***      --> ***      */
       { '\243' , III    },  /* 156 234 | \pounds  --> \pounds  || ***      --> ***      */
       { '\245' , III    },  /* 157 235 | Yen      --> Yen      || ***      --> ***      */
       {  AAA   , III    },  /* 158 236 | Pt       --> ***      || ***      --> ***      */
       {  AAA   , III    },  /* 159 237 | f        --> ***      || ***      --> ***      */
       { '\341' , III    },  /* 160 240 | \acute{a}--> \acute{a}|| ***      --> ***      */
       { '\355' , '\255' },  /* 161 241 | \acute{i}--> \acute{i}|| !'       --> !'       */
       { '\363' , '\233' },  /* 162 242 | \acute{o}--> \acute{o}|| \|C      --> \|C      */
       { '\372' , '\234' },  /* 163 243 | \acute{u}--> \acute{u}|| \pounds  --> \pounds  */
       { '\361' , III    },  /* 164 244 | \tilde{n}--> \tilde{n}|| Sofakiss --> ***      */
       { '\321' , '\235' },  /* 165 245 | \tilde{N}--> \tilde{N}|| Yen      --> Yen      */
       { '\252' , '\174' },  /* 166 246 | ^{a}     --> ^{a}     || |unterbr --> |unterbr */
       { '\272' , '\025' },  /* 167 247 | ^{o}     --> ^{o}     || \S       --> NAK      */
       { '\277' , III    },  /* 168 250 | ?'       --> ?'       || \ddot    --> ***      */
       { AAA    , III    },  /* 169 251 | ***      --> ***      || \copyright-> ***      */
       { '\254' , '\246' },  /* 170 252 | \not     --> \not     || ^{a}     --> ^{a}     */
       { '\275' , '\256' },  /* 171 253 | 1/2      --> 1/2      || <<       --> <<       */
       { '\274' , '\252' },  /* 172 254 | 1/4      --> 1/4      || \not     --> \not     */
       { '\241' , III    },  /* 173 255 | !'       --> !'       || SHY      --> ***      */
       { '\253' , III    },  /* 174 256 | <<       --> <<       || regist   --> ***      */
       { '\273' , III    },  /* 175 257 | >>       --> >>       || ^{-}     --> ***      */
       { AAA    , '\370' },  /* 176 260 | ***      --> ***      || ^{o}     --> ^{o}     */
       { AAA    , '\361' },  /* 177 261 | ***      --> ***      || \pm      --> \pm      */
       { AAA    , '\375' },  /* 178 262 | ***      --> ***      || ^{2}     --> ^{2}     */
       { AAA    , III    },  /* 179 263 | ***      --> ***      || ^{3}     --> ***      */
       { AAA    , III    },  /* 180 264 | ***      --> ***      || \acute   --> ***      */
       { AAA    , '\346' },  /* 181 265 | ***      --> ***      || \mu      --> \mu      */
       { AAA    , '\024' },  /* 182 266 | ***      --> ***      || PI       --> PI       */
       { AAA    , III    },  /* 183 267 | ***      --> ***      || ***      --> ***      */
       { AAA    , III    },  /* 184 270 | ***      --> ***      || ***      --> ***      */
       { AAA    , III    },  /* 185 271 | ***      --> ***      || ^{1}     --> ***      */
       { AAA    , '\247' },  /* 186 272 | ***      --> ***      || ^{o}     --> ^{o}     */
       { AAA    , '\257' },  /* 187 273 | ***      --> ***      || >>       --> >>       */
       { AAA    , '\254' },  /* 188 274 | ***      --> ***      || 1/4      --> 1/4      */
       { AAA    , '\253' },  /* 189 275 | ***      --> ***      || 1/2      --> 1/2      */
       { AAA    , III    },  /* 190 276 | ***      --> ***      || 3/4      --> ***      */
       { AAA    , '\250' },  /* 191 277 | ***      --> ***      || ?'       --> ?'       */
       { AAA    , III    },  /* 192 300 | ***      --> ***      || \grave{A}--> ***      */
       { AAA    , III    },  /* 193 301 | ***      --> ***      || \acute{A}--> ***      */
       { AAA    , III    },  /* 194 302 | ***      --> ***      || \hat{A}  --> ***      */
       { AAA    , III    },  /* 195 303 | ***      --> ***      || \tilde{A}--> ***      */
       { AAA    , '\216' },  /* 196 304 | ***      --> ***      || \"A      --> \"A      */
       { AAA    , '\217' },  /* 197 305 | ***      --> ***      || \AA      --> \AA      */
       { AAA    , '\222' },  /* 198 306 | ***      --> ***      || \AE      --> \AE      */
       { AAA    , '\200' },  /* 199 307 | ***      --> ***      || \c{C}    --> \c{C}    */
       { AAA    , III    },  /* 200 310 | ***      --> ***      || \grave{E}--> ***      */
       { AAA    , '\220' },  /* 201 311 | ***      --> ***      || \acute{E}--> \acute{E}*/
       { AAA    , III    },  /* 202 312 | ***      --> ***      || ***      --> ***      */
       { AAA    , III    },  /* 203 313 | ***      --> ***      || \"E      --> ***      */
       { AAA    , III    },  /* 204 314 | ***      --> ***      || \grave{I}--> ***      */
       { AAA    , III    },  /* 205 315 | ***      --> ***      || \acute{I}--> ***      */
       { AAA    , III    },  /* 206 316 | ***      --> ***      || \hat{I}  --> ***      */
       { AAA    , III    },  /* 207 317 | ***      --> ***      || \"I      --> ***      */
       { AAA    , III    },  /* 208 320 | ***      --> ***      || -D       --> ***      */
       { AAA    , '\245' },  /* 209 321 | ***      --> ***      || \tilde{N}--> \tilde{N}*/
       { AAA    , III    },  /* 210 322 | ***      --> ***      || \grave{O}--> ***      */
       { AAA    , III    },  /* 211 323 | ***      --> ***      || \acute{O}--> ***      */
       { AAA    , III    },  /* 212 324 | ***      --> ***      || \hat{O}  --> ***      */
       { AAA    , III    },  /* 213 325 | ***      --> ***      || \tilde{O}--> ***      */
       { AAA    , '\231' },  /* 214 326 | ***      --> ***      || \"O      --> \"O      */
       { AAA    , III    },  /* 215 327 | ***      --> ***      || \times   --> ***      */
       { AAA    , '\355' },  /* 216 330 | ***      --> ***      || \O       --> \O       */
       { AAA    , III    },  /* 217 331 | ***      --> ***      || \grave{U}--> ***      */
       { AAA    , III    },  /* 218 332 | ***      --> ***      || \acute{U}--> ***      */
       { AAA    , III    },  /* 219 333 | ***      --> ***      || \hat{U}  --> ***      */
       { AAA    , '\232' },  /* 220 334 | ***      --> ***      || \"U      --> \"U      */
       { AAA    , III    },  /* 221 335 | ***      --> ***      || \acute{Y}--> ***      */
       { AAA    , III    },  /* 222 336 | ***      --> ***      || |p       --> ***      */
       { AAA    , '\341' },  /* 223 337 | ***      --> ***      || \"s      --> \beta    */
       { AAA    , '\205' },  /* 224 340 | \alpha   --> ***      || \grave{a}--> \grave{a}*/
       { '\337' , '\240' },  /* 225 341 | \beta    --> \"s      || \acute{a}--> \acute{a}*/
       { AAA    , '\203' },  /* 226 342 | \Gamma   --> ***      || \hat{a}  --> \hat{a}  */
       { AAA    , III    },  /* 227 343 | \pi      --> ***      || \tilde{a}--> ***      */
       { AAA    , '\204' },  /* 228 344 | \Sigma   --> ***      || \"a      --> \"a      */
       { AAA    , '\206' },  /* 229 345 | \sigma   --> ***      || \aa      --> \aa      */
       { '\265' , '\221' },  /* 230 346 | \mu      --> \mu      || \ae      --> \ae      */
       { AAA    , '\207' },  /* 231 347 | \tau     --> ***      || \c{c}    --> \c{c}    */
       { AAA    , '\212' },  /* 232 350 | \Phi     --> ***      || \grave{e}--> \grave{e}*/
       { AAA    , '\202' },  /* 233 351 | \Theta   --> ***      || \acute{e}--> \acute{e}*/
       { AAA    , '\210' },  /* 234 352 | \Omega   --> ***      || \hat{e}  --> \at{e}   */
       { AAA    , '\211' },  /* 235 353 | \delta   --> ***      || \"e      --> \"e      */
       { AAA    , '\215' },  /* 236 354 | \infty   --> ***      || \grave{i}--> \grave{i}*/
       { '\330' , '\241' },  /* 237 355 | \O       --> \O       || \acute{i}--> \acute{i}*/
       { AAA    , '\214' },  /* 238 356 | \in      --> ***      || \hat{i}  --> \hat{i}  */
       { AAA    , '\213' },  /* 239 357 | \cap     --> ***      || \"i      --> \"i      */
       { AAA    , III    },  /* 240 360 | \equiv   --> ***      || -d       --> ***      */
       { '\261' , '\244' },  /* 241 361 | \pm      --> \pm      || \tilde{n}--> \tilde{n}*/
       { AAA    , '\225' },  /* 242 362 | \geq     --> ***      || \grave{o}--> \grave{o}*/
       { AAA    , '\242' },  /* 243 363 | \leq     --> ***      || \acute{o}--> \acute{o}*/
       { AAA    , '\223' },  /* 244 364 | 1/2Integr--> ***      || \hat{o}  --> \hat{o}  */
       { AAA    , III    },  /* 245 365 | 1/2Integr--> ***      || \tilde{o}--> ***      */
       { '\367' , '\224' },  /* 246 366 | \dif     --> \dif     || \"o      --> \"o      */
       { AAA    , '\366' },  /* 247 367 | \approx  --> ***      || \dif     --> \dif     */
       { '\260' , III    },  /* 248 370 | ^{o}     --> ^{o}     || \o       --> ***      */
       { AAA    , '\227' },  /* 249 371 | \bullet  --> ***      || \grave{u}--> \grave{u}*/
       { AAA    , '\243' },  /* 250 372 | \bullet  --> ***      || \acute{u}--> \acute{u}*/
       { AAA    , '\226' },  /* 251 373 | \sqrt    --> ***      || \hat{u}  --> \hat{u}  */
       { AAA    , '\201' },  /* 252 374 | ^{n}     --> ***      || \"u      --> \"u      */
       { '\262' , III    },  /* 253 375 | ^{2}     --> ^{2}     || \acute{y}--> ***      */
       { AAA    , III    },  /* 254 376 | \box     --> ***      || |P       --> ***      */
       { AAA    , '\230' }   /* 255 377 | ***      --> ***      || \"y      --> \"y      */
     };


  unsigned char c1, c2, cc;
char byt1, byt2;
  int rret, ges, un;
  cc = AAA;    
  if (index == 1) cc = III;
  ges = 0; un = 0;
  rret = gchar(&byt1); 
  while (rret > 0)
  {
    c1 = (unsigned char) byt1;
    ges++;
    c2 = w[c1][index];
    if (c2 == cc) un++;
    byt2 = (char) c2;
    wchar(&byt2);
    rret = gchar(&byt1); 
  };

   printf("\nInsgesamt wurden %d Zeichen umcodiert.", ges);
   if (un > 0)
     printf("\nEs wurden %d nicht umcodierbare Zeichen auf '\\%o' (oktal) abgebildet.\n",
	     un, cc);
   wchar0();   
   return;
}
