#!/usr/local/bin/wishx -f
#
# Hauptmen fr xtem_texmenu   
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Univ. Bremen

###############  path in which xtem will be installed
set xtem_path "/usr/local/lib/tex/xtem"


###############  end changes by the local administrator ###########
###################################################################

set version "3.12.1"
set version_incompatible "3.08"

set copyright "Copyright 1994  G. Lamprecht, W. Lotz, R. Weibezahn; "
set copyright "${copyright}LRW c/o Bremen University"
set email     "e-mail: weibezahn@lrw.uni-bremen.de"

set auto_path "$xtem_path $auto_path"

if { ($argc == 1) || ($argc == 2) } {
  set language "[lindex $argv 0]"
  set aufrufdatei "[lindex $argv 1]"
} else {
  puts stdout "call:  xtem \[ -l language \] \[ filename\[.tex\] \]"
  bell
  exit
}

set texsuffix  ""
set aufruftexsuffix  ""

regsub "\.tex$" $aufrufdatei "" hvar
if { "${hvar}.tex" == "$aufrufdatei" } {
  set aufrufdatei "$hvar"
  set aufruftexsuffix ".tex"
  set texsuffix ".tex"
} else {
  regsub "\.ltx$" $aufrufdatei "" hvar
  if { "${hvar}.ltx" == "$aufrufdatei" } {
    set aufrufdatei "$hvar";
    set aufruftexsuffix ".ltx"
    set texsuffix ".ltx"
  }
}

if {$aufrufdatei == ""} {
  set efile       ""
  set main_file  ""
} else {
  set efile       $aufrufdatei
  set main_file  $aufrufdatei
}

if { [info exists env(XTEMVSTDIR)] } {
  set inst_gel "$env(XTEMVSTDIR):$xtem_path/locals_$language"
} else {
  set inst_gel "$xtem_path/locals_$language"
}

set hlp_dir "$xtem_path/help_$language/"
set f [open "${hlp_dir}button.texts" r]
while { [gets $f ein] > 0 } {
  set vv([string trim [string range $ein 0 14]]) [string trim [string range $ein 20 end]]
}
close $f


wm minsize . 0 0
wm title . "xtem"
wm iconname . "xtem"


proc install_lesen {} {
  global vv env inst_gel widthl widthr sizeds TeX_syntax_lines TeX_syntax_sel
  global fonttt fontdli fontsli fontbl fonterr fonttsli fonttstt prtselmaxl
  global maxprintcops vlerg hlp_font

  if { [info exists env(XTEMINSTALL)] } {
    set foid [open "$env(XTEMINSTALL)" r]
    set inst_gel "${inst_gel} ($vv(xt1))\n"
  } else {
    set foid [open_vst install.vst]
  }

  while {[gets $foid z]>0} {set [string trim [string range $z 0 18]] [string trim [string range $z 19 end]]}
  close $foid
}


proc mktest {} {
  global  vv mkcommand mkcv mkcq xtem_path mkcfirst

  proc fa2a {} {
   global vv sub p_mkCmd lp_mkCmd
   button .a.2.a -text "$vv(xta2a)" -command {#            Abbruch
     if { $sub == 1 } {
       bell;
       set lp_mkCmd $p_mkCmd  
       if { $lp_mkCmd > 1 } {
         writescr0 .d.tt "\n[datime] $vv(xt4) $lp_mkCmd $vv(xt5)\n" 
         killprocess $p_mkCmd
       } elseif  { $lp_mkCmd == 1 } {
         writescr0 .d.tt "\n[datime] $vv(xt6)\n" 
       } else {
         destroy .t; set wait_mkCmd 1
       }
       unlock_list
     } else {
       bell
       writescr0 .d.tt "\n[datime] $vv(xt7)\n\n$vv(xt8)\n"
     }
   }
  bind .a.2.a <Button-3> {+ cat_file0 "${hlp_dir}xt_abbruch.hlp" .d.tt}

  pack configure .a.2.a -in .a.2 -side left -padx 3 -pady 3
  .a.2.a configure -state disabled; update idletasks
  }

  if { !$mkcfirst } {
     source $xtem_path/$mkcommand; set mkcv "[mkcommand_v]"; set mkcq "$mkcv"
  }
  set mkcfirst 0
  if { $mkcommand == "mkcommand.0" } {
    if { [winfo exists .a.2.a]} {destroy .a.2.a; update idletasks}
    if { [winfo exists .a.2.x]} {.a.2.x invoke;destroy .a.2.x; update idletasks}
  } elseif { $mkcommand == "mkcommand.1" } {
    if {![winfo exists .a.2.a]} then  fa2a
    if { [winfo exists .a.2.x]} {.a.2.x invoke;destroy .a.2.x; update idletasks}
  } elseif { $mkcommand == "mkcommand.2" } {
    if {![winfo exists .a.2.a]} then  fa2a
    if { [winfo exists .a.2.x]} {.a.2.x invoke;destroy .a.2.x; update idletasks}
  } elseif { $mkcommand == "mkcommand.3" } {
    if {![winfo exists .a.2.a]} then  fa2a
    if { [winfo exists .a.2.x]} {.a.2.x invoke;destroy .a.2.x; update idletasks}
  } elseif { $mkcommand == "mkcommand.4" } {
    if {![winfo exists .a.2.a]} then  fa2a
    if {![winfo exists .a.2.x]} then  mkCmd_cw
  } elseif { $mkcommand == "mkcommand.5" } {
    if { [winfo exists .a.2.a]} {destroy .a.2.a; update idletasks}
    if { [winfo exists .a.2.x]} {.a.2.x invoke;destroy .a.2.x; update idletasks}
  }
}


proc knoepfe {} {
  global  vv
  global  editor efile esuff texfmt main_file tsuff preview psuff printer asuff
  global  logform logback lsuff prtdriver texsuffix prsuffix
  global  spcmd spsuff syntax ssuff index isuffe bibtex edback prback

  if {$main_file == ""} {
#    set efile  ""
    set tsuff  ""
    set psuff  ""
    set lsuff  ""
    set asuff  ""
  } else {
    set tsuff  "$texsuffix"
    set psuff  $prsuffix
    set lsuff  ".log"
    set asuff  ".dvi"
  }
  if {$efile == ""} {set esuffl ""} else {set esuffl $esuff}
  set spsuff  "$esuffl"
  set ssuff   "$esuffl"

  .c.1.ed configure -text "$vv(xtc1ed) $editor$edback   $efile$esuffl " 
  .c.1.la configure -text "$vv(xtc1la) $texfmt    $main_file$tsuff"
  .c.1.pf configure -text "$vv(xtc1pf) $preview$prback   $main_file$psuff"
  .c.1.fl configure -text "$vv(xtc1fl) $logform$logback  $main_file$lsuff"
  .c.1.as configure -text "$vv(xtc1as) $prtdriver  $main_file$asuff -> $printer"
  .c.2.re configure -text "$vv(xtc2re) $spcmd $efile$spsuff"
  .c.2.sy configure -text "$vv(xtc2sy) $syntax   $efile$ssuff"
  .c.2.in configure -text "$vv(xtc2in) $index $main_file"
  .c.2.bi configure -text "$vv(xtc2bi) $bibtex    $main_file"

}


proc xtem_hlptext {} {
  global  vv cprt hlp_dir copyright email version tclversion patchlevel tk_version
  global  tk_patchLevel extended addinput mkcq inst_gel
  cat_file0 "${hlp_dir}xt_xtem.hlp" .d.tt
  set cprt "$copyright\n$email\n\n"
  set cprt "${cprt}xtem:$version Tcl:$tclversion-$patchlevel Tk:${tk_version}-${tk_patchLevel} "
  set cprt "${cprt}$extended $addinput "
  set cprt "${cprt}mkcommand:$mkcq\n"
  set cprt "${cprt}$vv(xt28) $inst_gel\n\n"
  set cprt "${cprt}$vv(xtcprt1)\n$vv(xtcprt2)"
  if {[info exists vv(xtdlm1)]&&($vv(xtdlm1)!="")} {set cprt "${cprt}\n\n$vv(xtdlm1)"}
  if {[info exists vv(xtdlm2)]&&($vv(xtdlm2)!="")} {set cprt "${cprt}\n$vv(xtdlm2)"}
  writescr .d.tt $cprt
}


####### set your variables in the files  default.vst,  install.vst   etc. --- not here
####### the follwoing settings are  only for "security" (initialization of all variables)!!!
global  edatsort tdatsort
set edatsort "0"
set tdatsort "0"
set vlerg ""
set fonttt    lucidasanstypewriter-12
set fonterr   -Adobe-Courier-Bold-R-Normal-*-140-*
set fontbl    -adobe-helvetica-bold-r-normal--17-120-100-100-p-92-iso8859-1
set fontsli   lucidasanstypewriter-10
set fontdli   lucidasanstypewriter-12
set fonttsli  -adobe-courier-medium-r-normal--14-100-100-100-m-90-iso8859-1
set fonttstt  -adobe-courier-bold-r-normal--14-100-100-100-m-90-iso8859-1
set widthl    41
set widthr    45
set sizeds    100x10
set prtselmaxl 20
set TeX_syntax_lines 40
set TeX_syntax_sel   50
set maxprintcops 1

install_lesen
set version     "${version}$vlerg"
set version_vst "${version}"

set tyh 30
set sub 0
set edsubback 0
set prsubback 0
set logsubback 0
set anl0 0

set editor         "vi"
set edxterm        "xterm"
set edoptions      ""
set edsyntaxhelp   "yes"
set printer        ""
set lpcmd          "lp"
set lpopt          ""
set olsep          "@"
set prtdriver      "dvips"
set prtoptions     "" 
set prtsuf         ".ps" 
set prtpresel      "* * * * *"
set spcmd          "spell"
set sptext         ""
set splang         "englisch"
set spcorr         ""
set spselect       ""
set spoptions      ""
set bibtex         "bibtex"
set bitext         ""
set bioptions      ""
set index          "makeindex"
set intext         ""
set inoptions      ""
set syntax         ""
set sytext         ""
set syoptions      ""
set preview        "ghostview&"
set prtext         ""
set prsuffix       ".ps"
set proptions      "" 
set opsep          "@"
set prpreopt       "" 
set texfmt         "latex"
set texmem         ""
set texmtext       ""
set texmax         "1"
set logform        "cat"
set logxterm       ""
set logoptions     ""
set logtext        ""
set aufmax         "20"
set aufsuff        "*~ *.aux *.bak *.bbl *.blg *.dvi *.idx *.ilg *.ind *.lof *.log *.lot *.ps  *.toc *.wb-erg"
set auftoggle      " 1   1     1     0     1     0     1     1     0     1     1     1     0     1    1"
set mkcommand       "mkcommand.3"
set hlp_bmsuppr     "0"
set prtfilperm      "permanent"
set prformat        "A4_portrait"
set prtformat       ""
set prtselstr ""
set pg_start  "1"
set pg_end   "9999"
set prmtext     ""
set prmsel     ""
set prmrelabs   ""
set isuffe      ".idx"
set isuffa      ".ind"
set bsuff       ".aux"
set edback      ""
set edliste     ""
set edtext      ""
set prback      ""
set prliste     ""
set logliste    ""
set pid         ""
set texfmtts    ""
set tsuff  ""
set psuff  ""
set lsuff  ""
set asuff  ""
set esuff  ""
set spsuff ""
set ssuff  ""


set stt ""
set vst_ret [vst_read "" start.vst]
if { $vst_ret == "0" } {
  set stt ""
} else {
  set stt "${stt} $vv(xtq01)\n $vv(xtq01)\n $vv(xtq02)\n"
  set stt "${stt} $vv(xtq17)\n $vv(xtq18)\n $vv(xtq19)\n $vv(xtq20)\n"
  set stt "${stt} $vv(xtq02)\n $vv(xtq01)\n $vv(xtq01)\n"
  set stt "${stt}\n $vst_ret ---> $vst_ret.bak\n\n"
  bell
  set vst_ret [vst_read "" .xtem_$language.vst]
  if { $vst_ret != "0" } {
    set stt "${stt}\n $vst_ret ---> $vst_ret.bak\n\n"
    vst_read "" default.vst
  }
}

if { $aufruftexsuffix != "" } {set texsuffix $aufruftexsuffix}

if { $mkcommand == "" } {set mkcommand "mkcommand.3"}

###############  Feststellen der Tcl-Version   ####################
set tclversion [info tclversion]
if { $tclversion >= 7.0 } {set patchlevel [info patchlevel]} {set patchlevel ""}

set addinput   [info command addinput]
set extended   [info command infox]
set mkcq ""
if { $extended ==  "" } {
    source $xtem_path/mkcommand.0; set mkcv "[mkcommand_v]"; set mkcq $mkcv
    set mkcommand "mkcommand.0"; set mkcfirst 1
    set stt "${stt}$vv(xtq11)\n$vv(xtq12)\n$vv(xtq13)\n"
    set stt "${stt}$vv(xtq14)\n$vv(xtq15)\n$vv(xtq16)\n"
    set stt "${stt}______________________________________________\n\n" 
} else {
  if { [file exists "mkcommand_tst"] } {
    source mkcommand_tst; set mkcv "[mkcommand_v]"; set mkcq "e$mkcv"
    set mkcommand "mkcommand.$mkcv"
    set mkcfirst 1
  } elseif { [file exists $xtem_path/$mkcommand] } {
    source $xtem_path/$mkcommand; set mkcv "[mkcommand_v]"; set mkcq $mkcv
    set mkcfirst 1
  } else {
    bell
    set mkcq "\n" 
    set stt "${stt} $vv(xtq01)\n $vv(xtq01)\n $vv(xtq02)\n"
    set stt "${stt} $vv(xtq1)\n $vv(xtq2)\n $vv(xtq3)\n $vv(xtq4)\n"
    set stt "${stt} $vv(xtq02)\n $vv(xtq01)\n $vv(xtq01)\n"
    set stt "${stt}\n"
    set mkcfirst 1
  }
}
if {($tclversion>=7.0)&&($tclversion<7.4)} {
  if {($tclversion<7.3)} {
    set stt "${stt}$vv(xtq5)\n$vv(xtq6) $tclversion $vv(xtq7)\n"
    set stt "${stt}$vv(xtq8)\n$vv(xtq9)\n\n"
  }
} else {
  puts stdout "$vv(xtq10) $tclversion"
  exit
}
set stt "${stt}"
############### und Konsequenzen daraus        ####################
set p_mkCmd 1
###################################################################



set dir [pwd]

option add xtem*Button.Font $fontbl
option add xtem*Label.Font $fontbl
option add xtem*Checkbutton.Font $fontbl
option add *ev*Listbox.Font $fontdli
option add *ev*Text.Font $fonttt
option add *tv*Listbox.Font $fontdli
option add *tv*Text.Font $fonttt
option add *pv*Listbox.Font $fontdli
option add *pv*Text.Font $fonttt
option add *ak*Listbox.Font $fontdli
option add *ak*Text.Font $fonttt
option add *lv*Listbox.Font $fontdli
option add *lv*Text.Font $fonttt
option add *dm*Listbox.Font $fontdli
option add *dm*Text.Font $fonttt
option add *dv*Listbox.Font $fontdli
option add *dv*Text.Font $fonttt
option add *ds*Listbox.Font $fontsli
option add *ds*Text.Font $fonttt
option add *rv*Listbox.Font $fontdli
option add *rv*Text.Font $fonttt
option add *sv*Listbox.Font $fontdli
option add *sv*Text.Font $fonttt
option add *iv*Listbox.Font $fontdli
option add *iv*Text.Font $fonttt
option add *bv*Listbox.Font $fontdli
option add *bv*Text.Font $fonttt
option add *so*Listbox.Font $fontdli
option add *so*Text.Font $fonttt
option add *ts*Listbox.Font $fontdli
option add *ts*Text.Font $fonttstt
option add *tv*Listbox.Font $fontdli
option add *tv*Text.Font $fonttt
option add *xv*Listbox.Font $fontdli
option add *xv*Text.Font $fonttt

# Klassenbinding fr CAPS_LOCK NUM_LOCK etc.
bind Button <Any-Button> {+
  set pp %s
  # puts " %b %s"
  if {$pp != 0} {
     bell
     set text1 "$vv(xttext1)"
     set text2 "$vv(xttext2)"

     if { [winfo exists .locked] == 1 } {
       destroy .locked
       set text2 "$vv(xttext22)"
     }
     toplevel .locked
     wm title .locked " " 
     label .locked.dv1 -anchor w  -text "$text1" 
     label .locked.dv2 -anchor w  -text "$text2" 
     pack configure .locked.dv1 .locked.dv2 -in .locked -padx 40 -pady 15 -side top

     frame .locked.bv -relief raised -borderwidth 0
     pack configure .locked.bv -after .locked.dv2 -padx 15 -pady 15 -side top

     button .locked.bv.abb -text "$vv(xtbvabb)"
     pack configure .locked.bv.abb -in .locked.bv -padx 15 -pady 5 -side left -anchor n 
     bind .locked.bv.abb <Button-1> {destroy .locked}
     bind .locked.bv.abb <Button-2> {destroy .locked}
     bind .locked.bv.abb <Button-3> {destroy .locked}

  }
}




# Bereich a fuer erste Buttons

frame .a
pack configure .a -in . -side top -anchor w  -fill x

frame .a.1 -relief raised -borderwidth 1
frame .a.11 -relief raised -borderwidth 1
frame .a.2 -relief raised -borderwidth 1

pack configure .a.1 -in .a -side left -anchor w -pady 10 
pack configure .a.11 -in .a -side left -anchor c -pady 10 -expand 1
pack configure .a.2 -in .a -side right -anchor e

button .a.1.e -text "$vv(ae)" -command {#               Ende
  if { $p_mkCmd > 1 } {
    if { [process $p_mkCmd] == 0 } {
      killprocess $p_mkCmd
      bell
      writescr0 .d.tt "***** $vv(xt2)\n      $vv(xt3)\n\n\n"
    } else {
      kill_list "$prliste $logliste"
      destroy .
    }
  } else {
    kill_list "$prliste $logliste"
    destroy .
  }
}
bind   .a.1.e <Button-3> {+ cat_file0 "${hlp_dir}xt_quit.hlp" .d.tt}


                                         #             Hilfen
button .a.1.h -text "$vv(ah)" -command {xtem_hlptext}
bind   .a.1.h <Button-2> {TeX_syntax_help $texfmt}
bind   .a.1.h <Button-3> {xtem_hlptext}

                                         #             Lschen Text-Feld
button .a.1.l -text "$vv(al)" -command {clearscr .d.tt}
bind   .a.1.l <Button-3> {+ cat_file0 "${hlp_dir}z_loeschetf.hlp" .d.tt}

button .a.1.g -text "$vv(ag)" -command {#      Grundstellung
  set oldsuff $texsuffix
  set oldesuff $esuff
  vst_read .d.tt default.vst
  if {$oldsuff != $texsuffix} {set main_file ""}
  if {$oldesuff != $esuff} {set efile $main_file; set esuff $texsuffix}
  mktest
  knoepfe
}
bind   .a.1.g <Button-3> {+ cat_file0 "${hlp_dir}xt_grund.hlp" .d.tt}

pack configure .a.1.e .a.1.h .a.1.l .a.1.g -in .a.1 -side left -padx 3 -pady 3


                                         #             Entriegeln
button .a.11.r -text "$vv(xta11r)" -command {unlock $gesliste};
bind .a.11.r <Button-3> {+ cat_file0 "${hlp_dir}xt_entrieg.hlp" .d.tt}
pack configure .a.11.r -in .a.11 -side left -padx 3 -pady 3


button .a.2.m -text "$vv(xta2m)" -command {#      mkcommand-Auswahl
  lock;  update idletasks
  if {$sub == 0} {
    set sub 1
    if { [winfo exists .xv] } {destroy .xv}
    xv
    bind .xv.a.e <ButtonRelease-1> {+
      destroy .xv 
      mktest
      knoepfe
      unlock_list
    }
  } else {writescr .d.tt "\n$vv(xt9)\n"}
}
bind   .a.2.m <Button-2> {+ writescr0 .d.tt "$vv(xt25)\n";bell}
bind   .a.2.m <Button-3> {+ cat_file0 "${hlp_dir}xt_mkcmd.hlp" .d.tt}
pack configure .a.2.m -in .a.2 -side bottom -padx 3 -pady 3


# Bereich b fuer eigene Voreinstellungen + lokale News

frame .b
pack configure .b -in . -side top -anchor w -fill x

frame .b.1 -relief raised -borderwidth 1
frame .b.2

pack configure .b.1 -in .b -side left -anchor w -pady 6
pack configure .b.2 -after .b.1 -side right

label  .b.1.dv -text "$vv(bvdv)"  -width 23 -anchor w
bind   .b.1.dv <Button-3> {+ cat_file0 "${hlp_dir}xt_voreinst3.hlp" .d.tt}

button .b.1.va -text "$vv(bvva)" -command {
  writescr0 .d.tt "$vv(aus0)\n\n"
  disp_prefs2 .d.tt
}
bind   .b.1.va <Button-3> {+ cat_file0 "${hlp_dir}xt_voreinst3.hlp" .d.tt}

button .b.1.vs -text "$vv(xtb1va)" -command {vst_write .d.tt}
bind   .b.1.vs <Button-3> {+ cat_file0 "${hlp_dir}xt_voreinst3.hlp" .d.tt}

button .b.1.vl -text "$vv(xtb1vl)" -command {
  set oldsuff $texsuffix
  vst_read .d.tt eigene.vst
  if {($oldsuff != "") && ($oldsuff != $texsuffix)} { set main_file "" }
  mktest
  knoepfe
}
bind   .b.1.vl <Button-3> {+ cat_file0 "${hlp_dir}xt_voreinst3.hlp" .d.tt}

pack configure .b.1.dv .b.1.va .b.1.vs .b.1.vl -in .b.1 -side left -padx 3 -pady 3

button .b.2.ln -text "$vv(xtb2ln)" -command {
  lock;  update idletasks;  set sub 1
  set localnews "${hlp_dir}local.news"
  newsfile   .d.tt austext; writescr .d.tt "$austext"     
  unlock_list
}

bind .b.2.ln <Button-3> {+ cat_file0 "${hlp_dir}xt_localnews.hlp" .d.tt}

pack configure .b.2.ln -in .b.2 -padx 3 -pady 3


# Button-Bereich c fuer Aktionen und Bindungen

frame .c
pack configure .c -in . -pady 8


# Button-Bereich .c.1 fuer Aktionen und Bindungen

frame .c.1
frame .c.2
  
pack configure .c.1 .c.2 -in .c -side left -padx 5 -anchor ne


button .c.1.ed -anchor w -width $widthl -command {### Editieren/Editor-Aufruf
  lock;  update idletasks;  set sub 1
  if { $edback == "&" } {
    set ii [lsearch $liste .c.1.ed]
    if { $ii >= 0 } {set liste [lreplace $liste $ii $ii]}
    set edsubback 1
  }
  set pid 0
  editor    .d.tt austext; writescr .d.tt "$austext"
  if { $edback == "&" } {
    if { $pid != 0 } {
      set edsubback $pid 
      set edliste [linsert $edliste 1 $pid]
    } else {
      if { [lsearch $liste .c.1.ed] < 0 } {
        set liste [linsert $liste 1 .c.1.ed]
      }
    }
  }
  if { $edsubback == 0 } {
    if { [lsearch $liste .c.1.ed] < 0 } {
      set liste [linsert $liste 1 .c.1.ed]
    }
  }
  unlock_list
}
bind .c.1.ed <Button-2> {+
  lock;  update idletasks
  if {$sub == 0} {
    set sub 1
    if { [winfo exists .ev] } {destroy .ev}
    ev
    bind .ev.a.e <ButtonRelease-1> {+
      destroy .ev 
      if {$efile == ""} {set esuff ""}
      knoepfe
      if { [lsearch $liste .c.1.ed] < 0 } {
        set liste [linsert $liste 1 .c.1.ed]
      }
      unlock_list
    }
  } else {writescr .d.tt "\n$vv(xt9)\n"}
}
bind .c.1.ed <Button-3> {+ cat_file0 "${hlp_dir}xt_editor.hlp" .d.tt}


button .c.1.la -anchor w -width $widthl -command {### TeX-Aufruf
  unlock_list; # Updating, falls zuletzt Editor verlassen!
  lock;  update idletasks;  set sub 1
  if { ![file exists $main_file$tsuff] } {
            set frage "TeX $vv(xt29) $main_file$tsuff   $vv(ea4)"
  }
  if { "$main_file" == "" } {set frage "$vv(ea1)"}
  if { (![file exists $main_file$tsuff]) || ("$main_file" == "") } {
    if { [winfo exists .t] == 1 } {destroy .t}; toplevel .t
    request .t "$frage" "$vv(xt30)" "$vv(xt31)" te_datei.hlp .d.tt
    bind .t.bv.abb <ButtonRelease-1> {+ # Abbruch (kein TeX-Lauf)
      unlock_list
      destroy .t
    }
    bind .t.bv.aus <ButtonRelease-1> {+ # kein Abbruch (TeX-Lauf)
      destroy .t
      if { "$texmax" > 1 } { set prs_alt [checksum]}
        set texrun 1
        set texerg [tex  .d.tt austext]; writescr .d.tt "$austext" 
        if { $texerg != 1 } {
          if { "$texmax" > 1 } {
            while { "$texrun" < "$texmax" } {
            set prs_neu [checksum] 
            writescr .d.tt "$vv(xt10)=$prs_alt, $vv(xt11)=$prs_neu\n"
            if { "$prs_neu" != "$prs_alt" } {
              incr texrun 
              tex       .d.tt austext; writescr .d.tt "$austext" 
              set prs_alt $prs_neu
            } else {
              writescr .d.tt "\n$vv(xt12)\n(\".aux\" $vv(xt13)\n"
              break
            }
          }
          if { "$texrun" == "$texmax" } {
            set prs_neu [checksum] 
            if { "$prs_neu" != "$prs_alt" } {
              writescr .d.tt "\n\n***** $vv(xt14)\n(\".aux\" $vv(xt15)\n"
              bell  
            }
          }
        }
        lock;  update idletasks;  set sub 1
        tex_post  .d.tt austext; writescr .d.tt "$austext" 
      }
      unlock_list
    }
  } else {
    if { "$texmax" > 1 } {set prs_alt [checksum]}
    set texrun 1
    set texerg [tex  .d.tt austext]; writescr .d.tt "$austext" 
    if { $texerg != 1 } {
      if { "$texmax" > 1 } {
        while { "$texrun" < "$texmax" } {
          set prs_neu [checksum] 
          writescr .d.tt "$vv(xt10)=$prs_alt, $vv(xt11)=$prs_neu\n"
          if { "$prs_neu" != "$prs_alt" } {
            incr texrun
            tex       .d.tt austext; writescr .d.tt "$austext" 
            set prs_alt $prs_neu
          } else {
            writescr .d.tt "\n$vv(xt12)\n(\".aux\" $vv(xt13)\n"
            break
          }
        }
        if { "$texrun" == "$texmax" } {
          set prs_neu [checksum] 
          if { "$prs_neu" != "$prs_alt" } {
            writescr .d.tt "\n\n***** $vv(xt14)\n(\".aux\" $vv(xt15)\n"
            bell  
          }
        }
      }
    lock;  update idletasks;  set sub 1
    tex_post  .d.tt austext; writescr .d.tt "$austext" 
    }
    unlock_list
  }
}
bind .c.1.la <Button-2> {+
  lock;  update idletasks
  if {$sub == 0} {
    set sub 1
    if { [winfo exists .tv] } {destroy .tv}
    tv
    bind .tv.a.e <ButtonRelease-1> {+
      destroy .tv 
      if {$efile == ""} {set esuff ""}
      knoepfe
      unlock_list
    }
  } else {writescr .d.tt "\n$vv(xt9)\n"}
}
bind .c.1.la <Button-3> {+ cat_file0 "${hlp_dir}xt_tex.hlp" .d.tt}


button .c.1.pf -anchor w -width $widthl -command {### Preview-Aufruf
  lock;  update idletasks;  set sub 1
  if {$prback == "&"} {
    set ii [lsearch $liste .c.1.pf]
    if { $ii >= 0 } {set liste [lreplace $liste $ii $ii]}
    set prsubback 1
  }
  set pid 0
  preview   .d.tt austext; writescr .d.tt "$austext"     
  if { $prback == "&" } {
    if { $pid != 0 } {
      set prsubback $pid
      set prliste [linsert $prliste 1 $pid] 
    } else {
      if { [lsearch $liste .c.1.pf] < 0 } {
        set liste [linsert $liste 1 .c.1.pf]
      }
    }
  }
  if { $prsubback == 0 } {
    if { [lsearch $liste .c.1.pf] < 0 } {
      set liste [linsert $liste 1 .c.1.pf]
    }
  }
  unlock_list
}
bind .c.1.pf <Button-2> {+
  lock;  update idletasks
  if {$sub == 0} {
    set sub 1
    if { [winfo exists .pv] } {destroy .pv}
    pv
    bind .pv.a.e <ButtonRelease-1> {+
      destroy .pv 
      if {$main_file == ""} {set psuff  ""} else {set psuff  $prsuffix}
      .c.1.pf configure -text "$vv(xtc1pf)  $preview$prback   $main_file$psuff"
      if { [ lsearch $liste .c.1.pf] < 0 } {
        set liste [linsert $liste 0 .c.1.pf]
      }
      unlock_list
    }
  } else {writescr .d.tt "\n$vv(xt9)\n"}
}
bind .c.1.pf <Button-3> {+ cat_file0 "${hlp_dir}xt_preview.hlp" .d.tt}


button .c.1.fl \
        -text "$vv(xtc1fl)  $logform$logback  $main_file$lsuff" \
        -anchor w -width $widthl -command {### Protokolldatei anschauen
  lock;  update idletasks;  set sub 1
  set pid 0
  logfile   .d.tt austext; writescr .d.tt "$austext"     
  if { $logback == "&" } {
    if { $pid != 0 } {
      set logsubback $pid
      set logliste [linsert $logliste 1 $pid] 
    }
  }
  unlock_list
}
bind .c.1.fl <Button-2> {+
  lock; update idletasks
  if { ( $sub == 0 ) && ( $main_file != "" ) } {
    set sub 1
    if { [winfo exists .lv] } {destroy .lv}
    lv
    bind .lv.a.e <ButtonRelease-1> {+
      destroy .lv 
      .c.1.fl configure -text "$vv(xtc1fl)  $logform$logback  $main_file$lsuff"
      unlock_list
     }
  } else {
    if { $sub == 0 } {
      writescr0 .d.tt "***** $vv(ea1)\n"
      unlock_list
      bell
    } else {writescr  .d.tt "\n$vv(xt9)\n"}
  }
}
bind .c.1.fl <Button-3> {+ cat_file0 "${hlp_dir}xt_seelogs.hlp" .d.tt}


button .c.1.au -text "$vv(xtc1au)" -anchor w -width $widthl -command {### Aufrumen
  lock;  update idletasks;  set sub 1
  clear .d.tt
  bind .ak.a.e <Button-1> {+
    destroy .ak
    unlock_list
  }
}
bind .c.1.au <Button-2> {+ writescr0 .d.tt "$vv(xt16)";bell}
bind .c.1.au <Button-3> {+ cat_file0 "${hlp_dir}xt_delauxs.hlp" .d.tt}


button .c.1.as  -anchor w -width $widthl -command {### Dvi2printer
  lock;  update idletasks;  set sub 1
  writescr0 .d.tt "[datime] $vv(xt16) \n"
  set austext ""
  case [mdtest $main_file $tsuff $asuff austext] {
   -1 { # $main_file or dvi-file doesn't exist
        writescr .d.tt "$austext"
        unlock_list
      } 
    0 { # dvi-file and tex-file exist, but dvi-file is older
        if { [winfo exists .t] == 1 } {destroy .t}; toplevel .t
        set frage "$vv(aus5) $main_file$tsuff $vv(ut13) $main_file$asuff $vv(ut14)"
        request .t "$frage " "$vv(xtrotz)" "$vv(dmaa)" \
                      dm_agedvitex.hlp .d.tt
        bind .t.bv.abb <ButtonRelease-1> {+ # Abbruch (keine Druckaufbereitung)
          destroy .t 
          unlock_list
        }
        bind .t.bv.aus <ButtonRelease-1> {+ # kein Abbruch (Druckaufbereitung) 
          destroy .t
          dvi2printer
        }
      }
    1 { # dvi-Datei ist neuer als TeX-Datei (oder tex-Datei existiert nicht)
        writescr .d.tt "$austext"
        dvi2printer
      }
  }
}
bind .c.1.as <Button-2> {+
  lock;  update idletasks
  if {$sub == 0} {
    set sub 1
    if { [winfo exists .dv] } {destroy .dv}
    dv
    bind .dv.a.1.e <ButtonRelease-1> {+
      destroy .dv 
      .c.1.as configure -text "$vv(xt18) $prtdriver $main_file$asuff -> $printer"
      unlock_list
      if {  [winfo exists .ds] } {destroy .ds; update idletasks}
    }
  } else {writescr .d.tt "\n$vv(xt9)\n"}
}
bind .c.1.as <Button-3> {+ cat_file0 "${hlp_dir}xt_drucker.hlp" .d.tt}

pack configure .c.1.ed .c.1.la .c.1.pf .c.1.fl .c.1.au .c.1.as -in .c.1  -pady 5


# Button-Bereich .c.2 fuer Aktionen und Bindungen

button .c.2.re -anchor w -width $widthr -command {### Rechtschreib-Prfung
  unlock_list; # Updating, falls zuletzt Editor verlassen!
  set frage ""
  if { ($spcorr == "K") && ($edsubback != 0) } {
    set frage "$vv(xt20) $vv(xt200)"
  }
  lock;  update idletasks;  set sub 1
  if { $frage == "" } {
    if { "$spselect" == "S" } rs
    spellcheck .d.tt austext; writescr .d.tt "$austext"
    unlock_list
  } else {
    set antw1 "$vv(xt21)"
    if { [winfo exists .t] == 1 } {destroy .t}; toplevel .t
    request .t "$frage" "$antw1" "$vv(dmaa)" re_konflikt.hlp .d.tt
    bind .t.bv.abb <ButtonRelease-1> {# abbrechen
      destroy .t; update idletasks
      unlock_list
    }
    bind .t.bv.aus <ButtonRelease-1> {# ausfhren
      destroy .t
      if { "$spselect" == "S" } rs
      spellcheck .d.tt austext; writescr .d.tt "$austext"
      unlock_list
    }
  }
}
bind .c.2.re <Button-2> {+
  lock; update idletasks
  if {$sub == 0} {
    set sub 1
    if { [winfo exists .rv] } {destroy .rv}
    rv
    bind .rv.a.e <ButtonRelease-1> {+
      destroy .rv 
      .c.2.re configure -text "$vv(xtc2re) $spcmd $efile$spsuff"
      unlock_list
    }
  } else {writescr .d.tt "\n$vv(xt9)\n"}
}
bind .c.2.re <Button-3> {+ cat_file0 "${hlp_dir}xt_recht.hlp" .d.tt}

button .c.2.sy -anchor w -width $widthr -command {### Syntax-Prfung
  lock;  update idletasks;  set sub 1
  syntax    .d.tt austext; writescr .d.tt "$austext"     
  unlock_list
}
bind .c.2.sy <Button-2> {+
  lock;  update idletasks
  if {$sub == 0} {
    set sub 1
    if { [winfo exists .sv] } {destroy .sv}
    sv
    bind .sv.a.e <ButtonRelease-1> {+
      destroy .sv 
      .c.2.sy configure -text "$vv(xtc2sy) $syntax   $efile$ssuff"
      unlock_list
    }
  } else {writescr .d.tt "\n$vv(xt9)\n"}
}
bind .c.2.sy <Button-3> {+ cat_file0 "${hlp_dir}xt_syntax.hlp" .d.tt}


button .c.2.in -anchor w -width $widthr -command {### Index-Aufbereitung
  lock;  update idletasks;  set sub 1
  index     .d.tt austext; writescr .d.tt "$austext"     
  unlock_list
}
bind .c.2.in <Button-2> {+
  lock;  update idletasks
  if {$sub == 0} {
    set sub 1
    if { [winfo exists .iv] } {destroy .iv}
    iv
    bind .iv.a.e <ButtonRelease-1> {+
      destroy .iv 
      .c.2.in configure -text "$vv(xtc2in) $index $main_file"
      unlock_list
    }
  } else {writescr .d.tt "\n$vv(xt9)\n"}
}
bind .c.2.in <Button-3> {+ cat_file0 "${hlp_dir}xt_index.hlp" .d.tt}


button .c.2.bi -anchor w -width $widthr -command {### BibTeX/Bibliographie
  lock;  update idletasks;  set sub 1
  bibliogr  .d.tt austext; writescr .d.tt "$austext"     
  unlock_list
}
bind .c.2.bi <Button-2> {+
  writescr0 .d.tt "$vv(xt22)\n" \
                 "$vv(xt23)\n"
  #if { [winfo exists .bv] } {destroy .bv}
  #bv
  #bind .bv.a.e <ButtonRelease-1> {+
  #  destroy .bv 
  #  .c.2.bi configure -text "$vv(xtc2bi) $bibtex    $main_file"
  #}
}
bind .c.2.bi <Button-3> {+ cat_file0 "${hlp_dir}xt_bibtex.hlp" .d.tt}


button .c.2.so -text "$vv(xtc2so)" \
                -anchor w -width $widthr -command {### Sonstige Programme
  set frage ""
  if { $edsubback != 0 } {
    set frage "$vv(xt20) $vv(xt201)"
  }
  lock;  update idletasks;  set sub 1
  if { $frage == "" } {
    if { [winfo exist .so] } {
      raise .so
    } else {
      so
      bind .so.a.1.e <Button-1> {+
        destroy .so
        unlock_list
      }
    }
  } else {
    set antw1 "$vv(xt24)"
    if { [winfo exists .t] == 1 } {destroy .t}; toplevel .t
    request .t "$frage" "$antw1" "$vv(dmaa)" so_konflikt.hlp .d.tt
    bind .t.bv.abb <ButtonRelease-1> {# abbrechen
      destroy .t; update idletasks
      unlock_list
    }
    bind .t.bv.aus <ButtonRelease-1> {# ausfhren
      destroy .t
      if { [winfo exist .so] } {
        raise .so
      } else {
        so
        bind .so.a.1.e <Button-1> {+
          destroy .so
          unlock_list
        }
      }
    }
  }
}
bind .c.2.so <Button-2> {+ writescr0 .d.tt "$vv(xt25)";bell}
bind .c.2.so <Button-3> {+ cat_file0 "${hlp_dir}xt_sonstige.hlp" .d.tt}

pack configure .c.2.re .c.2.sy .c.2.in .c.2.bi .c.2.so -in .c.2  -pady 5


knoepfe


set gesliste [list .a.1.e  .a.1.h  .a.1.l  .a.1.g .a.2.m \
                   .b.1.va .b.1.vs .b.1.vl .b.2.ln \
                   .c.1.ed .c.1.la .c.1.pf .c.1.fl .c.1.au .c.1.as \
                   .c.2.re .c.2.sy .c.2.in .c.2.bi .c.2.so]
set liste $gesliste



# Bereich d fuer Hilfe-Ausgaben

frame .d -relief raised -borderwidth 2
pack configure .d -in . -anchor sw -fill both -expand yes

scrollbar .d.sb -command ".d.tt yview"
bind      .d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .d.tt}

text      .d.tt -yscroll ".d.sb set" -height $tyh -font $fonttt
          .d.tt tag configure err -font $fonterr
          .d.tt tag configure end -relief raised -borderwidth 1 -background white
bind      .d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .d.tt}

pack configure .d.sb -in .d -side right -fill y
pack configure .d.tt -in .d -side left -fill both -expand yes

if { $stt != "" } {writescr0 .d.tt $stt; bell}

if { ($main_file == "") || ([testfilename $main_file .d.tt $texsuffix] == 1) } {
  writescr  .d.tt "\n$vv(xt26)\n$vv(xt27)\n"
}
writescr .d.tt "\n$vv(xt28) $vstdat\n"
.d.tt yview 0

if {  $extended !=  "" } {signal trap SIGCHLD {mkCmd_fin}}
if { [info commands mkcommand_v] == "mkcommand_v" } {mktest}
