#
# $Source: /user/nlfm/Working/Zircon/Development/lib/RCS/Log.tcl,v $
# $Date: 1994/03/10 09:45:47 $
# $Revision: 1.15.1.7 $
#
#
proc logOpen {this mode save file} {
    if [string match {} $file] { return 0}
    global Clog Clogfile
    if [catch {open $file $mode} Clog($this)] {
	net0 display ERROR \
	  "*** Cannot open log file for channel [$this name] : $Clog($this)"
	set Clog($this) {}
	return 0
    }
    set Clogfile($this) $file
    set w [$this window].channel.menu.log
    $w entryconfigure 0 -state normal
    $w entryconfigure 1 -state disabled
    $w entryconfigure 2 -state normal
    $w entryconfigure 3 -state normal
    puts $Clog($this) "**** Logging Started : [exec date]"
    if $save {
	puts $Clog($this) "**** Saving Window"
	puts $Clog($this) "[[$this text] get 1.0 end]"
	puts $Clog($this) "**** End of Window Text"
    }
    return 1
}

proc channel_doLog {this op} {
    global Clog Clogfile
    set w [$this window].channel.menu.log
    switch $op {
    Close {
	    if ![string match {} Clog($this)] {
		close $Clog($this)
		set Clog($this) {}
	    }
	    $w entryconfigure 0 -state disabled
	    $w entryconfigure 1 -state normal
	    $w entryconfigure 2 -state disabled
	    $w entryconfigure 3 -state disabled
	}
    Empty {
	    if ![string match {} $Clog($this)] {
		close $Clog($this)
		set Clog($this) [open $Clogfile($this) w]
	    }
	}
    Flush { if [info exists Clog($this)] { flush $Clog($this) } }
    Open {
	    set chan [$this name]
	    set fl [expr {[string match "" $Clogfile($this)] ? \
	      $Clogfile($this) : "${chan}.log"}]
	    mkFileBox .@log$this "Log ${chan}" \
	      "Log file for channel ${chan}:" {} \
	      "Append {logOpen $this a 0 }"\
	      "{Append All} {logOpen $this a 1 }"\
	      "Open {logOpen $this w 0 }" \
	      "{Open from Start} {logOpen $this w 1 }" {Cancel {}}
	}
    }
}
