'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
.so man.macros
.HS dp_atexit tcldp


.SH NAME
.BS
dp_atexit \- arrange for commands to be evaluated when the process is exited.
.BE
.TP
\fBdp_atexit option ?\fIcmd\fR?

The dp_atexit command manages the \fIdp_atexit list\fP, a list of
callback routines that are evaluated just before the tcl+tk application
is exited.  This is useful for applications where clean up actions must be
performed before a process can safely exit.
The argument \fIoption\fP specifies the operation to be performed
on the dp_atexit list.  The valid options are:

.RS
.TP
\fBdp_atexit list

Returns the current dp_atexit list.

.TP
\fBdp_atexit set \fInewList\fP

Sets the dp_atexit list \fInewList\fP.

.TP
\fBdp_atexit append \fIcallback\fP

Append \fIcallback\fP to the end of the dp_atexit list.

.TP
\fBdp_atexit appendUnique \fIcallback\fP

Appends \fIcallback\fP to the end of the dp_atexit list if
it's not already a member of the list.

.TP
\fBdp_atexit prepend \fIcallback\fP

Inserts \fIcallback\fP at the front of the dp_atexit list.

.TP
\fBdp_atexit insert \fIbeforeCallback\fP \fIcallback\fP

Inserts \fIcallback\fP before \fIbeforeCallback\fP in the dp_atexit
list. If \fIbeforeCallback\fP is not in
the dp_atexit list, no action is taken.

.TP
\fBdp_atexit delete \fIcallback\fP

Delete \fIcallback\fP from the dp_atexit list.
If \fIcallback\fP is not in the dp_atexit list, no action is taken.

.TP
\fBdp_atexit clear

Clears the dp_atexit list.

.SH AUTHOR
Brian Smith (bsmith@cs.berkeley.edu)
.br
Steve Yen (syen@cs.berkeley.edu)
