'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
.so man.macros
.HS dp_filehandler tcldp
.BS
.SH NAME
dp_filehandler \- to handle file descriptor conditions
.sp
dp_isready \- Check if a socket has data pending
.sp
dp_update \- Process pending events and/or when-idle handlers
.sp
dp_after \- Execute a command after a certain amount of time has elapsed
.sp
dp_whenidle \- Execute a command when the system is idle
.sp
dp_waitvariable \- Wait for a variable to be modified
.SH SYNOPSIS
\fBdp_filehandler \fIsockId\fR ?\fImode\fR \fIcommand\fR?
.br
\fBdp_isready \fIsockId\fR
.br
\fBdp_update ?\fIidletasks\fR?
.br
\fBdp_after ms ?\fIarg1 arg2 arg3 ...\fR?
.br
\fBdp_whenidle command ?\fIarg1 arg2 arg3 ...\fR?
.br
\fBdp_waitvariable variable\fR
.BE
.SH DESCRIPTION
.LP

The dp_isready command checks whether \fIsockId\fP is readable or
writeable using a select(2) system call.  It returns a list of up two
boolean values (i.e., 1 or 0).  The first value specifies whether
\fIsockId\fP is readable, and the second value specifies whether
\fIsockId\fP is writeable.  For example, the tcl expression

.RS
if [lindex [dp_isready file3] 1] {MyOutput file3}
.RE

calls MyOutput if file3 is writeable.

The dp_update command is equivalent to the Tk "update" command,
except that it operates even if a connection to the X server is not
present.  See the Tk documentation on "update" for an explanation of
it's usage.

The dp_after command is equivalent to the Tk "after" command,
except that it operates even if a connection to the X server is not
present.  See the Tk documentation on "after" for an explanation of
it's usage.

The dp_whenidle command arranges for the specified Tcl/Tk \fIcommand\fR
to be evaluated whenever the system is about to go to sleep waiting for
an event to occur.

The dp_waitvariable command is equivalent to the Tk "tkwait variable"
command, except that it operates even if a connection to the X server
is not present.  See the Tk documentation on "tkwait" for an explanation of
it's usage.

The dp_filehander command allows one to specify a Tcl/Tk
\fIcommand\fR which will be evaluated whenever the file descriptor
represented by \fIsockId\fR is readable, writable, and/or has an
exceptional condition pending.  \fICommand\fR will be invoked with two
arguments appended: a single character indicating the \fImode\fR
('r', 'w', or 'e'), and the \fIsockId\fR.

A \fIsockId\fR is an identifier which represents a file descriptor.  It
is identical to the identifier manipulated by the Tcl-DP (Tcl
Distributed Programming) network connection management commands
(dp_connect, dp_shutdown, etc.).  \fISockId\fR's are also
manipulated by the read, eof, gets, puts, and close file management
commands of Tcl.

The \fImode\fR argument indicates the situations when the \fIcommand\fR
will be evaluated.  It may be any combination of the following values:

.RS
.TP
\fBr\fR
Eval \fIcommand\fR whenever there is data to be read from the
\fIsockId\fR.  The \fIcommand\fR is evaluated with two arguments
appended: \fBr\fR to indicate that data is readable on the file
descriptor, and the \fIsockId\fR, which represents the file descriptor
that is readable.  The \fIcommand\fR should read at least some data
from the \fIsockId\fR, or otherwise \fIcommand\fR will be called
continuously.

.TP
\fBw\fR
Eval \fIcommand\fR whenever data can be written to the \fIsockId\fR
without blocking.  The \fIcommand\fR is evaluated with two arguments
appended: \fBw\fR to indicate that the file descriptor is writable, and
the \fIsockId\fR, which represents the writable file descriptor.

.TP
\fBe\fR
Eval \fIcommand\fR whenever there is an exceptional condition pending
on the \fIsockId\fR.  The \fIcommand\fR is evaluated with two arguments
appended: \fBe\fR to indicate exception, and the \fIsockId\fR, which
represents the file descriptor with the exceptional condition.
.RE

If the \fImode\fR and \fIcommand\fR arguments are not specified, then
any previously specified \fIcommand\fR for the given \fIsockId\fR is
deleted.  Specifying a new \fIcommand\fR using the dp_filehandler
command will also delete any previously specified \fIcommand\fR for a
\fIsockId\fR.

.SH EXAMPLE

The following file handlers create a telnet like interface to the
sendmail process (the smtp port) running on the local host.  The command
"say" sends the string passed to it to sendmail.  The reply is
automatically printed on stdout by the get_remote procedure.

.DS
proc get_remote {mode fid} {
    # Exit if remote connection closed on us.
    if {[gets $fid input] == -1} {
	puts stdout "Connection closed by foreign host."
	exit
    }
    puts stdout $input
}

proc say {args} {
    global remote
    puts $remote $args;
}

set remote [lindex [dp_connect localhost smtp] 0]
dp_filehandler $remote r get_remote
.DE

.SH SEE ALSO
Tcl-DP, select(2)
.SH AUTHOR
Pekka Nikander, Telecom Finland (Pekka.Nikander@ajk.tele.fi)
.br
Extended by Tim MacKenzie (tym@dibbler.cs.monash.edu.au)
.br
Further enhancements by Brian Smith (bsmith@cs.berkeley.edu)
.br
and Steve Yen (syen@cs.berkeley.edu)
