/*
 * util.h
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#ifndef _X_LIB_H_
#include <X11/Xlib.h>
#endif

/* adjust.c */
extern void		InitAdjustment(void);
extern int		AdjustWidth(int, int);
extern int		AdjustHeight(int, int);
extern int		ReAdjustWidth(int, int);
extern int		ReAdjustHeight(int, int);
extern int		AdjustX(int, int);
extern int		AdjustY(int, int);
extern int		ReAdjustX(int, int);
extern int		ReAdjustY(int, int);

/* callback.c */
extern void		EnterLeave(HWND, int, int, int);
extern LRESULT CALLBACK	DeliverEnterLeave(int, WPARAM, LPARAM);
extern void		SetHookDeliverEL(HHOOK);

/* chain.c  */
extern XEvent *		getEvent(Display *, XEvent *);
extern XEvent *		getFileEvent(Display *, XEvent *);
extern XEvent *		getTimerEvent(Display *, XEvent *);
extern XEvent *		peekEvent(Display *, _XQEvent *, XEvent *);
extern XEvent *		peekFileEvent(Display *, _XQEvent *, XEvent *);
extern XEvent *		peekTimerEvent(Display *, _XQEvent *, XEvent *);
extern void		discardEvent(Display *, _XQEvent *);
extern void		discardFileEvent(Display *, _XQEvent *);
extern void		discardTimerEvent(Display *, _XQEvent *);
extern _XQEvent *	putEvent(Display *, XEvent *);
extern _XQEvent *	putFileEvent(Display *, XEvent *);
extern _XQEvent *	putTimerEvent(Display *, XEvent *);
extern _XQEvent *	putbackEvent(Display *, XEvent *);

/* cursor.c */
extern void		SetDefaultCursor(HCURSOR);
extern HCURSOR		GetDefaultCursor(void);
extern HCURSOR		FindCursor(HWND);

/* icon.c */
extern void 		SetXIcon(Display *, HWND, void *);
extern void 		UpdateXIcon(Display *, HWND);
extern HICON		GetXIcon(Display *, HWND);

/* instance.c */
extern void		SetAppInstance(HINSTANCE);
extern HINSTANCE	GetAppInstance(void);
extern void		SetPostWindow(HWND);
extern HWND		GetPostWindow(void);
extern void		DestroyPostWindow(void);

/* sockutil.c */
extern int		CreateSocketPair(void *sockPair);

/* termproc.c */
extern HWND		CreateTerminal(HANDLE);
extern void		CreateTclTerminal(HANDLE, int);
extern void		DestroyTclTerminal(void);

/* window.c */
extern unsigned char	_SetWindowChanges(HWND, unsigned long, XWindowChanges *);
extern unsigned char	_SetWindowAttributes(HWND, unsigned long, XSetWindowAttributes *);
extern unsigned char	_GetWindowAttributes(HWND, XWindowChanges *);

/* xseterrh.c */
extern void		postError(unsigned char, HWND);

/* msg3event.c */
extern short		msgGetState(int);
extern int		msg3event(Display *, MSG *, XEvent *);

/* xgrab.c */
extern int		pointerGrabbed;
extern int		keyboardGrabbed;

/* xpixmap.c */
extern int		IsPixmap(Drawable);
extern unsigned char	_GetPixmapAttributes(Pixmap, XWindowChanges *);

/* panic.c */
extern void		panic();
