/* 
 *	wndproc.h
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
			
#include <windows.h>			
				   
#define HDC_OFFSET		0	       
#define HCCS_OFFSET 		4
#define HPCS_OFFSET		8
#define XSWA_OFFSET 		12
#define XWCH_OFFSET 		16
#define CONTEXT_OFFSET		20
#define HICO_OFFSET		24
#define LAST_OFFSET		28


#define INPUTNOTIFY		WM_USER
#define SOCKETNOTIFY		WM_USER+1
#define TIMERNOTIFY		WM_TIMER

#define CHANGEBACKGROUND	WM_USER+9

#define CREATENOTIFY		WM_USER+10
#define FOCUSIN			WM_USER+11
#define FOCUSOUT		WM_USER+12
#define CONFIGURENOTIFY		WM_USER+13
#define MAPNOTIFY		WM_USER+14
#define UNMAPNOTIFY		WM_USER+15
#define SELECTIONCLEAR		WM_USER+16
#define CLIENTMESSAGE		WM_USER+17
#define ACTIVATEAPP		WM_USER+18
/* COLORNOTIFY is used to tell when the system color information changed */
#define SYSCOLORNOTIFY		WM_USER+19
#define WM_NO_BUFFERED		WM_USER+20
#define XERRORNOTIFY		WM_USER+21
#define TKW_SELECTIONSAVE	WM_USER+22

#define DESTROYNOTIFY		WM_QUIT
#define BUTTONPRESS		WM_LBUTTONDOWN
#define BUTTONRELEASE		WM_LBUTTONUP
#define MOTIONNOTIFY		WM_MOUSEMOVE
#define KEYPRESS		WM_KEYDOWN
#define KEYRELEASE		WM_KEYUP
#define EXPOSE			WM_PAINT


// Use this when an event is added to the X event queue so the waiting
// loop can see something.
#define EVENTADDED      WM_USER+100

/*
 * declare for internal functions
 */

extern void 	 		RegisterWidgetClass(HINSTANCE);
extern void 	 		RegisterTerminalClass(HINSTANCE);
extern void 			RegisterTopLevelClass(HINSTANCE);

extern LRESULT CALLBACK 	WidgetProc(HWND, UINT, WPARAM, LPARAM);
extern LRESULT CALLBACK		TerminalProc(HWND, UINT, WPARAM, LPARAM);
extern LRESULT CALLBACK		TopLevelProc(HWND, UINT, WPARAM, LPARAM);

extern int TclMain(int, char **); 

