/*
 * adjust.c --
 *
 *	This module handles any differences between the geometries
 *	used in Windows and those expected by an X client.
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include "xlibInt.h"

static int cxFrame;
static int cyFrame;
static int cyCaption;

void
InitAdjustment(void)
{
    cxFrame =	GetSystemMetrics(SM_CXFRAME);
    cyFrame =	GetSystemMetrics(SM_CYFRAME);
    cyCaption =	GetSystemMetrics(SM_CYCAPTION);
}

/*
 *----------------------------------------------------------------------
 *
 * AdjustHeight, ReAdjustHeight, 
 * AdjustWidth,  ReAdjustWidth, 
 * AdjustX,      ReAdjustX, 
 * AdjustY,      ReAdjustY --
 *
 *	These routines convert between X and Windows geometries.
 *	The Adjust*() routines convert from an X geometry to a
 *	Windows geometry, and the ReAdjust*() routines convert
 *	from a Windows geometry to an X geometry.  If the 'flag'
 *	argument is non-zero, the window is a TopLevel window.
 *	These routines should all be inline functions.
 *
 * Return:
 *	The adjusted geometry
 *
 * Side Effects:
 *	None
 *
 *----------------------------------------------------------------------
 */

AdjustWidth(int width, int flag)
{
    return flag ? width : width + (cxFrame * 2);
}

int
AdjustHeight(int height, int flag)
{
    height -= 1;
    return flag ? height : height + cyCaption + (cyFrame * 2);
}

int
ReAdjustWidth(int width, int flag)
{
    return flag ? width : width - (cxFrame * 2);
}

int
ReAdjustHeight(int height, int flag)
{
    height += 1;
    return flag ? height : height - cyCaption - (cyFrame * 2);
}

int
AdjustX(int x, int flag)
{
    return flag ? x : x - cxFrame;
}

int
AdjustY(int y, int flag)
{
    return flag ? y : y - (cyCaption + cyFrame) + 1;
}

int
ReAdjustX(int x, int flag)
{
    return flag ? x : x + cxFrame;
}

int
ReAdjustY(int y, int flag)
{
    return flag ? y : y + (cyCaption + cyFrame) - 1;
}

