/*
 * cursor.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include "xlibInt.h"

static HCURSOR hDefaultCursor;

/*
 *----------------------------------------------------------------------
 *
 * SetDefaultCursor --
 *
 *	Set the default cursor for a window when no cursor for the
 *	window or its ancestors has been set.
 *
 * Results:
 * 	None
 *
 * Side Effects:
 *	None
 *
 *----------------------------------------------------------------------
 */
void
SetDefaultCursor(HCURSOR hcs)
{
    hDefaultCursor = hcs;
}

/*
 *----------------------------------------------------------------------
 *
 * FindCursor --
 *
 *	Find the cursor shape to be displayed when the cursor is
 *	over the given window.  If no cursor is set for the particular
 *	window, then the parent is checked recursively until a
 *	cursor is found or until the desktop window is hit.  In this
 *	case, the default cursor shape is used.
 *
 * Results:
 *	A Windows cursor object
 *
 * Side Effects:
 *	None
 *
 *----------------------------------------------------------------------
 */
HCURSOR
FindCursor(HWND hwnd)
{
    HCURSOR hcs;

    if (hwnd == HWND_DESKTOP) {
    	return hDefaultCursor;
    }

    hcs = (HCURSOR) GetWindowLong(hwnd, HCCS_OFFSET);
    if (hcs != NULL) {
	return hcs;
    }

    return FindCursor(GetParent(hwnd));
}
