/*
 * xpropert.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include "xlibInt.h" 

static void		_ChangeProperty(Window, char *, char *, int, Atom);

Status
XStringListToTextProperty(char **list, int n, XTextProperty *ptp)
{
    ptp->value = (unsigned char *)malloc(strlen(*list) + 1);
    strcpy(ptp->value, *list);
    return 1;
}

void
XSetWMName(Display *display, Window w, XTextProperty *ptp)
{
    char propName[8];

    display->request++;

    sprintf(propName, "#0x%0.4x", XA_WM_NAME);
    _ChangeProperty(w, propName, ptp->value, strlen(ptp->value)+1,
		    XA_STRING);
    SetWindowText(w, ptp->value);
}

void
XSetWMClientMachine(Display *display, Window w, XTextProperty *ptp)
{
    char propName[8];

    display->request++;

    sprintf(propName, "#0x%0.4x", XA_WM_CLIENT_MACHINE);
    _ChangeProperty(w, propName, ptp->value, strlen(ptp->value)+1,
		    XA_STRING);
}

void
XSetIconName(Display *display, Window w, const char *p)
{
    XTextProperty tp;
    char propName[8];

    display->request++;

    sprintf(propName, "#0x%0.4x", XA_WM_ICON_NAME);
    XStringListToTextProperty((char **)&p, 1, &tp);
    _ChangeProperty(w, propName, tp.value, strlen(tp.value)+1,
		    XA_STRING);
    SendMessage(w, WM_SIZE, SIZE_MINIMIZED, 0L);
    XFree(tp.value);
}        	   

static void
_ChangeProperty(Window w, char *np, char *dp, int n, Atom type)
{
    HGLOBAL hMem;
    char *p;

    hMem = GetProp(w, np);
    if (hMem != NULL) {
	GlobalFree(hMem);
    }
    hMem = GlobalAlloc(GHND, n + sizeof(Atom));
    p = (char *) GlobalLock(hMem);
    memcpy(p, &type, sizeof(Atom));
    memcpy(p + sizeof(Atom), dp, n);
    GlobalUnlock(hMem);
    SetProp(w, np, hMem);
}

void
XDeleteProperty(Display *display, Window w, Atom p)
{
    HGLOBAL hMem;

    display->request++;

    if ((hMem = GetProp(w, (unsigned char *) p)) != NULL)
	GlobalFree(hMem);
}

void
XSetCommand(Display *display, Window w, char **argv, int argc)
{
    display->request++;
}

int
XSetTransientForHint(Display *display, Window w, Window prop_window)
{
    HGLOBAL hMem;
    Window *old_wp, old_w;
    char *ptr;
    char propName[8];

    display->request++;

    sprintf(propName, "#0x%0.4x", XA_WM_TRANSIENT_FOR);
    hMem = GetProp(w, propName);
    if (hMem != NULL) {
	ptr = ((char *) GlobalLock(hMem)) + sizeof(Atom);
	old_wp = (Window *) ptr;
	old_w = *old_wp;
	GlobalUnlock(hMem);
    } else {
	old_w = None;
    }

    if (old_w != w) {
	_ChangeProperty(w, propName,
			(char *) &prop_window, sizeof(Window), XA_WINDOW);
	if (old_w != None && prop_window == None) {
	    SetWindowPos(w, HWND_NOTOPMOST, 0, 0, 0, 0,
			 SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOSIZE);
	} else if (old_w == None && prop_window != None) {
	    SetWindowPos(w, HWND_TOPMOST, 0, 0, 0, 0,
			 SWP_NOACTIVATE|SWP_NOMOVE|SWP_NOSIZE);
	}
    }
    return Success;
}        	   

/*
 * XSetWMNormalHints --
 *
 */

void
XSetWMNormalHints(Display *display, Window w, XSizeHints *hints)
{
    char propName[8];

    display->request++;

    sprintf(propName, "#0x%0.4x", XA_WM_NORMAL_HINTS);
    _ChangeProperty(w, propName, (char *) hints, sizeof(XSizeHints),
		    XA_WM_NORMAL_HINTS);
}

/*
 * XSetWMHints --
 *
 */

void
XSetWMHints(Display *display, Window w, XWMHints *wmhints)
{
    char propName[8];

    display->request++;

    sprintf(propName, "#0x%0.4x", XA_WM_HINTS);
    _ChangeProperty(w, propName, (char *) wmhints, sizeof(XWMHints),
		    XA_WM_HINTS);

    SetXIcon(display, w, wmhints);
}

void
XChangeProperty(Display *display, Window w, Atom property, Atom type,
		int format, int mode, const unsigned char *data,
		int nelements)
{
    display->request++;

    if (mode == PropModeReplace || mode == PropModePrepend) {
	/* Get the current value and check types, then create the new data */
    }
}
