/*
 * xseterrh.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include "xlibInt.h" 

extern XErrorHandler errorHandler;                          

int
DefaultErrorHandler(display, error)
Display *display;
XErrorEvent *error;
{
    char text [256];
    char *type;

    switch (error->error_code) {
    case BadRequest:
    	type = "BadRequest"; break;
    case BadValue:
    	type = "BadValue"; break;
    case BadWindow:
    	type = "BadWindow"; break;
    case BadPixmap:
    	type = "BadPixmap"; break;
    case BadAtom:
    	type = "BadAtom"; break;
    case BadCursor:
    	type = "BadCursor"; break;
    case BadFont:
    	type = "BadFont"; break;
    case BadMatch:
    	type = "BadMatch"; break;
    case BadDrawable:
    	type = "BadDrawable"; break;
    case BadAccess:
    	type = "BadAccess"; break;
    case BadAlloc:
    	type = "BadAlloc"; break;
    case BadColor:
    	type = "BadColor"; break;
    case BadGC:
    	type = "BadGC"; break;
    case BadIDChoice:
    	type = "BadIDChoice"; break;
    case BadName:
    	type = "BadName"; break;
    case BadLength:
    	type = "BadLength"; break;
    case BadImplementation:
    	type = "BadImplementation"; break;
    default:
    	type = "unknown error type";
    }
    
    sprintf(text, "  Error of faild request: %s\n  Resource id in faild request: %x", type, error->resourceid);
    MessageBox(0, text, "Error Handler", 0);
    return 0;
}
 
 
//(* XSetErrorHandler(handler))()
//int (* handler)(Display *, XErrorEvent *);
XErrorHandler XSetErrorHandler(XErrorHandler handler)
{
    XErrorHandler prev;

    prev = errorHandler;
    if (handler == NULL) {
    	errorHandler = &DefaultErrorHandler;
    } else {
    	errorHandler = handler;
    }
    return prev;
}


void
postError(unsigned char code, HWND id)
{
    SendMessage(GetPostWindow(), XERRORNOTIFY, (WPARAM)code, (LPARAM)id);
}
