/*
 * xwinattr.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include "xlibInt.h" 

void
XChangeWindowAttributes(Display *display, Window w, unsigned long valuemask, 
	XSetWindowAttributes *attributes)
{
    unsigned char result;

    display->request++;

    if ((result = _SetWindowAttributes(w, valuemask, attributes)) != Success)
    	postError(result, (HWND) w);
}

void
XSetWindowBackground(Display *display, Window w, unsigned long background_pixel)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    display->request++;

    attrs.background_pixel = background_pixel;
    if ((result = _SetWindowAttributes(w, CWBackPixel, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void
XSetWindowBackgroundPixmap(Display *display, Window w, Pixmap background_pixmap)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    display->request++;

    attrs.background_pixmap = background_pixmap;
    if ((result = _SetWindowAttributes(w, CWBackPixmap, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void
XSetWindowBorder(Display *display, Window w, unsigned long border_pixel)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    display->request++;

    attrs.border_pixel = border_pixel;
    if ((result = _SetWindowAttributes(w, CWBorderPixel, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void
XSetWindowBorderPixmap(Display *display, Window w, Pixmap border_pixmap)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    display->request++;

    attrs.border_pixmap = border_pixmap;
    if ((result = _SetWindowAttributes(w, CWBorderPixmap, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void
XSetWindowColormap(Display *display, Window w, Colormap colormap)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    display->request++;

    attrs.colormap = colormap;
    if ((result = _SetWindowAttributes(w, CWColormap, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void
XSelectInput(Display *display, Window w, long event_mask)
{
    XSetWindowAttributes attrs;

    display->request++;

    attrs.event_mask = event_mask;
    _SetWindowAttributes(w, CWEventMask, &attrs);
}

void
XSetClassHint(Display *display, Window w, XClassHint *class_hints)
{
    /* Don't do anything, at least for now */
    display->request++;
}

Status
XGetGeometry(Display *display, Drawable drawable, Window *root_return,
	     int *x_return, int *y_return,
	     unsigned int *width_return, unsigned int *height_return,
	     unsigned int *border_width_return, unsigned int *depth_return)
{
    unsigned char ret;
    XWindowChanges attrs;

    display->request++;

    if (!IsPixmap(drawable)) {
	ret = _GetWindowAttributes(drawable, &attrs);
    } else {
	ret = _GetPixmapAttributes(drawable, &attrs);
    }
    if (ret == Success) {
	*width_return = attrs.width;
	*height_return = attrs.height;
	*border_width_return = attrs.border_width;
	*depth_return = display->screens->root_depth;
    }
    return ret;
}
