# For more info on DDE messages, see Win32 or Windows 3.1 docs

# Toggle between displaying the Program Manager group 'Main' as an
# open window and as an icon

puts "Toggling between displaying the Program Manager"
puts "group 'Main' as an open window and as an icon."
puts ""

# Tests for ddd_execute
set max 2
for {set i 0} {$i < $max} {incr i} {

  dde_execute progman progman {[ShowGroup("Main",4)]}
  after 500
  dde_execute progman progman {[ShowGroup("Main",7)]}

  if {$i < [expr $max-1]} {
    after 500;
  }
}

# Get a list of program groups in the Program Manager

set groups [dde_request progman progman progman]

while {1} {
  set index [string first "
" $groups]

  if {$index == -1} {
    break;
  }
  set group [string range $groups 0 [expr $index-2]]
  set groups [string range $groups [expr $index+1] end]

  puts "$group"
  puts "----------------------------------------------------------"

  set progs [dde_request progman progman $group]

  # The first string that we print is the status of the group window
  while {1} {
    set index [string first "
" $progs]

    if {$index == -1} {
      break;
    }
    set prog [string range $progs 0 [expr $index-2]]
    set progs [string range $progs [expr $index+1] end]

    puts "    $prog"
  }
  puts ""

}

#puts "Program Groups in Program Manager"
#puts "-------------------------------------------------"
#puts "[dde_request progman progman progman]"
#
#puts "Programs in 'Main' Program Group"
#puts "-------------------------------------------------"
#puts "[dde_request progman progman Main]"

#puts "[dde_request progman progman -timeout 1000 Main]"

exit
