/* 
 * tbconver.c
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include "tbscan.h"
#include <ctype.h>
#include <limits.h>
#include <string.h>

char *
convert(int conv, int width, char pref, char *pfmt, sinfo *sp)
{
    char ch;
    char *p, *q;
    char *set;
    int len;
    int not = 0;
    int base;
    int exist;
    char buffer[BUFFER_LEN];

    sp->result = 0;
    switch (*pfmt) {
    case 'd':   case 'i':   case 'o':
    case 'u':   case 'x':
    case 'p':
	base = getBase(*pfmt);
	if (getint(buffer, width, &base, sp) && conv) {
	    if (convint(buffer, *pfmt, pref, base, sp)) {
		sp->result = 1;
	    }
	}
	return ++pfmt;
    case 'c':
	if (conv) {
	    q = p = va_arg(sp->ap, char *);
	}
	for (sp->nget = width ? width : 1; sp->nget; (sp->nget)--) {
	    if ((ch = Getch(sp)) < 0) {
		return NULL;
	    }
	    if (conv) {
		*p++ = ch;
		sp->result = 1;
	    }
	}
	return ++pfmt;
    case 's':
	if (conv) {
	    q = p = va_arg(sp->ap, char *);
	}
	sp->nget = width ? width : 32767;
	for (exist = 0; (ch = Getnch(sp)) >= 0; ) {
	    if (isspace(ch)) {
		break;
	    }
	    if (conv) {
		*p++ = ch;
		exist = 1;
	    }
	}
	if (exist && conv) {
	    *p = '\0';
	    sp->result = 1;
	}
	Ungetnch(sp, ch);
	return ++pfmt;
    case 'e':   case 'f':   case 'g':
	if (getfloat(buffer, width, sp) && conv) {
	    if (convfloat(buffer, pref, sp)) {
		sp->result = 1;
	    }
	}
	return ++pfmt;
    case 'n':
	if (pref = 'h') {
	    *va_arg(sp->ap, short *) = sp->nchar;
	} else if (pref != 'l') {
	    *va_arg(sp->ap, int *) = sp->nchar;
	} else {
	    *va_arg(sp->ap, long *) = sp->nchar;
	}
	return ++pfmt;
    case '[':
	if (*++pfmt == '^') {
	    not = 1;
	    set = ++pfmt;
	} else {
	    set = pfmt;
	}
	len = (int) ((long) strchr(*set == ']' ? set + 1 : set, ']') - (long)set);
	if (len < 0) {
	    return NULL;
	}
	sp->nget = width ? width : INT_MAX;
	if (conv) {
	    p = va_arg(sp->ap, char *);
	}
	sp->nget = width ? width : 32767;
	while ((ch = Getnch(sp)) >= 0) {
	    if (!not && !memchr (set, ch, len)
		    || not && memchr(set, ch, len)) {
		break;
	    }
	    if (conv) {
		*p++ = ch;
	    }
	}
	if (conv) {
	    *p = '\0';
	    sp->result = 1;
	}
	Ungetnch(sp, ch);
	return pfmt + len + 1;
    case '%':
	if ((ch = Getch(sp)) == '%') {
	    return ++pfmt;
	} else {
	    Ungetch(sp, ch);
	    return NULL;
	}
    default:
	return NULL;
    }
}
