/* 
 * tbconvin.c
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include "tbscan.h"
#include <stdlib.h>

int
convint(char *buffer, char type, char pref, int base, sinfo *sp)
{
    if (type == 'd' || type == 'i') {
       long value = strtol(buffer, NULL, base);

	if (pref == 'h') {
	    *va_arg(sp->ap, short *) = (short) value;
	} else if (pref != 'l') {
	    *va_arg(sp->ap, int *) = (int) value;
	} else {
	    *va_arg(sp->ap, long *) = (long) value;
	}
    } else {
	unsigned long value = strtoul(buffer, NULL, base);

	if (pref == 'p') {
	    *va_arg(sp->ap, void **) = (void *) value;
	} else if (pref == 'h') {
	    *va_arg(sp->ap, unsigned short *) = (unsigned short) value;
	} else if (pref != 'l') {
	    *va_arg(sp->ap, unsigned int *) = (unsigned int) value;
	} else {
	    *va_arg(sp->ap, unsigned long *) = (unsigned long) value;
	}
    }
    return 1;
}

