/* 
 * tbgetint.c
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include "tbscan.h"
#include <string.h>

int isDigits(char, int);
int getBase(char);

int
getint(char *buffer, int width, int *base, sinfo *sp)
{
    char *pb;
    int ch;
    int exist = 0;

    sp->nget = (width <= 0 || BUFFER_LEN < width) ? BUFFER_LEN : width;
    pb = buffer;

    ch = Getnch(sp);
    if (ch == '+' || ch == '-') {
	*pb++ = ch;
	ch = Getnch(sp);
    }
    if (ch == '0') {
	*pb++ = ch;
	ch = Getnch(sp);
	if ((ch == 'x' || ch == 'X') && (*base == 0 || *base == 16)) {
	    *pb++ = ch;
	    ch = Getnch(sp);
	    *base = 16;
	} else {
	    *base = 8;
	    exist = 1;
	}
    }
    while (isDigits((char) ch, *base)) {
	*pb++ = ch;
	ch = Getnch(sp);
	exist = 1;
    }
    Ungetnch(sp, ch);
    *pb = '\0';
    return exist;
}

isDigits(char ch, int base)
{
    switch (base) {
    case 16:
	if (strchr("abcdefABCDEF", ch)) {
	    return 1;
	}
    case 10:
    case  0:
	if (strchr("89", ch)) {
	    return 1;
	}
    case  8:
	if (strchr("01234567", ch)) {
	    return 1;
	}
    default:
	return 0;
    }
}

int getBase(char type)
{
    switch (type) {
    case 'd':
    case 'u':
	return 10;
    case 'i':
	return 0;
    case 'o':
	return 8;
    case 'x':
	return 16;
    default:
	return -1;
    }
}
