/* 
 * tbgetung.c
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include "tbscan.h"

int
Getch(sinfo *sp)
{
    char *s = *(sp->str);
    if (*s == '\0') {
	return EOF;
    } else {
	sp->nchar++;
	*(sp->str) = s + 1;
	return *s;
    }
}

int
Getnch(sinfo *sp)
{
    if (sp->nget == 0) {
	return NCHAR;
    } else {
	sp->nget--;
	return Getch(sp);
    }
}

void
Ungetch(sinfo *sp, int ch)
{
    sp->nchar-- ;
    if (ch >= 0) {
    	*(sp->str) = *(sp->str) - 1;
    }
}

void
Ungetnch(sinfo *sp, int ch)
{
    if (ch == NCHAR) {
	return;
    } else {
	(sp->nget)++;
	Ungetch(sp, ch);
    }
}

