/* 
 * tbscan.c
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include "tbscan.h"
#include <ctype.h>
#include <string.h>
#ifdef KANJI
#include <mbctype.h>
#else
#include <ctype.h>
#endif
int
TbSscanf(char *string, char *format, ...)
{
    sinfo si;
    int width;
    int conv;
    int num = 0;
    char ch;
    char pref;
    char *pfmt = format;
    va_list arg_ptr;

    va_start(arg_ptr, format);
    si.ap = arg_ptr;
    si.str = &string;
    si.nchar = 0;

    while (pfmt) {
	while (*pfmt != '%') {
	    if (isspace(*pfmt)) {
		while (isspace(*++pfmt))
		    ;
		while (isspace(ch = Getch(&si)))
		    ;
		Ungetch(&si, ch);
	    } else {
#ifdef KANJI
		reteral_match:
#endif /* KANJI */		
		if ((ch = Getch(&si)) != *pfmt) {
		    Ungetch(&si, ch);
		    return num;
		}
#ifdef KANJI
		if (_ismbblead(*pfmt)) {
		    pfmt++;
		    goto reteral_match;
		}
#endif	/* kanji */	
		pfmt++;
	    }
	}
	if(*++pfmt == '\0') {
	    return num;
	}
	conv = 1;
	if(*pfmt == '*') {
	    conv = 0;
	    pfmt++;
	}
	for (width = 0; isdigit(*pfmt); pfmt++) {
	    width = width * 10 + *pfmt - '0';
	}
	pref = strchr("hlL", *pfmt) ? *pfmt++ : '\0';
	if (!strchr("cn[", *pfmt)) {
	    while (isspace(ch = Getch(&si)))
		;
	    Ungetch(&si, ch);
	}
	if ((pfmt = convert(conv, width, pref, pfmt, &si)) == NULL) {
	    return num;
	}
	if (si.result) {
	    num++;
	}
    }
    return num;
}
