/*
 * adjust.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */

#include <windows.h>
#include "util.h"

static int cxFrame;
static int cyFrame;
static int cyCaption;

void NEAR PASCAL
InitAdjustment(void)
{
    cxFrame =	GetSystemMetrics(SM_CXFRAME);
    cyFrame =	GetSystemMetrics(SM_CYFRAME);
    cyCaption =	GetSystemMetrics(SM_CYCAPTION);
}

int NEAR PASCAL
AdjustWidth(int width, int flag)
{
    return flag ? width : width + (cxFrame * 2);
}

int NEAR PASCAL
AdjustHeight(int height, int flag)
{
    height -= 1;
    return flag ? height : height + cyCaption + (cyFrame * 2);
}

int NEAR PASCAL
ReAdjustWidth(int width, int flag)
{
    return flag ? width : width - (cxFrame * 2);
}

int NEAR PASCAL
ReAdjustHeight(int height, int flag)
{
    height += 1;
    return flag ? height : height - cyCaption - (cyFrame * 2);
}

int NEAR PASCAL
AdjustX(int x, int flag)
{
    return flag ? x : x - cxFrame;
}

int NEAR PASCAL
AdjustY(int y, int flag)
{
    return flag ? y : y - (cyCaption + cyFrame);
}

int NEAR PASCAL
ReAdjustX(int x, int flag)
{
    return flag ? x : x + cxFrame;
}

int NEAR PASCAL
ReAdjustY(int y, int flag)
{
    return flag ? y : y + (cyCaption + cyFrame);
}

